/*
### create integration windows ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>

void create_int_windows()
{
	void int_quit_proc(),int_driver_proc(),int_option_proc(),int_algorithm_proc();
	int i,ipanel_row=0;
	extern Frame frame,int_frame;
	extern Panel int_panel;
	extern Pixfont *boldfont;
	extern Panel_item int_quit_item,int_driver_item,int_algorithm_item,int_option_item,int_start_item,int_end_item,int_period_item;
	extern Panel_item int_eps_item,int_guessed_step_item,int_min_step_item,int_max_nstep_item,int_nstep_item, *int_yscal_item;

	extern short int_panel_show;
	extern int panel_colormap_on;
	extern int model,draw_all;
	extern int var_dim,param_dim,func_dim;
	extern int int_driver,int_algorithm,int_option,int_nstep,int_max_nstep;
	extern double int_start,int_end,int_period,int_eps,int_guessed_step,int_min_step,*int_yscal;
	extern char string[],lstring[],int_frame_label[],**var_label,**func_label;
	
	/* Turn on the flag */	
	if(int_panel_show){
		window_set(int_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		int_panel_show = 1;

	/* Create aux frame */
	int_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    int_frame_label,
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  400,
		WIN_Y,  0,
		WIN_FONT, boldfont,
		0);
	if(int_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		int_panel_show = 0;
		return;
	}
	/* Create Panel */
	int_panel = window_create(int_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(int_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_int_windows();
		return;
	}
	/* Create panel items */
	int_quit_item= panel_create_item(int_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(int_panel, "Quit", 4, boldfont),
		PANEL_NOTIFY_PROC, int_quit_proc,
		0);
	int_driver_item= panel_create_item(int_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Driver: ",
		PANEL_CHOICE_STRINGS, "Standard","Time","Quality-Controlled",0,
		PANEL_VALUE, int_driver,
		PANEL_NOTIFY_PROC, int_driver_proc,
		0);
	if(int_driver == 0 || int_driver == 1){
		int_algorithm_item= panel_create_item(int_panel, PANEL_CYCLE,
			PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
			PANEL_LABEL_X, ATTR_COL(0),
			PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
			PANEL_LABEL_STRING, "Algorithm:",
			PANEL_CHOICE_STRINGS,	"Euler",
						"Runge-Kutta (4)",
						"Symplectic-Ruth (1)",
						"Symplectic-Reversible Ruth (2)",
						"Symplectic-Centered Euler (2)",
						"Symplectic-Forest-Berz (4)",
						"User",
						0,			
			PANEL_VALUE, int_algorithm,
			PANEL_NOTIFY_PROC, int_algorithm_proc,
			0);
	}
	else if(int_driver == 2){
		int_algorithm_item= panel_create_item(int_panel, PANEL_CYCLE,
			PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
			PANEL_LABEL_X, ATTR_COL(0),
			PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
			PANEL_LABEL_STRING, "Algorithm:",
			PANEL_CHOICE_STRINGS, "Runge-Kutta QC (5)","Bulirsch-Stoer QC",0,
			PANEL_VALUE, int_algorithm,
			PANEL_NOTIFY_PROC, int_algorithm_proc,
			0);
	}
	if(int_driver == 2 && int_algorithm == 1){
		int_option_item= panel_create_item(int_panel, PANEL_CYCLE,
			PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
			PANEL_LABEL_X, ATTR_COL(0),
			PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
			PANEL_LABEL_STRING, "Option: ",
			PANEL_CHOICE_STRINGS, "Show True Orbits Only","Show Intermediate Orbits",0,
			PANEL_VALUE, int_option,
			PANEL_NOTIFY_PROC, int_option_proc,
			0);
	}

	if(int_driver == 1 || int_driver == 2 ){
		sprintf(string, "%lg", int_start);
		int_start_item = panel_create_item(int_panel, PANEL_TEXT,
			PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
			PANEL_LABEL_X, ATTR_COL(0),
			PANEL_VALUE, string,
			PANEL_VALUE_DISPLAY_LENGTH, 20,
			PANEL_LABEL_STRING,"t Start:",
			0);
		sprintf(string, "%lg", int_end);
		int_end_item = panel_create_item(int_panel, PANEL_TEXT,
			PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
			PANEL_LABEL_X, ATTR_COL(0),
			PANEL_VALUE, string,
			PANEL_VALUE_DISPLAY_LENGTH, 20,
			PANEL_LABEL_STRING,"t End:",
			0);
		if(!draw_all){
			sprintf(string, "%lg", int_period);
			int_period_item = panel_create_item(int_panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 20,
				PANEL_LABEL_STRING,"t Period:",
				0);
		}
		if(int_driver ==1) {
			sprintf(string, "%d", int_nstep);
			int_nstep_item = panel_create_item(int_panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 20,
				PANEL_LABEL_STRING,"# Step:",
				0);
		}
		else {
			sprintf(string, "%lg", int_eps);
			int_eps_item = panel_create_item(int_panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 20,
				PANEL_LABEL_STRING,"Tolerated Error:",
				0);
			sprintf(string, "%lg", int_guessed_step);
			int_guessed_step_item = panel_create_item(int_panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 20,
				PANEL_LABEL_STRING,"Guessed dt:",
				0);
			sprintf(string, "%lg", int_min_step);
			int_min_step_item = panel_create_item(int_panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 20,
				PANEL_LABEL_STRING,"Min Allowed dt:",
				0);
			sprintf(string, "%d", int_max_nstep);
			int_max_nstep_item = panel_create_item(int_panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 20,
				PANEL_LABEL_STRING,"# Max Step:",
				0);
			for(i=0;i<var_dim;i++){
				sprintf(string, "%lg", int_yscal[i]);
				sprintf(lstring,"Scale Factor-%s:",var_label[i]);
				int_yscal_item[i] = panel_create_item(int_panel, PANEL_TEXT,
					PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
					PANEL_LABEL_X, ATTR_COL(0),
					PANEL_VALUE, string,
					PANEL_VALUE_DISPLAY_LENGTH, 20,
					PANEL_LABEL_STRING,lstring,
					0);
			}
		}
	}

	window_fit(int_panel);
	window_fit(int_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(int_panel,WIN_PIXWIN),"int_panel_cms");
}

