/*
### get an index for the type of periodic orbits ###

Note: Order eigenvalues in decreasing order in magnitude
*/

fp_get_type(type,eval,n)
int *type,n;
double **eval;
{
	double fabs();
	int i,fp_stable_man_dim,fp_unstable_man_dim,complex_ev;
	extern int model,mapping_on;

	if(n==1){
		if(mapping_on){
			if(fabs(eval[0][0])>1)
				*type = 1;
			else
				*type = -1;
		}
		else {
			if(eval[0][0]>0)
				*type = 1;
			else
				*type = -1;
		}
	}
	else if(n==2){
		if(mapping_on){
			if(eval[0][1] ==0 && eval[1][1] ==0) {
				if((fabs(eval[0][0])-1.)*(fabs(eval[1][0])-1.) <0)
		  			*type = 0;
	  			else if(fabs(eval[0][0])>1)
		    			*type = 1;
	    			else
		    			*type = -1;
			}
			else {
				if((eval[0][0]*eval[0][0]+eval[1][0]*eval[1][0])>1)
		  			*type = 2;
	  			else
		  			*type = -2;
			}
		}
		else {
			if(eval[0][1] == 0 && eval[1][1] ==0){
				if(eval[0][0]*eval[1][0] <0)
		  			*type = 0;
	  			else if(eval[0][0]>0)
		    			*type = 1;
	    			else
		    			*type = -1;
			}
			else {
				if(eval[0][0]>0)
		  			*type = 2;
	  			else
		  			*type = -2;
			}
		}
	}
	else {
		/* compute the dimensions of stable and unstable manifolds */
		fp_unstable_man_dim = 0;
		fp_stable_man_dim = 0;
		complex_ev = 0;
		if(mapping_on){
			for(i=0;i<n;i++){
				/* Note: May need to relax this test for
				complex eigenvalue */
				if(eval[i][1]==0){
					if(fabs(eval[i][0])>1){
						fp_unstable_man_dim++;
					}
					else {
						fp_stable_man_dim++;
					}
				}
				else {
					complex_ev = 1;
					if((eval[i][0]*eval[i][0] + eval[i][1]*eval[i][1]) >1){
						fp_unstable_man_dim++;
					}
					else {
						fp_stable_man_dim++;
					}
				}
			}
		}
		else {
			for(i=0;i<n;i++){
				if(eval[i][1]!=0){
					complex_ev = 1;
				}	
				if(eval[i][0] > 0){
					fp_unstable_man_dim++;
				}
				else {
					fp_stable_man_dim++;
				}
			}
		}
		if(complex_ev == 1){
			if(fp_unstable_man_dim == n){
				*type = 2;
			}
			else if(fp_stable_man_dim == n){
				*type = -2;
			}
			else {
				*type = 0;
			}
		}
		else {
			if(fp_unstable_man_dim == n){
				*type = 1;
			}
			else if(fp_stable_man_dim == n){
				*type = -1;
			}
			else {
				*type = 0;
			}
		}
	}
}
