/* 
### from primary to full variable ###

Input:	vx: primary variable
Output: vf: full window variable (orbit part + function part )

Note: output can be in either of the following two coords
	polar_switch:	0: in primary cood 
			1: in secondary coord
*/

to_full_variables(vf,vx,polar_switch)
int polar_switch;
double vf[],vx[];
{
	int i;
	extern int func_on,var_dim,func_dim,var_dim,full_dim;
	extern double time,*func,*param;

	/* get an orbit part of full variable */
	to_window_variables(vf,vx,polar_switch);
	/* get the function part of full variable */
	if(func_on){
		(void) get_func(func,vx,param,time,var_dim);
		for(i=var_dim;i<full_dim;i++) vf[i] = func[i-var_dim];
	}
}
