/*
### Implicit backward mapping ###

Bug: No polar coords allowed for maps at the moment
	The order of orbits mess up if ir>1.
*/

#define DELFRAC 0.2

int map_implicit_backward()
{
	int i,it,color,ndid;
	double delx,time,*vn1,*vn2,*vn,*dvector(),xerr,tmp;
	void free_dvector();
	extern int nok,nbad,forward_toggle,stop,var_dim,i_max,polar_coord,fi_maxsq,ir;
	extern int fp_display_option,ir;
	extern double fi_eps,fi_epsf,cutoff,*win_var_i,*win_var_f,*param,*t_vf;
	extern int (*f_p)();
	extern char string[];
	
	stop = 0;
	vn = dvector(0,var_dim-1);
	vn1 = dvector(0,var_dim-1);
	vn2 = dvector(0,var_dim-1);

	if(ir ==0){
		system_mess_proc(1,"Period=0 not acceptable. Change period in periodic orbit window.");
		goto done;
	}

	/* initialize from window variable */
	from_window_variables(vn,win_var_i,polar_coord);

	/* draw first point */
	to_full_variables(t_vf,vn,polar_coord);
	(void) draw_record_orbit(t_vf,0,0);

	for(i=0;i<var_dim;i++) vn2[i]=vn[i];
	fmap_user(vn2,ir,var_dim);
	for(i=0;i<var_dim;i++) {
		delx = vn[i] - vn2[i];
		vn2[i] = vn[i] + delx;
		vn1[i] = vn2[i] + DELFRAC * delx;
	}

	/* main loop */
	for (it=1;it<=i_max;it += ir){
		/* check divergence */
		for(i=0;i<var_dim;i++) {
			if(vn[i] > cutoff || vn[i] < -cutoff) {
				system_mess_proc(1,"Orbits appear to diverge off to an infinity! Stop!");
				goto done;
			}
		}
		/* initial second guess seperated by a fraction of a distance 
		between an orbit and its image */
		(void) fmapi_user(vn1,vn2,vn,fi_maxsq,var_dim,ir,fi_eps,fi_epsf,&xerr,&ndid);
		(ndid >= fi_maxsq) ? nbad++ : nok++; 
		to_full_variables(t_vf,vn1,polar_coord);
		(void) draw_record_orbit(t_vf,it,1);
		if(fp_display_option==1 && ir>1){
			/* skip the first ir-1 orbits from recording */
			if(it ==1)
				draw_record_other_orbit(t_vf,it,0,ir);
			else
				draw_record_other_orbit(t_vf,it,1,ir);
		}
		for(i=0;i<var_dim;i++) {
			delx = vn1[i] - vn[i];
			vn[i] = vn1[i];
			vn2[i] = vn[i] + delx;
			vn1[i] = vn2[i] + DELFRAC * delx;
		}
		if(stop ) {
			goto done;
		}
	}
	
done:
	/* to window variable */
	for(i=0;i<var_dim;i++)
		win_var_f[i]=vn[i];
	sprintf(string,"Inverse Map: nok=%d nbad=%d\n",nok,nbad);
	system_mess_proc(0,string);
	free_dvector(vn,0,var_dim-1);
	free_dvector(vn1,0,var_dim-1);
	free_dvector(vn2,0,var_dim-1);
}
