/*
### LU decomposition ###
*/

#include <math.h>
#define TINY 1.e-20
void ludcmp(a,n,indx,d)
int n,indx[];
double **a,*d;
{
	int i,imax=0,j,k;
	double big,dum,sum,temp;
	double *vv,*dvector(),fabs();
	extern int stop;

	vv = dvector(0,n-1);
	*d = 1.0;
	for(i=0;i<n;i++){
		big = 0.0;
		for(j=0;j<n;j++)
			if((temp = fabs(a[i][j])) > big) big = temp;
		if(big == 0.0) {
			printf("ludcmp: Singular matrix\n");
			stop = 1;
			goto done;
		}
		vv[i] = 1.0/big;
	}
	for(j=0;j<n;j++){
		for(i=0;i<j;i++) {
			sum = a[i][j];
			for(k=0;k<i;k++) sum -= a[i][k] * a[k][j];
			a[i][j] = sum;
		}
		big = 0.0;
		for (i=j;i<n;i++) {
			sum = a[i][j];
			for(k=0;k<j;k++) sum -= a[i][k] * a[k][j];
			a[i][j] = sum;
			if((dum = vv[i] * fabs(sum)) >=big) {
				big = dum;
				imax = i;
			}
		}
		if(j !=imax) {
			for(k=0;k<n;k++){
				dum = a[imax][k];
				a[imax][k] = a[j][k];
				a[j][k] = dum;
			}
			*d = - (*d);
			vv[imax] = vv[j];
		}
		indx[j] = imax;
		/* modified for our special application */
		/*
		if(a[j][j] == 0) {
			a[j][j] = TINY;
			printf("ludcmp: Singular matrix. Attempt to fix it.\n");
		}
		*/
		if(a[j][j] == 0) {
			printf("ludcmp: Singular matrix\n");
			stop = 1;
			goto done;
		}
		if(j != n-1) {
			dum = 1.0 / (a[j][j]);
			for(i=j+1;i<n;i++) a[i][j] *= dum;
		}
	}

done:
	(void) free_dvector(vv,0,n-1);
}
