/*
### LU back substitution ###

Note: x[0...n-1] convention
*/

void lubksb(a,n,indx,b)
double **a,b[];
int n,indx[];
{
	int i,ii= -1,ip,j;
	double sum;

	for(i=0;i<n;i++){
		ip = indx[i];
		sum = b[ip];
		b[ip] = b[i];
		if(ii >= 0)
			for(j=ii;j<=i-1;j++) sum -= a[i][j] * b[j];
		else if (sum) ii = i;
		b[i] = sum;
	}
	for(i=n-1;i>=0;i--){
		sum = b[i];
		for(j=i+1;j<n;j++) sum -= a[i][j] * b[j];
		b[i] = sum/a[i][i];
	}
}
