/* %W%    %G% /
/*
Pack a set of files to a single file with keys and path-names at the biginning 
It reads from standard input a list of UNIX pathnames.
Either a full or partial path-name can be given 
It does not complain about the file not found; it just ignores 
eg. each line should contain strings of proper pathnames, no filename expansion done
	tmp
	Makefile
	/usr/kim/PACKAGE2/kaos.c
	/usr/include/stdio.h
	...			*/

#include <stdio.h>
#define   YES   1
#define   NO    0
#define   LINELEN 240

main()
{
	int c,cc,inword,argc,nc;
	char s[80];
	FILE *fp,*fopen();
	
	inword = NO;
	argc=0;
	while  ( (c  = getchar()) != EOF) {
		if (c == ' ' || c == '\n' || c == '\t'){
			if( inword == YES ){
				s[argc]='\0';
				printf("\n");
				if( ( fp=fopen(s,"r") ) != NULL ){

					printf("/*KTAR NEWFILE=%s */\n",s);
					while ( ( cc = getc( fp ) ) != EOF){
						putchar(cc);
					}
					fclose(fp);
					printf("/*KTAR ENDFILE=%s */\n",s);
				}
			}
			inword = NO;
			argc=0;
		}
		else {
			s[argc]=c;
			argc++;
			if (inword == NO)
				inword = YES;
		}
	}
}
