/*
### translate AUTO86 paramters into kaos parameters ###
*/

#include "../include/auto_kaos_def.h"

auto_translate_param(aux_win_i)
int aux_win_i;
{

	int i;
	extern int var_dim,param_dim,full_dim;
	extern int **aux_cur_index;
	extern double **aux_x_min,**aux_x_max,*param;
	/* AUTO86 declarations */
	extern int auto_option,auto_nfpar,auto_ndim,auto_icp[];
	extern double auto_rl0,auto_rl1,auto_a0,auto_a1,auto_par[];
	extern char string[];

	/* set variable dimension and parameter dimension */
	/* but it is not necessary at the moment to reset 
	the existing value of variable dimension */
	/* nvar_dim = auto_ndim; */
	/* param_dim is not defined in AUTO86 ? */

	/* From FORTRAN index for free parameters of AUTO86 to C index */
	/* This index should be reset before any use of free param indices */
	for(i=0;i<auto_nfpar;i++) auto_icp[i] -= 1;

	/* set indices for auxiliary window to display AUTO86
	bifurcation diagram or bifurcation set  automatically */
	/* 1-parameter continuation */
	if(auto_option==2){
		aux_cur_index[aux_win_i][0] = full_dim + auto_icp[0]; /* principal parameter */
		/* set func_dim >=1 always to make a room for L2 norm */
		aux_cur_index[aux_win_i][1] = full_dim - 1; /* L2 norm */
	}	

	/* 2-parameter continuation */
	else if(auto_option==1 || auto_option==3){
		aux_cur_index[aux_win_i][0] = full_dim + auto_icp[0];
		aux_cur_index[aux_win_i][1] = full_dim + auto_icp[1];
	}
	aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i] = auto_rl0;
	aux_x_max[aux_cur_index[aux_win_i][0]][aux_win_i] = auto_rl1;
	aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i] = auto_a0;
	aux_x_max[aux_cur_index[aux_win_i][1]][aux_win_i] = auto_a1;

	/* AUTO86 has AUTO_ALL_PARAM_DIM parameters.
	Among them AUTO_FREE_PARAM_DIM are free parameters */

	if(param_dim > AUTO_FREE_PARAM_DIM){
		sprintf(string,"Error: Reset first %d parameters ONLY!",AUTO_FREE_PARAM_DIM);
		system_mess_proc(0,string);
		for(i=0;i<AUTO_FREE_PARAM_DIM;i++) param[i] = auto_par[i];
	}
	else {
		for(i=0;i<param_dim;i++) param[i] = auto_par[i];
	}
}
