/* 
### coding an AUTO symbol into a kaos color-symbol ###
--------------------------------------------------
Note:
	solid->Blue?g
	dash->sky
	ldot->violet
	long dash ->orange
	dash symbol->sky CROSS
--------------------------------------------------
*/

#include "../include/main_kaos_def.h"

auto_get_color_symbol(color,s_type)
int *color,*s_type;
{
	extern int my_colormap_size;
	/* AUTO86 declerations */
	extern int auto_ibr,auto_ntot,auto_itp,auto_lab;

	switch(auto_itp){
		case 0:
			if(auto_ibr>0){
				if(auto_ntot>0){
					*color = Blue;
					*s_type = -1; /* unstable steady state */
				}
				else {
					*color = SkyBlue;
					*s_type = -1; /* stable steady state */
				}
			}
			else{
				if(auto_ntot>0) {
					*color = Red;
					*s_type = CIRCLE; /* unstable periodic */
				}
				else {
					*color = Orange;
					*s_type = CIRCLE; /* stable periodic */
				}
			}
			break;
		case 1: /* BP: Yellow open square */
			*color = Yellow;
			*s_type = SQUARE;
			break;
		case 2: /* LP: Yellow solid triangle */
			*color = Yellow;
			*s_type = TRIANGLE;
			break;
		case 5: /* LP: Yellow solid triangle */
			*color = Yellow;
			*s_type = TRIANGLE;
			break;
		case 6: /* BP: Yellow open square */
			*color = Yellow;
			*s_type = SQUARE;
			break;
		case 7: /* PD: Yellow open diamond */
			*color = Yellow;
			*s_type = DIAMOND;
			break;
		case 8: /* TR: Yellow inverted triangle */
			*color = Yellow;
			*s_type = INVTRI;
			break;
		case -9:
			*color = my_colormap_size-1;
			*s_type = XCROSS;
			break;
		default:
			*color = my_colormap_size-1;
			*s_type = -1;
			break;
	}

}
