static char WHAT[]="@(#)schwarz.c	1.6 (rl) 92/08/13";
/************************************************************
* kaleido
*
*	Kaleidoscopic construction of uniform polyhedra
*
*	Author:
*		Dr. Zvi Har'El
*		Department of Mathematics,
*		Technion, Israel Institute of Technology,
*		Haifa 32000, Israel.
*		E-Mail: rl@gauss.technion.ac.il
************************************************************/
#ifndef MAXLONG
#define MAXLONG 0x7FFFFFFF
#endif
typedef struct Trian {
	int density;
	char index[2];
	double p[3];
	int a[3][3];
	struct Sum *sum;
	struct Trian *next;
} Trian;
typedef struct Sum {
	struct Trian *left, *right;
	struct Sum *next;
} Sum;

main ()
{
	int n;
	for (n = 3; n <= 5; n++){
		Trian *u, *v, *head, *moebius(), *sorted = 0;
		Sum *s;
		int index = 0;
		static char *names[3] = {"Tetr", "Oct", "Icos"};
		char *name = names[n-3];
		printf ("%sahedral Schwarz Triangles\n\n", name);
		units (n);
/*
* generate the triangles
*/
		head = moebius (n);
		for(u = head; u; u = u->next) {
			for(v = head; v != u->next; v=v->next) {
				Trian *result, *add(), *next;
				for (result = add (u, v); result; result = next) {
					next = result->next;
					install (head, result, u, v);
				}
			}
		}
/*
* sort the triangles  by increasing density and perimeter
*/
		for (u = head; u; u = v) {
			double peri();
			Trian **z;
			for (z = &sorted;
				*z && ((*z)->density < u->density ||
				(*z)->density == u->density && peri (*z) < peri (u));
				z = &(*z)->next)
				;
			v = u->next;
			u->next = *z;
			*z = u;
		}
/*
* print the triangles and splittings
*/
		for (u = sorted; u; u = u->next) {
			int i;
			if (index) index++;
			else if (u->next && u->next->density == u->density)
				index='a';
			u->index[0] = index;
			u->index[1] = 0;
			printf ("\n%c%d%s", *name, u->density, u->index);
			printf ("\t( ");
			for (i = 0; i < 3; i++){
				printfrac (u->p[i]);
				putchar (' ');
			}
			printf ("; ");
			for (i = 0; i < 3; i++) side(u->a[i]);
			printf (")\n\t");
			if (u->next && u->next->density != u->density) index = 0;
			for (s = u->sum; s; s = s->next)
				if (s->left != s->right) printf ("\t%c%d%s+%c%d%s",
					*name, s->left->density, s->left->index,
					*name, s->right->density, s->right->index);
				else printf ("\t2%c%d%s",
					*name, s->left->density, s->left->index);
			putchar ('\n');
		}
/*
* free the list
*/
		for (u = sorted; u; u = v){
			v = u->next;
			free (u);
		}
		if (n < 5) putchar ('\f');
	}
}

Trian*
moebius (n)
int n;
/*
* generate a moebius triangle
*/
{
	static int a[3][3][3] = {
		{{0, 1, 0}, {0, 1, 0}, {4, -2, 0}},
		{{2, -1, 0}, {1, 0, 0}, {0, 1, 0}},
		{{0, 1, 0}, {0, 0, 1}, {2, -1, -1}}
	};
	int i, j;
	Trian *u;
	u = (Trian*) malloc (sizeof (Trian));
	u->density = 1;
	u->p[0] = n;
	u->p[1] = 3;
	u->p[2] = 2;
	for(i = 0, j = 0; i < 3; ++j < 3 || (j = 0, i++)) {
		u->a[i][j] = a[n-3][i][j];;
	}
	u->sum = 0;
	u->next = 0;
	return u;
}

double unit_length[3];
char unit_name[2] = {'s', 'v'};

units (n)
int n;
/*
* Initialize unit lengths (used by peri()) and names (used by side()).
*/
{
	double acos(), sqrt();
	if (n == 3) { /* pi/4 and s */
		unit_length[0] = acos (0.) / 2;
		unit_length[1] = acos (-1. / 3) / 2;
	} else if (n == 5) { /* u and v */
		unit_length[1] = acos (sqrt (5.) / 3) / 2;
		unit_length[2] = acos (sqrt (5.) / 5) / 2;
		unit_name[0] = 'u';
	}
}

double
peri (result)
Trian*result;
/*
* compute the perimeter of a triangle
*/
{
	int i,j;
	double x = 0;
	for(i = 0, j = 0; i < 3; ++j < 3 || (j = 0, i++))
		x += result->a[i][j] * unit_length [j];
	return x;
}

install (head, trian, left, right)
Trian *head, *trian, *left, *right;
/*
* install a triangle and a splitting in list
*/
{
	Trian **z;
	Sum *s, **t;
	int i;
/*
* if not convex triangle, nothing to do
*/
	if (trian->p[2] <= 1) {
		free (trian);
		return;
	}
/*
* generate a Sum structure to hold splitting
*/
	trian->next = 0;
	s = (Sum*) malloc (sizeof(Sum));
	s->left = left;
	s->right = right;
	s->next = 0;
/*
* look if triangle already there
*/
	for (z = &head->next; *z; z = &(*z)->next) {
		if ((*z)->density != trian->density) continue;
		for (i = 0; i < 3 && (*z)->p[i] == trian->p[i]; i++)
			;
		if (i == 3) break;
	}
	if (*z) {
		free (trian);
/*
* look if splitting already there
*/
		for (t = &(*z)->sum; *t && ((*t)->left != left || (*t)->right != right);
			t = &(*t)->next)
			;
		if (*t) free (s);
		else *t = s;
	} else {
/*
* insert new triangle and splitting
*/
		trian->next = *z;
		trian->sum = s;
		*z = trian;
	}
}

Trian*
add (left, right)
Trian *left, *right;
/*
* paste two triangles together
*/
{
	Trian *result = 0;
	int i, j;
	for(i = 0, j = 0; i < 3; ++j < 3 || (j=0, i++)) {
/*
* check if angles are complementary
*/
		double combine();
		int k, l;
		if (combine (left->p[i], right->p[j]) != 1) continue;
		for (k = 1, l = 1; k < 3; ++l < 3 || (l = 1, k++)){ 
			int a[3], m;
			Trian *u, **z;
/*
* check if sides are equal
*/
			for (m = 0; m < 3 && left->a[(i + k) % 3][m] ==
				right->a[(j + l) % 3][m]; m++)
				;
			if (m < 3) continue;
/*
* generate the new triangle, with sorted angles and sides
*/
			u = (Trian*) malloc (sizeof (Trian));
			u->density = left->density + right->density;
			u->p[0] = 0;
			push (u, right->p[(j + l) % 3], left->a[i]);
			push (u, left->p[(i + k) % 3], right->a[j]);
			for (m = 0; m < 3; m++)
				a[m] = left->a[(i + 3 - k) % 3][m] +
					right->a[(j + 3 - l) % 3][m];
			push (u, combine (left->p[(i + 3 - k) % 3],
				right->p[(j + 3 - l) % 3 ]), a);
			u->next = 0;
/*
* check if it is really new
*/
			for (z = &result; *z; z = &(*z)->next) {
				for (m = 0; m < 3 && u->p[m] == (*z)->p[m]; m++)
					;
				if (m == 3) break;
			}
			if (*z) free (u);
/*
* add it to the list of results
*/
			else *z = u;
		}
	}
	return result;
}

push (trian, p, a)
Trian *trian;
double p;
int a[3];
/*
* insert angles and sides in order
*/
{
	int i, j;
	for (i = 0; i < 3 && trian->p[i] >= p; i++)
		;
	for (j = 2; j > i; j--) {
		int k;
		trian->p[j] = trian->p[j - 1];
		for (k = 0; k < 3; k++) trian->a[j][k] = trian->a[j - 1][k];
	}
	trian->p[i] = p;
	for (j = 0; j < 3; j++) trian->a[i][j] = a[j];
} 

side (a)
int a[3];
/*
* print the symbolic expression for a side
*/
{
	int i, j = a[0];
	printpi (j / 4.);
	for(i = 1; i < 3; i++){
		if (!a[i]) continue;
		if(j && a[i] > 0) putchar ('+');
		j = 1;
		if (a[i] == -1) putchar ('-');
		else if (a[i] != 1) printf ("%d", a[i]);
		putchar (unit_name [i - 1]);
	}
	putchar(' ');
}

typedef struct {
	long n, d;
} Rational;
Rational frax;

frac (x)
double x;
/*
* Find the numerator and the denominator using the Euclidean algorithm.
*/
{
	static Rational zero = {0,1}, inf = {1,0};
	Rational r;
	double s = x;
	r = zero;
	frax = inf;
	for(;;) {
		Rational q;
		long f;
		double floor();
		if (abs (s) > (double) MAXLONG) return;
		f = (long) floor (s);
		q = r;
		r = frax;
		frax.n = frax.n * f + q.n;
		frax.d = frax.d * f + q.d;
		if (x == (double) frax.n / (double) frax.d) return;
		s = 1 / (s - f);
	}
}

double
combine (x, y)
double x, y;
/*
* compute 1/(1/x+1/y) using rational arithmetic.
*/
{
	Rational q;
	frac (x);
	q = frax;
	frac (y);
	return (double)q.n * frax.n / (q.d * frax.n + q.n * frax.d);
}

printfrac (x)
double x;
/*
* Print a fraction.
*/
{
	frac (x);
	printf ("%d", frax.n);
	if (frax.d != 1) printf("/%d",frax.d);
}

printpi (x)
double x;
/*
* Print a multiple of pi.
*/
{
	if (!x) return;
	frac (x);
	if (frax.n != 1) printf ("%d", frax.n);
	printf ("pi");
	if (frax.d != 1) printf("/%d",frax.d);
}
