.\"@(#)kaleido.man	2.65 (rl) 92/08/07
.TH KALEIDO 1 "92/08/07" "Version 2.65"
.if !c\(*a .char \(*a alpha
.if !c\(*g .char \(*g gamma
.if !c\(*p .char \(*p pi
.if !c\(*r .char \(*r rho
.SH NAME
kaleido \- kaleidoscopic construction of uniform polyhedra
.SH SYNOPSIS
.B kaleido
.B [\-lvxgnLRGB]
.BI [\-d digits ]
.BI [\-a degrees ]
.BI [\-d degrees ]
.BI [\-f degrees ]
.BI [\-p prefix ]
.BI [\-P prefix ]
.BI [\-m mode ]
.BI [\-r edges ]
.BI [\-i file ]
.SH DESCRIPTION
Let
.I (p q r)
be a
.I Schwarz
triangle, i.e. a spherical triangle
.I PQR 
with angles
.I \(*p/p, \(*p/q
and
.I \(*p/r, 
such that the sphere can be covered evenly by images of the
triangle under successive reflections in its sides.

The vertices of a
.I uniform
(facially regular, isogonal)
polyhedron are constructed, following
.I Wythoff,
by successive reflections
of a certain point
.I C
of
.I PQR,
in four ways:
.TP
.IR p | "q r" :
.I C
is located at the vertex
.I P.
.TP
.IR "p q" | r :
.I C
is located on the side
.I PQ,
at its intersection with the bisector of the angle
.I R.
.TP
.IR "p q r" |:
.I C
is located in the incenter of
.I PQR.
.TP
.RI | "p q r" :
.I C
is located in an interior point of
.I PQR,
in such a way that its images under an even number of reflections
generate a chiral (non-reflexible) uniform polyhedron.
.PP
In the same time, the tangent planes to the sphere at
.I C
and its images make the faces of the
.I dual
(vertically regular, isohedral) polyhedron.

.I kaleido
displays the following tabulated data for the uniform polyhedron:

1) Its name.

2) Its Wythoff symbol (3 rationals and a |).

3) References to figures in
.I Uniform Polyhedra
and in
.I Polyhedron Models
(see below).

4) The name of its dual.


.I kaleido
displays the following computed data for the uniform polyhedron:

1) The cyclic face arrangement at its vertex.

2) Its symmetry group.

3) Its density
.I D
(if determined).

4) The counts
.I V, E, F
of its vertices, edges and faces, respectively.
.RI ( F
is also given as a sum of counts of faces of different types.)

5) The angles
.I \(*a, \(*g
and the sides
.I a, b, c
of the fundamental right-angled spherical
triangle
.I ABC
for face type
.RI { n }.
.RI ( C
is as above,
.I B
is at the right angle.)

6) The ratios
.I \*(r/R = cos a,
.I r/\(*r = cos c,
.I l/\(*r = tan a,
.I h/r = tan c,
where
.I R, \(*r, r, l
and
.I h
are the circumradius, the midradius, the inradius,
the semiedge and the facial inradius, respectively.

Note that the polyhedra in a dual pair have common values for
.I D, E
and
.I b,
while the values of
.I V, \(*a, a, \(*r/R
and
.I l/\(*r
for each polyhedron are equal to the values of
.I F, \(*g, c, r/\(*r
and
.I h/r
for its dual, respectively.

If graphics is available,
.I kaleido
optionally displays rotating wire-frame images of the polyhedra,
with depth represented by the edge color brightness level.

It may be shown that there exist finitely many uniform polyhedra,
in addition to two denumerable families of prisms and antiprisms.
If no input list is given,
.I kaleido 
displays the five prisms and antiprisms with five-fold
dihedral symmetry, as well as the seventy-five uniform polyhedra 
with tetrahedral, octahedral or icosahedral symmetry.

.SH OPTIONS

.TP
.B \-l
list polyhedron names, symbols and reference figures.
.TP
.B \-v
display vertex and face coordinates and, for each vertex, the list of
adjacent vertices and incident faces, arranged counter-clockwise.
The vertex coordinates are normalized so that the circumradius 
is one.
The face coordinates are the coefficients of their cartesian equations,
normalized so that the right hand side is the smallest finite inradius.
Equatorial faces are starred, their right hand side is zero, and their
coordinates normalized to have a unit sum of squares.
The chosen normalization makes the face coordinates the dual vertex
coordinates, with largest finite circumradius one (equatorial faces correspond
to ideal vertices). It also makes the vertex coordinates
the dual face coordinates, with the right hand side as above.
.TP
.B \-x
display successive Newton approximations to 
.I \(*g.
.TP
.BI \-d digits
number of significant digits to display (default \- six).
.TP
.BI \-a degrees
azimuth of rotation axis.
.TP
.BI \-e degrees
elevation of rotaion axis.
.TP
.BI \-f degrees
angle of rotation until freezing. If
.B \-g
is not specified, a
.I pic
snapshot will be taken at this point.
Otherwise, the rotaion stops at this point if
.B F
is hit.
.TP
.BI \-p prefix
write
.I pic
snapshots on
.IR prefix.nnn ,
for inclusion in a
.I troff
or a 
.I TeX
document (default \-
.IR picXXXXX ,
where XXXXX is the process id).
.TP
.BI \-P prefix
similar to
.BR \-p .
When both are specified, 
.B \-p
refers to uniform polyhedra and
.B \-P
to their duals.
.TP
.B \-g
display polyhedra on a graphics monitor.
Infinite polyhedra are displayed in half-size and with
the infinite edges truncated.
Under this option, the polyhedron rotates until a key is hit.
The rotation resumes if another key is hit.
To display the next polyhedron, hit
.I Enter
during the rotation, and to display the previous, hit
.I Backspace.
To display the dual polyhedron, hit
.I Tab.
To exit 
.I kaleido,
hit
.I Esc.
To take a
.I pic
snapshot, hit
.I S
while the rotation is stopped.
.TP
.B \-n
display numerical data in addition to graphical.
Numerical data is displayed by default unless
.B \-g
option is selected. The
.B \-n
option is implied by the
.B \-v
or
.B \-x
options.
.TP
.B \-L
select light background (default \- dark).
.TP
.B \-[RGB]
select colors \- red, green, blue, or combinations.
.TP
.BI \-m mode
video mode.
.TP
.BI \-r edges
select drawing rate, given as the number of displayed edges
per revolution (default  \- 25200).
.TP
.BI \-i file
specify an input list.
Each line in the file (or standard input, if
.B \-i\-
is specified)
should name one polyhedron, in terms of its Wythoff symbol (3 rationals
and a vertical bar in some order) or its index (a number sign followed
by an integer in the range one through eighty).

.SH "SEE ALSO"

Coxeter, H.S.M., Longuet-Higgins, M.S. & Miller, J.C.P.,
.I Uniform Polyhedra,
Phil. Trans. Royal Soc. London,
Ser. A, 246 (1953), 401-409.

Har'El, Z.,
.I Uniform Solution for Uniform Polyhedra,
Department of Mathematics, Technion, 1992 (manuscript).

Wenninger, M.J.,
.I Polyhedron Models,
Cambridge University Press, 1971.

.SH BUGS
Polyhedron names sometimes vary among authors.

.SH AUTHOR
Dr. Zvi Har'El,
.br
Department of Mathematics,
.br
Technion, Israel Institute of Technology,
.br
Haifa 32000, Israel.
.br
E-mail: rl@gauss.technion.ac.il
