#include "extern.h"

/* Functions related to Thurston boundary modification, where
circles near the boundary are moved in until tangent to the boundary */

assignxangles()	{
/* Determine intersection angles in the domain. */
	int	i, j, k, indx, n, edgecount = 0;
	int 	pos[6][2], cnc, cnn;
	double	enorm, maxe, x1, y1, x2, y2, a, b, c;

	c = 2.0*fillrad*fillrad;
	maxe = 2.0*c;

	for (i=0; i<height; ++i) {
		for (j=0; j<width; ++j) {
			indx = j+i*width;
			if (DCirc[indx].state > INTERIOR) {
			/* At a boundary circle */
				x1 = DCirc[indx].x;
				y1 = DCirc[indx].y;
				/* Find the indices of the neighboring circles */
				getccindices (i, j, pos);
				for (n=0; n<6; ++n)	{
					k = pos[n][1]+pos[n][0]*width;
					if (DCirc[k].state > OUTSIDE)	{
					/* Found a neighboring circle in the region */
						x2 = DCirc[k].x;
						y2 = DCirc[k].y;
						a = x2-x1;
						b = y2-y1;
						enorm = a*a + b*b;
						/* Edges are stored as ordered pairs of cnums */
						cnc = DCirc[indx].cnum;
						cnn = DCirc[k].cnum;
						/* cnum1 must be less than cnum2 */
						if (cnc < cnn)	{
							myedge[edgecount].cnum1 = cnc;
							myedge[edgecount].cnum2 = cnn;
						}	
						else	{
							myedge[edgecount].cnum1 = cnn;
							myedge[edgecount].cnum2 = cnc;
						}	
						if (enorm < maxe)
						/* circles intersect; otherwise, leave zero edge angle */
							myedge[edgecount].angle = PI - acos((c-enorm)/c);
						++edgecount;
						/* Check memory */
						if (edgecount >= normbdry)	{
							printf("Insufficient memory allocated for edges.\n");
							printf("Must increase the constant AVE_EDGES in pdefs.h to 5.0.\n");
							exit(1);
						}
					}
				}
			} 
		} 
	} 
} /*assignxangles*/


double	getxangle(cnuma, cnumb)
/* Return intersection angle assigned to edge connecting circles indexed cnuma, cnumb. */
int	cnuma, cnumb;
{

	int	i;
	double	myxangle;

	/* cnuma must be less than cnumb */
	if (cnuma > cnumb)	{
		i = cnumb;
		cnumb = cnuma;
		cnuma = i;
	}

	if (cnuma == 0)	{
	/* No intersection angle is stored for this edge 
	 The circles are tangent */
		return(0.0);
	}
	else	{
		myxangle = 0.0;
		/* scan edges for (cnuma, cnumb) */
		for (i=0; i<normbdry; ++i) {
			if ((myedge[i].cnum1 == cnuma) 
			&& (myedge[i].cnum2 == cnumb)) 	{
			/* Found the desired edge */
				myxangle = myedge[i].angle;
				goto outer;
			} 
		} 
		outer:	return(myxangle);
	}
} /*getxangle*/

massagebdry()
/* If a domain border circle overlaps the boundary, move it in until it is tangent with the boundary. */
{
	int		i, j, k, indx, innerindx, mypos[6][2];
	int		innercount, nextdex;
	double		moveangle, u1, v1, u2, v2, sixthPI = PI/6.0, movex, movey;
	double		movenorm, farnorm;
	double		x, y;

	double		diskdiam, diskrad;
	double		ctrnorm, winctr;
	
	winctr = WINSIZE/2.0;
	diskdiam = 0.9*WINSIZE;
	diskrad = diskdiam/2.0;
	XFlush(dpy);
	for (i=1; i<height-1; ++i)	{
		for (j=1; j<width-1; ++j)	{
			indx = j+i*width;
			if (DCirc[indx].state > INTERIOR)	{
			/* At a boundary circle */
				x = DCirc[indx].x;
				y = DCirc[indx].y; 
				/* Compute distance of circle center to center of window */
				ctrnorm = sqrt((x-winctr)*(x-winctr)+(y-winctr)*(y-winctr));
				farnorm = ctrnorm + fillrad;
				if (farnorm > diskrad)	{
				/* This circle overlaps the boundary.
				Find average of angles to neighboring inner circles.
				The border circle will be moved in this direction */
					/* Amount of overlap */
					movenorm = farnorm - diskrad ;
					u1 = DCirc[indx].x;
					v1 = DCirc[indx].y;
					innercount = 0;
					getccindices(i, j, mypos);
					for (k=0; k<6; ++k)	{
						/* Average angles to neighboring circles in region */
						innerindx = mypos[k][1] + mypos[k][0]*width;
						nextdex = mypos[(k+1)%6][1] + mypos[(k+1)%6][0]*width;
						if (DCirc[innerindx].state == INTERIOR)	
							++innercount;
						if ((DCirc[innerindx].state > INTERIOR)
						&& (DCirc[nextdex].state == INTERIOR))	{
							u2 = DCirc[nextdex].x;
							v2 = DCirc[nextdex].y;
							moveangle = atan2 (v2-v1, u2-u1);	/* Baseangle */
						}
					}
					moveangle = moveangle - (innercount-1)*sixthPI;
					/* Unit move vector */
					movex = cos(moveangle);
					movey = sin(moveangle);
					/* Move circle center */
					DCirc[indx].x += movenorm*movex;
					DCirc[indx].y += movenorm*movey;
				}
			}
		}
	}

	normbdry = 0;
	/* Count the number of boundary circles */
	for (i=0; i<numcircles; ++i)	{
		if (DCirc[circindex[i]].state > INTERIOR)	{
			++normbdry;
		}
	}
	/* normbdry is how many memory slots are needed to store edge intersection angles */
	normbdry *= AVE_EDGES;
	XFlush(dpy);
} /*massagebdry*/

getdeepin()
/* Called when in SECTMODE (Thurston boundary modification) to identify those 
inner circles whose only neighbors are inner circles.*/
{
	int		mynbrs[6], mypos[6][2], i, j, n, mystate, indx;
	Bool		deepin;
	
	for (i=1; i<height-1; ++i) {
		for (j=1; j<width-1; ++j) {
			indx = j+i*width;
			mystate = DCirc[indx].state;
			if (mystate == INTERIOR)	{
			/* At an inner circle */
				deepin = TRUE;
				getccindices(i, j, mypos);
				for (n=0; n<NUMNBRS; ++n)	{
					mynbrs[n] = DCirc[mypos[n][1]+mypos[n][0]*width].state;
					/* If a neighboring circle is a boundary circle,
					then the central circle cannot have state DEEPINSIDE */
					if (mynbrs[n] >= OUTERBDRY) 	deepin = FALSE;
				}
				if (deepin)	
					DCirc[indx].state = DEEPINSIDE;
			} 
		}
	}
} /*getdeepin*/

