/* $Id$
 *
 * hgraphics.c
 */

/**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************/

#include <stdio.h>
#include "hcore.h"
#include "hglobals.h"
#include "sunview/window.h"

#define NEXTARG --argc; ++argv
#define PPRINT if (!pipe_mode) printf

static int hinput();
static int pipe_mode=0;
static int waiting=0;

int log_mode=0;
FILE *logf;
int model =  KLEIN;		/* current model */
hWindow hwindow;		/* current hwindow */
double vpx,vpy,vps;		/* current viewport */

/* (Menu for testing only) */
static int DoMessage(), ClearMessage();
static wMenuEntry menu[] = {
  "message",	DoMessage,
  "clear message", ClearMessage
  };

main(argc, argv)
     int argc;
     char *argv[];
{
  parse_args(argc, argv);

  if (log_mode) {
    fprintf(logf,"hgraphics pid = %1d\n", getpid());
    fflush(logf);
  }

  if (wInitialize() != 0){                
    printf("window error: can't initialize\n");
  }
  wSetInputFunc(hinput, fileno(stdin));
  SetDefaulthWindow();
  wSetMenu(menu);		/* for testing only! */
  initialize();
  prompt();
  wMainLoop();
}

hwait(status)
int status;
{
  waiting = status;
  if (waiting)
    wSetInputFunc((FILE*)NULL, fileno(stdin));
  else
    wSetInputFunc(hinput, fileno(stdin));
}

static int
  parse_args(argc, argv)
int argc;
char *argv[];
{
  NEXTARG;
  while (argc) {
    if (argv[0][0] == '-')
      switch (argv[0][1]) {
      case 'p':
	pipe_mode = 1;
	break;
      case 'l':
	NEXTARG;
	if (argc == 0) {
	  PPRINT("warning: no log file specified; -l flag ignored\n");
	}
	else {
	  if ((logf=fopen(argv[0], "w")) == NULL) {
	    PPRINT("error: can't open log file; -l flag ignored\n");
	  }
	  else
	    log_mode = 1;
	}
	break;
      default:
	PPRINT("warning: option %s ignored\n", argv[0]);
	break;
      }
    else
      PPRINT("warning: argument %s ignored\n", argv[0]);
    NEXTARG;
  }
}

static int
  hinput()
{
  char inbuf[INBUF_SIZE];
  int command, argc;
  char *args[MAXARGS];

  gets(inbuf);
  if (log_mode) {
    fprintf(logf, "hypercad in: %s\n", inbuf);
    fflush(logf);
  }
  parse_command(inbuf, &command, &argc, args);
  execute_cmd(command, argc, args);
  prompt();
}

int
  prompt()
{
  if (!waiting) {
    PPRINT("hypercad>");
    fflush(stdout);
  }
}

static int
  initialize()
{
  fsa_initialize(UNKNOWN);
  fsa_install("p",	DRAW_POINT);
  fsa_install("s",	DRAW_SEGMENT);
  fsa_install("e",	ERASE_OBJECT);
  fsa_install("c",	CLEAR_ALL);
  fsa_install("q",	QUIT_PROGRAM);

  fsa_install("m",	SET_MODEL);
  fsa_install("co",	SET_COORD_SYS);
  fsa_install("bb",	BEGIN_BATCH);
  fsa_install("eb",	END_BATCH);
  fsa_install("gp",	GET_POINT);
  fsa_install("go",	GET_OBJECT);
  fsa_install("ps",	POSTSCRIPT);
  fsa_install("<",	READ_FILE);
}

printhWindow(prefix, win)
char *prefix;
hWindow *win;
{
  int i;

  printf("%scenter = (%f, %f) \n",
	 prefix,win->center[0],win->center[1]);
  for (i=0; i<4; i++) 
    printf("%scorner[%d] = (%f, %f) \n",
	   prefix,i,win->corner[i][0],win->corner[i][1]);
}

static int
  DoMessage()
{
  char buf[2*wMAX_MSG_LEN+1];

  printf("Enter msg: ");
  gets(buf);
  wMessage(buf);
}

static int
  ClearMessage()
{
  wMessage(NULL);
}
