/*
 * gdb_example.h: include file to accompany GDB example
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/* In this example, we define two types of entities to be stored in
 * the database: points and segments in the plane.  These definitions
 * are in this file rather than in "gdb_example.c", because presumably
 * our application program would need access to these definitions.
 * Putting them in this separate file allows both the entity
 * specification file (like "gdb_example.c") and our application
 * program to #include this file.
 */

typedef double Point[2];

typedef struct Segment_s {
  Point p1,p2;
} Segment;

#define POINT GDB_ENTITY_TYPE_1
#define SEGMENT GDB_ENTITY_TYPE_2
