(* $Id: Parallels.m,v 1.3 90/07/11 13:08:19 mbp Exp Locker: mbp $
 *
 * Parallels.m: Functions for computing and drawing lines through a
 *   point which do not intersect a given line; illustrates the fact
 *   that Euclid's fifth postulate does not hold in hyperbolic
 *   geometry.
 *)


(**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************)

Parallels::usage = "Parallels[l, p, n] returns a list of n+2 lines
through the point p which do not intersect the line l.  The first and
last lines in this list are the two lines through p asymptotic to l.
The other n are at equal angles between these two."

Parallels[l_kLine, p_kPoint, n_Integer] :=
  Block[ {e1,e2,v1,v2, r, parallels},
    {e1,e2} = hSegmentEndPoints[ kSegment[l] ];
    {v1,v2} = Map[ hLog[p,#]&, {e1,e2} ];
    {a1,a2} = Sort[ Map[ Apply[ ArcTan, #[[2]] ]&, {v1,v2} ] ];
    If[ a2-a1 < N[Pi], {a1,a2} = {a2, a1+2N[Pi]} ];
    r = hRotation[ p, (N[Pi] - hAngle[v1,v2]) / (n+1) ];
    parallels = {LineTangentTo[v1]};
    Do[ AppendTo[parallels, hApply[r, Last[parallels]]], {n} ];
    AppendTo[ parallels, LineTangentTo[v2] ];
    Return[parallels];
  ]

LineTangentTo[v_kTangentVector] :=  kLine[ v[[1]], hExp[v] ]

GetParallels[n_] :=
  Block[{et1,et2l,p},
    gDraw[ et1 = gGetPoint["Enter first point on line"] ];
    gDraw[ et2 = gGetPoint["Enter second point on line"] ];
    gDraw[ l = kLine[ et1, et2 ] ];
    gErase[et1,et2];
    gDraw[ p = gGetPoint["Enter point not on line"] ];
    Return[Parallels[l,p,n]];
  ]
