#! /bin/csh -f

# $Id: Hypercad.tpl,v 1.2 90/07/11 13:07:49 mbp Exp Locker: mbp $
#TPL
#TPL	DO NOT CHANGE ANY LINE IN THIS FILE THAT BEGINS WITH '#TPL'
#TPL	
#TPL	This file is a template to be used in creating the actual
#TPL	shell script.  The makefile creates the file 'Hypercad' from
#TPL	this one by replacing the following strings in this file with
#TPL	actual values:
#TPL
#TPL		HGRAPHICSPATH
#TPL		ELBOWDPATH
#TPL		HYPERMATHPATH

#TPLWARNING

# Shell script to run Hypercad.

# usage: Hypercad [graphicshost]

# This script handles all the startup steps automatically, BUT ONLY
# WORKS IF THE MATHEMATICA HOST CAN 'rsh' TO THE GRAPHICS HOST WITHOUT
# HAVING TO SPECIFY A PASSWORD.
#
# This script
# 	(1) starts the elbow daemon on the graphics host via rsh
# 	(2) runs the HyperMath shell script to start Mathematica

if ($#argv > 0) then
  set graphicshost = $1
  shift
else
  if $?ELBOWSERVER then
    set graphicshost = $ELBOWSERVER
  else
    echo -n "Enter name of Hypercad graphics host: "
    set graphicshost = $<
    if ( "$graphicshost" == "" ) then
      echo "Null host.  Hypercad aborted."
      exit -1
    endif
  endif
endif

if ($argv > 0) then
  goto usage
endif

set hgraphics = HGRAPHICSPATH
set elbowd = ELBOWDPATH
set HyperMath = HYPERMATHPATH

rsh $graphicshost "setenv WINDOW_PARENT /dev/win0 ; setenv WMGR_ENV_PLACEHOLDER /dev/win1 ; $elbowd $hgraphics -p" &

exec $HyperMath $graphicshost

echo 'Hypercad: exec failed.'
exit -1

usage:
	echo 'usage: Hypercad [graphicshost]'
	exit -1
