/* Routine takes a list of projective points and spits out a list */
/* of poincare model points */

#include <stdio.h>
#include <math.h>
#include "mf.c"

double atof();
double size = 0.05;
int header = 0;      /* do not print header info */

main(argc,argv)

int argc; char *argv[];
{
  FILE *in,*out;
  double pnt1[3],pnt2[3];
  double *arc;
  int i,num,total,arc_list_size;;

  ProcessCommandLine(&argc,argv);
  if(argc < 3) { Usage(); exit(0);}

  num = 2 + (int) (2.0*PI / size);
  arc_list_size = num;
  arc = (double *) malloc(3 + 3*num*sizeof(double));

  if(strcmp(argv[1],"-") == 0)  in = stdin;
  else in = fopen(argv[1],"r");
  if(in == NULL) {
    fprintf(stderr,"Cannot open input file %s\n",argv[1]);
    exit(0);
   }

  if(strcmp(argv[2],"-") == 0)  out = stdout;
  else  out = fopen(argv[2],"w");
  if(out == NULL) {
    fprintf(stderr,"Cannot open output file %s\n",argv[2]);
    exit(0);
   }

  total = 0;
  while(1) {
     if(fscanf(in,"%lf %lf %lf %lf %lf %lf",&(pnt1[0]),&(pnt1[1]),&(pnt1[2]),
                         &(pnt2[0]),&(pnt2[1]),&(pnt2[2])) != 6) {
        break;
       }
     total++; /* fprintf(stderr,"."); */
     num = ComputeArc(pnt1,pnt2,size,arc);

     /* Print out result */
     if(num > 0) {
        if(header) {
           fprintf(out,"DATA \"path 3 %d\"\n",num+1);
          }
        for(i=0;i<3*num+3;i+=3) {
           fprintf(out,"%lf  %lf  %lf\n",arc[i],arc[i+1],arc[i+2]);
          }
       }
    }
  fprintf(stderr,"\ntotal of %d edges transformed.\n",total);
}

double ArcLength(pnt1,pnt2)

double pnt1[3],pnt2[3];
{
  double r_squared;
 
  r_squared = pnt1[0]*pnt1[0] + pnt1[1]*pnt1[1] + pnt1[2]*pnt1[2];
  return(sqrt(r_squared) * acos(DotProduct(pnt1,pnt2)/r_squared));

}

proj2poinc(in,out)

double in[3],out[3];

{
  double r,new_r;
  r = sqrt(in[0]*in[0] + in[1]*in[1] + in[2]*in[2]);
  if(r >= 1.0) {
    fprintf(stderr,"Ack! point outside unit sphere!\n");
    out[0] = in[1]; out[1] = in[1]; out[2] = in[2];
    return(1);
   }

  if(r > EPSILON)  new_r = (1.0 - sqrt(1.0 - r*r))/(r*r);
  else new_r = 0.5;

  out[0] = new_r*in[0];
  out[1] = new_r*in[1];
  out[2] = new_r*in[2];
        
  return(1);
}

Usage()

{
  fprintf(stderr,"Usage: arc2poinc <options> infile outfile.\n");
  fprintf(stderr,"  where infile is a list of 3d arcs.\n");
  fprintf(stderr,"  options:  -size <size>  where size is \n");
  fprintf(stderr,"      maximal angular size of polygonalization\n");
  fprintf(stderr,"             default = 0.05\n"); 
  fprintf(stderr,"  options:  -header   (prints header info) \n");
  fprintf(stderr,"             default = no header\n"); 
  fprintf(stderr,"  if infile = '-' then stdin is used.\n");
  fprintf(stderr,"  if outfile = '-' then stdout is used.\n");
}

DivideArc(pnt1,pnt2,num,arc)

double pnt1[3],pnt2[3],*arc;
int num;

/* Routine divides arc centered at origin into num line segments */
/* Result goes in arc, which is assumed to hold enough space */

{
  double angle,temp,theta;
  double coeff,A,B,x,y;   /* coefficients of linear system */
  double cs1,cs2,denom;
  int i;

  coeff = DotProduct(pnt1,pnt2)/DotProduct(pnt2,pnt2);
  temp = 1.0 - coeff*coeff;
  if(temp < EPSILON) {
     for(i=0;i<3*num;i+=3) {
        arc[i] = pnt1[0]; arc[i+1] = pnt1[1]; arc[i+2] = pnt1[2];
       }
     arc[3*num] = pnt2[0]; arc[3*num+1] = pnt2[1]; arc[3*num+2] = pnt2[2];
     return(1);
    }

  denom = 1.0/temp;

  theta = Angle(pnt1,pnt2);
  arc[0] = pnt1[0]; arc[1] = pnt1[1]; arc[2] = pnt1[2];
  angle = 0.0;
  for(i=1;i<num;++i) {
     angle += theta/(double) num;;
     cs1 = cos(angle); cs2 = cos(theta-angle);
     y = (cs2 - cs1*coeff)*denom;
     x = (cs1 - cs2*coeff)*denom;
     
     arc[3*i] = x*pnt1[0] + y*pnt2[0];
     arc[3*i+1] = x*pnt1[1] + y*pnt2[1];
     arc[3*i+2] = x*pnt1[2] + y*pnt2[2];
    }
  arc[3*num] = pnt2[0]; arc[3*num+1] = pnt2[1]; arc[3*num+2] = pnt2[2];
  return(1);   
}

ComputeCenter(pnt1,pnt2,center)

double pnt1[3],pnt2[3],*center;

{
  /* Use dbae's argument to compute hyperbolic center: */
  /* point satifies <X,pnt1> = 1, <X,pnt2> = 1, <X,pnt1 x pnt2> = 0  */

  double coeff[2][3],x,y;
  int rtrn;

  coeff[0][0] = DotProduct(pnt1,pnt1);
  coeff[0][1] = coeff[1][0] = DotProduct(pnt1,pnt2);
  coeff[1][1] = DotProduct(pnt2,pnt2);
  coeff[0][2] = coeff[1][2] = 1.0;

  rtrn = SolveTwoByTwo(coeff,&x,&y);
  if(rtrn < 0) return(-1);
  center[0] = x*pnt1[0] + y*pnt2[0];
  center[1] = x*pnt1[1] + y*pnt2[1];
  center[2] = x*pnt1[2] + y*pnt2[2];
  return(1);
}


ProcessCommandLine(argc,argv)

int *argc;
char *argv[];

{
  int i,j;

  /* loop through argument list */

  for(i=0;i<*argc;++i) {

     if(strcmp("-header",argv[i]) == 0) {
        header = 1;
        /* Update i, argc and argv */
        for(j=i+1;j<*argc;++j) {
           argv[j-1] = argv[j];
          }
        *argc -= 1;
        i--;
        continue;
       }
     if(strcmp("-size",argv[i]) == 0) {
        size = atof(argv[i+1]);
        fprintf(stderr,"size changed to %lf.\n",size);
        /* Update i, argc and argv */
        for(j=i+2;j<*argc;++j) {
           argv[j-2] = argv[j];
          }
        *argc -= 2;
        i--;
        continue;
       }
    }
}

PrintPoint(fp,pnt)

FILE *fp;
double *pnt;

{
  fprintf(fp,"%.2lf  %.2lf  %.2lf\n",pnt[0],pnt[1],pnt[2]);
}

ComputeArc(pnt1,pnt2,sz,arc)

double pnt1[3],pnt2[3],sz,*arc;

/* returns the number of segemnts in arc */

{
  int num,i;
  double rslt1[3],rslt2[3],center[3];
  double length;

  num = 0;   /* Number of arcs produced */
  if(ComputeCenter(pnt1,pnt2,center) < 0) { /* do straight line */
     if(proj2poinc(pnt1,rslt1) >= 0 && proj2poinc(pnt2,rslt2) >= 0) {
        num = 1;
        for(i=0;i<3;++i) {
           arc[i] = rslt1[i]; arc[3+i] = rslt2[i];
          }
       }
    }
  else {
     if(proj2poinc(pnt1,rslt1) >= 0 && proj2poinc(pnt2,rslt2) >= 0) {
        for(i=0;i<3;++i) { rslt1[i] -= center[i]; rslt2[i] -= center[i];}
        length = ArcLength(rslt1,rslt2);
        num = 2+ (int) (length/sz);
        DivideArc(rslt1,rslt2,num,arc); /* Divide into num arcs */
        for(i=0;i<3*num+3;i+=3) {
           arc[i] += center[0]; arc[i+1] += center[1]; arc[i+2] += center[2]; 
          }
       }
    }
  return(num);
}


