
/*
  $Header: /usr4/Geom_utilities/Poly2area/RCS/read_poly.c,v 1.1 91/03/06 11:59:47 meuer Exp $
  
  
  Allocate memory for and read in a polygon.  Returns TRUE if successful.
  
  NOTE:  This routine assumes that the polygon pointer passed to it is the same pointer
  passed in previous invocations of this routine.  There for, it only reserved memory
  for the verticies the FIRST TIME the routine is called.  If the same pointer is
  not used in subsequent calls, this routine will most likely dump core and die.
  
  Mark Meuer
  #1267045
  
  */

#include	<sys/types.h>
#include	<malloc.h>
#include	<time.h>
#include	"poly2area.h"


int
read_polygon( in_file, polygon, no_verticies )
     FILE	*in_file;
     Polygon	*polygon;
     int	no_verticies;
{
    static int	first_time = TRUE;
    static int  polygon_count = 0;
    int		i,j;		/* Loop indicies */
    int		read_count;	/* Counts number of floats read in for a given vertex */
    int		vertex_count;	/* Counts the number of verticies read in. */
    int		success = TRUE;
    
    
    /* GET POLYGON SIZE */
    /* I don't have variable polygon size set up yet, so... */
    polygon->no_verticies = no_verticies;
    
    /* RESERVE MEMORY */
    if ( first_time )
    {
	first_time = FALSE;
	polygon->top_vertex = (Vertex *) calloc((size_t) polygon->no_verticies,
						(size_t) sizeof(Vertex));
    }
    
    /* FOR EACH VERTEX, */
    polygon_count++;
    vertex_count = 0;
    for ( i = 0; i < polygon->no_verticies; i++ )
    {
	/* READ THE VERTEX */
	read_count = 0;
	for ( j = 0; j < 3; j++ )
	{
	    if ( fscanf( in_file, "%lf", &(polygon->top_vertex[i].world_coords[j]) ) == 1 )
	    {
		read_count++;
	    }
	}
	polygon->top_vertex[i].world_coords[3] = 1.0; 	/* 4-D Point, w = 1.0 */
	
	if ( read_count == POINT_SIZE - 1 )
	{
	    vertex_count++;
	}
	else if (read_count != 0)
	{
	    fprintf(stderr, "Error: read_polygon: could not read all the verticies for\n");
	    fprintf(stderr, "polygon number %d.  (I'm assuming this polygon has %d verticies.)\n",
		    polygon_count, polygon->no_verticies );
	    exit( -1 );
	}
    }
    
    if ( vertex_count == 0 )
    {
	success = FALSE;
    }
    else if ( vertex_count != polygon->no_verticies )
    {
	fprintf(stderr, "Error: read_polygon: could not read all the verticies for\n");
	fprintf(stderr, "polygon number %d.  (I'm assuming this polygon has %d verticies.)\n",
		polygon_count, polygon->no_verticies );
	exit( -1 );
    }
    
    
    if ( success )
    {
	/* Link all the verticies together. */
	for ( i = 0; i < polygon->no_verticies; i++ )
	{
	    if ( i != polygon->no_verticies - 1 )
	    {
		polygon->top_vertex[i].next_vertex = &(polygon->top_vertex[i + 1]);
	    }
	    else
	    {
		polygon->top_vertex[i].next_vertex = &(polygon->top_vertex[0]);
	    }
	    
	    if ( i != 0 )
	    {
		polygon->top_vertex[i].prev_vertex = &(polygon->top_vertex[i - 1]);
	    }
	    else
	    {
		polygon->top_vertex[i].prev_vertex = &(polygon->top_vertex[polygon->no_verticies - 1]);
	    }
	}
    }
    
    /* RETURN STATUS FLAG */
    return( success );
}
