
/*
  $Header: /usr2/meuer/Geom_utilities/Matrix_util/RCS/open_file.c,v 1.1 91/02/08 17:15:39 meuer Exp Locker: meuer $
  */


/*
 * Routine to open a file, return a pointer to it if successful and print a
 * fatal error message if not.
 *
 * Mark Meuer
 */



#include	"matrix.h"

FILE *
open_file(name, permissions)
char            name[];
char            permissions[];
{
	/* DECLARE VARIABLES */
	FILE           *file;
	char            error_string[ERROR_STRING_LENGTH];

	/* OPEN THE FILE. */
	file = fopen(name, permissions);

	/* IF NOT SUCCESSFUL, */
	if (file == NULL)
	{
		/* VOMIT FORTH MESSAGES OF DISPAIR, THEN DIE */
		sprintf(error_string,
			"open_file: Could not open file \"%s\" with permission \"%s\".",
			name, permissions);
		fatal_error(error_string);
	}
	/* ELSE */
	else
	{
		/* RETURN THE POINTER */
		return (file);
	}
}
