
/*
 * $Header: /n/poincare/usr5/meuer/5117/RCS/normalize_vect.c,v 1.1 89/05/02
 * 14:53:59 meuer Exp $
 */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/normalize_vec.c,v $ */

/*
 * Routine to normalize a vector (make its length 1)
 *
 * Mark Meuer
 */

#include	"matrix.h"

void
normalize_vector(vector)
Vector          vector;
{
	/* DECLARE VARIABLES */
	char            error_string[ERROR_STRING_LENGTH];
	char            debug_string[DEBUG_STRING_LENGTH];
	PointElement    norm;
	Vector          temp_vector;

	/* GET THE NORM OF THE VECTOR, */
	copy_vector(temp_vector, vector);
	norm = vector_norm(temp_vector);

	debug_vector("Normalize vector: Vector is ", temp_vector);
	sprintf(debug_string,
		"normalize_vector: norm = %f",
		(float) norm);
	debug(debug_string);

	/* CHECK THAT NORM IS NOT TOO SMALL */
	if (norm == 0.0)
	{
		sprintf(debug_string, "Normalize_vector: warning: norm is too small: %f", (float) norm);
		debug(debug_string);
		norm = 1.0;
	}

	/* DIVIDE SQUARE OF NORM INTO VECTOR */
	mult_vector_by_scaler(vector, temp_vector, 1.0 / norm);
}
