
/* $Header: /usr2/meuer/Geom_utilities/Matrix_util/RCS/matrix_mult.c,v 1.2 91/02/18 23:14:12 meuer Exp Locker: meuer $ */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/matrix_mult.c,v $ */

/*
 * Routine to multiply two matricies and return the result. It assumes that
 * matricies are square and uses the macro MATRIX_SIZE to determine it size.
 *
 * Mark Meuer
 */

#include	"matrix.h"

void
matrix_multiply(first_matrix, second_matrix, result_matrix)
Matrix          first_matrix;
Matrix          second_matrix;
Matrix          result_matrix;
{
	/* DECLARE VARIABLES */
	int             row, column;
	int             sub_index;

	/* FOR EACH ROW IN THE RESULTING MATRIX */
	for (row = 0; row < MATRIX_SIZE; row++)
	{
		/* FOR EACH COLUMN IN THE RESULTING MATRIX, */
		for (column = 0; column < MATRIX_SIZE; column++)
		{
			/* COMPUTE VALUE FOR THIS POINT */
			result_matrix[row][column] = 0.0;
			for (sub_index = 0; sub_index < MATRIX_SIZE; sub_index++)
			{
				result_matrix[row][column] += (first_matrix[row][sub_index] * second_matrix[sub_index][column]);
			}
		}
	}
}
