
/*
  $Header: /usr2/meuer/Geom_utilities/Arc2list/RCS/process_arcs.c,v 1.1 91/02/05 15:11:07 meuer Exp $

  Routine to read in the arcs, split them up and spit them out.

  Mark Meuer
  #1267045

  */

#include	<sys/types.h>
#include	<malloc.h>
#include	"breakarc.h"

void
process_arcs(in_file, out_file, arc_size)
     FILE *in_file;
     FILE *out_file;
     double arc_size;
{
    double first_arc[3][3];	/* Holds the arc being broken up. */
    double length;
    int	fprint_count;
    int	no_points;
    int pnt, coord;		/* Loop counters */
    static double *line_list = NULL;		/* Holds the resulting points in the line. */
    static int 	list_size = 0;	/* Size of the line list */
    
    /* FOR EACH INPUT ARC, */
    for (fprint_count = fscanf(in_file, "%lf%lf%lf%lf%lf%lf%lf%lf%lf",
			      &(first_arc[0][0]), &(first_arc[0][1]), &(first_arc[0][2]),
			      &(first_arc[1][0]), &(first_arc[1][1]), &(first_arc[1][2]),
			      &(first_arc[2][0]), &(first_arc[2][1]), &(first_arc[2][2]));
	 fprint_count == 9;
	 fprint_count = fscanf(in_file, "%lf%lf%lf%lf%lf%lf%lf%lf%lf",
			      &(first_arc[0][0]), &(first_arc[0][1]), &(first_arc[0][2]),
			      &(first_arc[1][0]), &(first_arc[1][1]), &(first_arc[1][2]),
			      &(first_arc[2][0]), &(first_arc[2][1]), &(first_arc[2][2])))
    {
	/* BREAK IT UP INTO LITTLE ARCS */
	/* Break it up. */
	/* Translate arc to the origin */
	for ( pnt = 1; pnt < 3; pnt++ )
	{
	    for ( coord = 0; coord < 3; coord++ )
	    {
		first_arc[pnt][coord] -= first_arc[0][coord];
	    }
	}

	length = ArcLength( first_arc[1], first_arc[2] );	/* Figure out how many there need to be. */
	no_points = 2 + (int) (length/arc_size);

	/* Allocate more memory for the resulting list if needed. */
	if ( list_size < ((no_points + 2) * 3))
	{
	    if ( line_list )
	    {
		free( (void *) line_list );
	    }

	    list_size = (no_points + 2) * 3;
	    line_list = (double *) malloc( (size_t) (sizeof(double) * (list_size) ));
	}


	DivideArc( first_arc[1], first_arc[2], no_points, line_list );

	/* Translate each line back from the origin. */
	for ( pnt = 0; pnt <= (no_points); pnt++ )
	{
	    for ( coord = 0; coord < 3; coord++ )
	    {
		line_list[(pnt * 3) + coord] += first_arc[0][coord];
	    }
	}
		
	
	/* PRINT THEM OUT */
	fprintf(out_file, "Data \"Polyline 3 %d\"\n", no_points);
	for ( pnt = 0; pnt <= no_points; pnt++ )
	{
	    for ( coord = 0; coord < 3; coord++ )
	    {
		fprintf(out_file, "%lf\t", line_list[(pnt*3) + coord]);
	    }
	    fprintf(out_file, "\n");
	}
    }
}
