
/*
  $Header: /usr2/meuer/Geom_utilities/Arc2list/RCS/main.c,v 1.1 91/02/05 15:11:00 meuer Exp $

  Main routines for the breakarc program

  Mark Meuer
  #1267045

  */

#include	<strings.h>
#include	"breakarc.h"

main( argc, argv )
     int	argc;
     char	**argv;
{
    double	arc_size = 0.05;
    char	*in_file_name, *out_file_name;
    FILE	*in_file, *out_file;
    
    /* PARGE THE COMMAND ARGUMENTS */
    parse_command_line( argc, argv, &in_file_name, &out_file_name, &arc_size );

    /* OPEN THE FILES */
    fprintf( stderr, "Reading from %s, writing to %s, with arc size %lf.\n",
	   ( strcmp(in_file_name, "-") == 0 ) ? "standard input" : in_file_name,
	   ( strcmp(out_file_name, "-") == 0 ) ? "standard output" : out_file_name,
	   arc_size);
    if ( strcmp(in_file_name, "-") ==  0 )
    {
	in_file = stdin;
    }
    else
    {
	in_file = open_file( in_file_name, "r" );
    }
    
    if ( strcmp(out_file_name, "-") ==  0 )
    {
	out_file = stdout;
    }
    else
    {
	out_file = open_file( out_file_name, "w" );
    }

    /* BREAK UP THE ARCS */
    process_arcs( in_file, out_file, arc_size );
    fclose( in_file );
    fclose( out_file );
}
