


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef MESHDEF
#define MESHDEF

#include "oogl/geomclass.h"
#include "oogl/bbox.h"
#include "oogl/vert.h"

#ifndef NULL
#define NULL 0
#endif

#ifndef	FALSE
#define	FALSE 0
#endif

#define MESH_UWRAP	0x1
#define MESH_VWRAP	0x2
#define MESH_C		0x4
#define MESH_N		0x8
#define MESH_U		0x10
#define MESH_D		0x20
#define MESH_EVERT	0x40
#define	MESH_BINARY	0x80
#define	MESH_Z		0x100

#define	MESH_4		0x200	/* Special 4-D flag to MeshCreate -- not stored */

/* Options to meshdraw */
#define MG_PERVERT	1
#define MG_PERPOLY	2
#define MG_POINT	0
#define MG_COLOR	4
#define MG_SHADE	8
#define MG_POLYS	16
#define MG_ULINES	32
#define MG_VLINES	64
#define MG_UWRAP	128
#define MG_VWRAP	256
#define MG_REVERSE	512
#define	MG_EDGEDRAW	1024
#define MG_NORMAL       2048

typedef struct mesh
{
	int	magic;
	int	flag;
	int	nu, nv;
	float	umin, umax, vmin, vmax;
	Point3	*p, *n, *u;
	ColorA	*c;
	float	*d;
	Point3	*nd;
}  Mesh;

#define nuverts(m) (m)->nu
#define nvverts(m) (m)->nv
#define nuquads(m) (((m)->flag & MESH_UWRAP) ? (m)->nu : (m)->nu - 1)
#define nvquads(m) (((m)->flag & MESH_VWRAP) ? (m)->nv : (m)->nv - 1)


extern GeomClass *MeshMethods( void );
extern char      *MeshName( void );
extern Mesh      *MeshCreate( int, int, int, float, float, float, float );
extern Mesh      *MeshDelete( Mesh * );
extern Mesh      *MeshCopy( Mesh * );
extern Mesh      *MeshFLoad( FILE * );
extern Mesh      *MeshLoad( char * );
extern Mesh      *MeshSave( Mesh *, char * );
extern Mesh      *MeshFSave( Mesh *, FILE * );
extern BBox      *MeshBound( Mesh *, Transform );
extern Mesh      *MeshDice( Mesh *, int (*proc)() );
extern Mesh      *MeshEvert( Mesh * );
extern Mesh      *MeshDraw( Mesh *, ContextObject * );
extern Mesh      *MeshDrawIrisGl( Mesh *, ContextObject * );
extern Mesh      *MeshDrawRenderman( Mesh *, ContextObject * );
extern Mesh      *MeshDrawXWindows( Mesh *, ContextObject * );

#ifdef GEOM_SM
GeomRef         MeshShare();
GeomRef         MeshPrivate();
#endif

#endif MESHDEF
