


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */




/*	Winged edge data structure represented in Lincoln file format


		\               /	 
		 \             /
		  \           /
		   \         /
		 e00\       /e10
		     \     /
		      \   /
			v0
			|
			|
			|
        f0		|e                 f1
			|
			|
			|
			|
			v1
                       / \
                      /   \
                  e01/     \e11
                    /       \
                   /         \
                  /           \

*/

#define BUFSIZE 256

struct position  {
	float x,y,z,w;
		};

struct equation	{
	float x,y,z,w;
		};

/*
struct vertexchars	{  information will be stored here
	to give the characteristics of an vertex (e.g. pointtype, color,...) }
*/

struct vertex	{	
	struct position pos;
	struct edge *e;
	int order;
/*	struct vertexchars chars;		*/
		};

/*
struct edgechars	{  information will be stored here
	to give the characteristics of an edge (e.g. thickness, color,...) }
*/

struct edge	{
	struct vertex *v0,*v1;
	struct face   *f0,*f1;
	struct edge   *e00,*e01,*e10,*e11;
/*	struct edgechars chars;			*/
		};

struct facechars	{  
	int color;	};

struct face	{	
	struct equation eqn;
	struct edge *e;
	int order;
	struct facechars chars;			
		};

struct data    { char title[BUFSIZE]; int dim, nvertices, nedges, nfaces, nobjects ;} ;
