


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef GEOMCLASSDEF
#define GEOMCLASSDEF

/*
  This ugly hack is added since we want shared memory to be the default.
  */
#ifndef GEOM_NOSM
#ifndef	GEOM_SM
#define	GEOM_SM
#endif /* GEOM_SM */
#else
#ifdef	GEOM_SM
#undef	GEOM_SM
#endif	/* GEOM_SM */
#endif /* GEOM_NOSM */


#include "oogl/geom.h"

#ifdef  GEOM_SM
#include "oogl/geomclass_sm.h"
#endif /*GEOM_SM*/

typedef char   *GeomNameFunc( void );
typedef GeomClass   *GeomMethodsFunc( GeomRef object );

typedef GeomRef GeomMessageFunc( GeomRef, int ac, char *av[] );

typedef GeomRef GeomPrintFunc( GeomRef object );
typedef GeomRef GeomCopyFunc( GeomRef object );
typedef GeomRef GeomCreateFunc( /* ... */ );
typedef GeomRef GeomDeleteFunc( GeomRef object );
typedef GeomRef GeomReplaceFunc( GeomRef object, Geom *newchild );
typedef GeomRef GeomLoadFunc( char *name );
typedef GeomRef GeomFLoadFunc( FILE *file );
typedef GeomRef GeomSaveFunc( GeomRef object, char *name );
typedef GeomRef GeomFSaveFunc( GeomRef object, FILE *file );

typedef GeomRef GeomPositionFunc( GeomRef object, Transform T );
typedef GeomRef GeomTransformFunc( GeomRef object, Transform T );
typedef GeomRef GeomTransformToFunc( GeomRef object, Transform T );
typedef GeomRef GeomRotateFunc( GeomRef object, double angle, Point3 *axis  );
typedef GeomRef GeomTranslateFunc( GeomRef object, double x, double y, double z );
typedef GeomRef GeomScaleFunc( GeomRef object, double x, double y, double z );

typedef GeomRef GeomEvertFunc( GeomRef object );
typedef GeomRef GeomBoundFunc( GeomRef object, Transform T );
typedef GeomRef GeomEvalFunc(  GeomRef object, double u, double v );
typedef GeomRef GeomDiceFunc( GeomRef object, int nu, int nv );
typedef GeomRef GeomSubdivideFunc( /* GeomRef object */ );

typedef GeomRef GeomPickFunc( /* GeomRef object, ... */ );
typedef GeomRef GeomPickGeomFunc( /* GeomRef object, ... */ );
typedef GeomRef GeomPickPointFunc( /* GeomRef object, ... */ );
typedef GeomRef GeomPickPlaneFunc( /* GeomRef object, ... */ );
typedef GeomRef GeomPickLineFunc( /* GeomRef object, ... */ );

typedef GeomRef GeomFacingFunc( /* GeomRef object, ... */ );
typedef GeomRef GeomDrawFunc( /* GeomRef object, faces, edges, interp */ );

#ifdef GEOM_SM
typedef	GeomRef GeomShareFunc( Geom *object, GeomSMRegion *sm );
typedef GeomRef GeomPrivateFunc( SharedGeom *object, GeomSMRegion *sm );
typedef	GeomRef GeomUnshareFunc( SharedGeom *object, GeomSMRegion *sm );
#endif

struct GeomClass
{

	/* General Methods */
	GeomNameFunc   *name;
	GeomMethodsFunc *methods;
	GeomMessageFunc *message;

	GeomPrintFunc  *print;
	GeomCreateFunc *create;
	GeomDeleteFunc *delete;
	GeomCopyFunc   *copy;
	GeomReplaceFunc *replace;
	GeomLoadFunc   *load;
	GeomFLoadFunc  *fload;
	GeomSaveFunc   *save;
	GeomFSaveFunc  *fsave;

	/* Geometric Methods */
	GeomPositionFunc *position;
	GeomTransformFunc *transform;
	GeomTransformToFunc *transformto;
	GeomTranslateFunc *translate;
	GeomRotateFunc *rotate;
	GeomScaleFunc  *scale;

	GeomEvertFunc  *evert;
	GeomBoundFunc  *bound;
	GeomEvalFunc   *eval;
	GeomDiceFunc   *dice;
	GeomSubdivideFunc *subdivide;

	/* Picking methods */
	GeomPickFunc *pick;
	GeomPickGeomFunc *pickgeom;
	GeomPickPointFunc *pickpoint;
	GeomPickPlaneFunc *pickplane;
	GeomPickLineFunc *pickline;

	/* Graphics Methods */
	GeomFacingFunc *facing;
	GeomDrawFunc   *draw;

#ifdef GEOM_SM
	GeomShareFunc  *share;
	GeomPrivateFunc *private;
	GeomUnshareFunc	*unshare;
#else
	void		*share;
	void		*private;
	void		*unshare;
#endif
};

extern GeomClass *GeomClassCreate();
extern GeomClass *GeomSubClassCreate();
extern GeomClass *GeomClassLookup(char *classname);

extern char *(*GeomMallocP)();
extern void (*GeomFreeP)();
extern char *(*GeomReallocP)();

#define	GeomMalloc(n)	(*GeomMallocP)(n, GeomCurSM)
#define	GeomNew(type)	((type *)(*GeomMallocP)(sizeof(type), GeomCurSM))
#define	GeomNewN(type, n)  ((type *)(*GeomMallocP)(sizeof(type) * (n), GeomCurSM))
#define	GeomFree(p)	(*GeomFreeP)(p, GeomCurSM)
#define	GeomRealloc(p, n)  (*GeomReallocP)(p, n, GeomCurSM)


#endif GEOMCLASSDEF
