/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/* machine.c */

/* missing routines on systems; see include.h for defines */

#include "include.h"

void kb_strupr(s)
char *s;
{
  while ( *s )
    { *s = (char)toupper(*s);
      s++;
    }
}

/* finds string b in string a */
char *kb_strstr(a,b)
char *a;
char *b;
{
  char *ptr,*ch;

  for ( ; *a ; a++ )
    { for ( ptr = a, ch = b; *ch && (*ptr == *ch) ; ptr++,ch++ ) ; 
      if ( *ch == '\0' ) return a;
    }
  return NULL;
}


void kb_memmove(dest,src,n)
char *dest;
char *src;
int n;
{
  /* crude bytewise move */
  if ( (dest - src) > 0 )  /* move from top down */
    { 
      src += n; dest += n; 
      for ( ; n ; n-- ) *(--dest) = *(--src);
    }
  else  /* move from bottom up */
    { 
      for ( ; n ; n-- ) *(dest++) = *(src++);
    }
}
