
/*=========================================================================
  Hull.c    This file contains the functions that make the rest of
  the hull after the initial tetrahedron is built.
 =========================================================================*/

#include "structs.h"
#include "macros.h"

/*-------------------------------------------------------------------------
        Complete_hull goes through the vertex list and adds them to the hull
   if they are not already used.  It will mark the vertex once it is 
   looked at.
  -------------------------------------------------------------------------*/
complete_hull()
{
	register struct tvertex *v;

	v = vertices;
	do {
           if ( !v->mark ) {
                 v->mark = MARKED;
                 add_on( v );
                 if ( debug ) print_out( v );
                 clean_up();
                 }
            v = v->next;
            } while ( v != vertices );

}

/*---------------------------------------------------------------------------
      Add_on is passed a vertex.  It will first determine all faces that
  are visible from that point.  If none are visible then the point is 
  marked not active.  Then it will go through the edge list.  If both
  of the edges adjacent faces are  visible then the edge is marked
  deleted.  If one of the adjacent faces is visible then a new face is 
  made and the edges adjacent face[2] pointer is set to point to it.
  A temporary pointer is used so that any new edge just added to the 
  list will not be examined.
  --------------------------------------------------------------------------*/
add_on( p )
struct tvertex *p;

{
	register struct tface *f; 
	         struct tface *make_structs();
	register struct tedge *e;
        int vis;
	double vol;

        f = faces;
        do {
           volume( vol, f, p );
           if ( vol < 0 ) {
                /* mark the visible faces and set a flag */
                f->visible = VISIBLE;  
                vis = TRUE;                      
                }
   	   f = f->next;
   	   } while ( f != faces );

        if ( !vis ) {
              /* if no faces are visible then */
              /* mark the vertex inactive */
              p->active = !ACTIVE;  
              return; 
              }

        e = edges;
	do {
           struct tedge	*temp;
           temp = e->next;
           if ( e->adjface[0]->visible && e->adjface[1]->visible )
                /* if e is an interior edge, delete it */
                e->deleted = DELETED;

           else if ( e->adjface[0]->visible || e->adjface[1]->visible ) 
                /* if e is a border edge, make a new face */
                e->adjface[2] = make_structs( e, p );
           e = temp;
           } while ( e != edges );

}
