
/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Written by Todd Kaplan, October 1990.
 *      todd@poincare.geom.umn.edu
 */
#include <stdio.h>

void
cutnewline(line)
  char *line;
{ 
  int n=strlen(line); 
  if (n>0 && line[n-1]=='\n' && !(line==NULL)) line[n-1]='\0';
  /*fprintf(stderr,"%s %d \n",line,strlen(line));*/
}

main(argc,argv)
  int argc;
  char **argv;
{ int i,write=0;
  int namesc=0,scount=0;
  char **namesv;
  char *dr;
  FILE *fp,*fin;
  char line[100];
  fp=stdout;
  dr=(char *)malloc(3*sizeof(char));
  strcpy(dr,".");
  *argv++; argc--;
  while (argc-->0)
  {
    if (strcmp(*argv,"-w")==0 || strcmp(*argv,"-write")==0) 
    {
      write=1;
      *argv++;
      continue;
    }

    if (strcmp(*argv,"-show")==0 || strcmp(*argv,"-showdir")==0) 
    {
      showdir(1);
      *argv++;
      continue;
    }

    if (strcmp(*argv,"-no")==0 || strcmp(*argv,"-noshowdir")==0) 
    {
      showdir(0);
      *argv++;
      continue;
    }

    if (strcmp(*argv,"-r")==0 || strcmp(*argv,"-read")==0) 
    {
      write=0;
      *argv++;
      continue;
    }
    if (strcmp(*argv,"-d")==0 || strcmp(*argv,"-dir")==0)
    { 
      *argv++;
      if (argc-->0) 
      {
        free(dr);
        dr=(char *)malloc((strlen(*argv)+2)*sizeof(char));
        strcpy(dr,*argv);
        *argv++;
        continue;
      }
      else
      {
        fprintf(stderr,"directory name not specified\n");
        exit(1);
      }
    }

    if (strcmp(*argv,"-n")==0 || strcmp(*argv,"-names")==0)
    {
      if (argc-->0) 
      { *argv++;
        namesc=atoi(*argv);
        if (namesc==0 && (*argv[0]<'0' || *argv[0]>'9')) 
        {
          if (*argv[0]=='-') fin=stdin; else fin=fopen(*argv,"r");
          if (fin==NULL) 
          {
            fprintf(stderr,"Can't open the file %s \n",*argv);
            exit(1);
          }
          if (fgets(line,100,fin)==NULL) 
          { 
            fprintf(stderr,"file is empty! \n");
            exit(1);
          }
          cutnewline(line);
          namesc=atoi(line);
          namesv=(char **)malloc(namesc*sizeof(char *));
          for(i=0; i<namesc; i++)
          {
            if (fgets(line,100,fin)==NULL) 
            { fprintf(stderr,"missing file data"); namesc=i-1;}
            else 
            {
              cutnewline(line);
              *(namesv+i)=(char *)malloc((strlen(line)+2)*sizeof(char));
              strcpy(*(namesv+i),line); 
            }
          }
          if (!(fgets(line,100,fin)==NULL) && !(line[0]=='(')) 
          {
            cutnewline(line);           
            free(dr);
            dr=(char *)malloc((strlen(line)+2)*sizeof(char));
            strcpy(dr,line);
          }          
          *argv++; 
          fclose(fin);
          continue;
        }
        namesv=(char **)malloc(namesc*sizeof(char *));
        *argv++;
        for(i=0; i<namesc; i++)
          if (argc-->0)
          {
            *(namesv+i)=(char *)malloc((strlen(*argv)+2)*sizeof(char));
            strcpy(*(namesv+i),*argv); 
            *argv++;
          }
          else
          {
            fprintf(stderr,"not enough file names\n");
            exit(1);
          }
        continue;
      }
      else
      {
        fprintf(stderr,"no number of files specified\n");
        exit(1);
      }
    }
    if (strcmp(*argv,"-s")==0 || strcmp(*argv,"-suffix")==0)
    {
      if (argc-->0) 
      { *argv++;
        scount=atoi(*argv);
        if (scount==0 && (*argv[0]<'0' || *argv[0]>'9')) 
        {
          if (*argv[0]=='-') fin=stdin; else fin=fopen(*argv,"r");
          if (fin==NULL) 
          {
            fprintf(stderr,"Can't open the file %s \n",*argv);
            exit(1);
          }
          if (fgets(line,100,fin)==NULL) 
          { 
            fprintf(stderr,"file is empty! \n");
            exit(1);
          }
          cutnewline(line);
          scount=atoi(line);
          for(i=0; i<scount; i++)
          {
            if (fgets(line,100,fin)==NULL) 
              fprintf(stderr,"missing file data"); 
            else 
            {
              cutnewline(line);
              addsuff(line); 
            }
          }          
          *argv++; 
          fclose(fin);
          continue;
        }

        *argv++;
        for(i=0; i<scount; i++)
          if (argc-->0)
          {  
            addsuff(*argv);
            *argv++;
          }
          else
          {
            fprintf(stderr,"not enough suffix names\n");
            exit(1);
          }
        continue;
      }
      else
      {
        fprintf(stderr,"no number of suffixes specified\n");
        exit(1);
      }
    }

  }
  choosefile(&namesc,&namesv,&dr,dr,write);
  fprintf(fp,"%d\n", namesc);
  for(i=0; i<namesc; i++)
    fprintf(fp,"%s\n", *(namesv+i));
  fprintf(fp,"%s\n",dr);
  chfree(&namesc,&namesv);
}
