/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * Written by Todd Kaplan, October 1990.
 *      todd@poincare.geom.umn.edu
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <malloc.h>

#define MaxFiles 100
#define MaxName 100
#define MaxSuff 100
#define mystuff mydisplay, mywindow, mygc
#define rmystuff mydisplay, mywindow, rmygc
#define font "9x15"   /* 9x15 */
#define min(A,B) ((A>=B) ? B : A)
#define max(A,B) ((A>=B) ? A : B)
#define message(A); XFillRectangles(mystuff,&messbox,1); \
  XDrawString(rmystuff,messbox.x+5,messbox.y+letheight, A, strlen(A));
static XSizeHints myhint;
static shwdir=1;
static char *sufv[MaxSuff]; 
static int sufc=0;
static XFontStruct *font_struct;
static int letwidth=6;
static int letheight=13;
static int rows=10;
static XRectangle lstbox,cancelbox,okbox,fnamebox,upbox,downbox,mvbox,messbox;
static char *prompt_string="file name: ";  
struct elm {
  int chose;
  int ftype;
  char name[MaxName];
};

int
showdir(which)
  int which;
{  shwdir=which; return(which); }

int
addsuff(name)
  char *name;
{ if (sufc<MaxSuff)
  { sufc++;
    *(sufv+sufc-1)=(char *)malloc((strlen(name)+2)*sizeof(char));
    strcpy(*(sufv+sufc-1),name); return(1);
  }
  else return(0);
}

int
clearsuff()
{ int t;
  for(t=0; t<sufc; t++) free(*(sufv+t));
  sufc=0;
}
int
delsuff(name)
  char *name;
{ int t,t2,good=0;
  for(t=0; t<sufc; t++)
    if (strcmp(name,*(sufv+t))==0)
    { free(*(sufv+t)); 
      good=1;
      for(t2=t; t2<sufc; t2++) (*(sufv+t2)) = (*(sufv+t2+1));
      t--;
      sufc--;
    }
   return(good);
}

int
suflist(name)
  char *name;
{ int t;
  if (sufc==0) return(1);
  for(t=0; t<sufc; t++)
    if (match(name,*(sufv+t)))  return(1);
  return(0);
}
  
void
chfree(namesc, namesv)
  int *namesc;
  char ***namesv;
{ 
  while ((*namesc)-->0)
    if (*((*namesv)+(*namesc))!=NULL) free(*((*namesv)+(*namesc)));
  if (*namesv!=NULL) free(*namesv);
}

XRectangle assign(x,y,width,height)
  int x,y,width,height;
{ XRectangle box;
  box.x=x;
  box.y=y;
  box.width=width;
  box.height=height;
  return(box);
}

void init2()
{ lstbox=assign(19,19,15*letwidth+4,rows*letheight+4);
  upbox=assign(lstbox.x+lstbox.width,lstbox.y,15,15);
  downbox=assign(upbox.x,lstbox.y+lstbox.height-15,15,15);
  mvbox=assign(upbox.x,upbox.y+upbox.height,15,downbox.y-upbox.y-upbox.height);
  fnamebox=assign(0,lstbox.y+lstbox.height+30,letwidth*45+4,letheight*3+4);
  okbox=assign(upbox.x+upbox.width+50,50,letwidth*6+4,letheight+8);
  cancelbox=assign(okbox.x,okbox.y+okbox.height+30,okbox.width,okbox.height);
  messbox=assign(0,fnamebox.y+fnamebox.height+2,fnamebox.width,letheight+4);
}

void init()
{ int ascent,descent,dummy;  
  XCharStruct overall;
  if (font_struct!=NULL) 
  { XTextExtents(font_struct," ",1,&dummy,&ascent,&descent,&overall);
    letwidth=overall.width;
    letheight=ascent+descent;
  }
  init2();
  myhint.width=fnamebox.x+fnamebox.width+4; myhint.height=messbox.y+messbox.height+4;
}

inbox(box,myevent)
  XRectangle box;
  XEvent myevent;
{ if ( myevent.xbutton.x>=box.x && myevent.xbutton.x<=(box.x+box.width) &&
    myevent.xbutton.y>=box.y && myevent.xbutton.y<=(box.y+box.height)) return(1);
  else return(0);
}
 
void Cleanlst(lst,dirl)
  struct elm *lst;
  int dirl;
{ int i;
  for(i=1; i<=dirl; i++) lst[i].chose=0;
}

void flash(mydisplay,mywindow,mygc,box)
  Display *mydisplay; 
  Window mywindow;
  GC mygc;
  XRectangle box;
{ int delay=200;
  XEvent event;
  XSetFunction(mydisplay,mygc,GXxor);
  XFillRectangles(mystuff,&box,1);
  XPeekEvent(mydisplay,&event); 
  XFillRectangles(mystuff,&box,1); 
  XSetFunction(mydisplay,mygc,GXcopy);
} 

choosefile(namesc,namesv,dpath,dr,write_read)
  int *namesc;
  char ***namesv;
  char **dpath;
  char *dr;
  int write_read;
{ FILE  *fp;
  DIR *dirp,*dumdir; 
  char dum[300] ,inp[MaxName+20],  dum2[300],shell[300], dum3[MaxName+20],
    text[10],inp_string[30],chrctr[2]; 
  int i,found,chrows,k=0,flag=1,ch,dirl,kold,smooth=0,rdraw=0,chgdir=0,moved=0,
    done=0,getting=0,myscreen,x,y,pstn,start=1,n;
  struct dirent *dp;
  struct elm *lst;
  Display *mydisplay;
  Window mywindow,UrgWindow;
  XWindowAttributes sizeatt;
  GC mygc,rmygc;
  XEvent event,myevent;
  KeySym mykey;
  Cursor curs1,curs2;
  unsigned long myforeground, mybackground;
  strcpy(inp_string,"");
  strcpy(dum2,dr);
  lst=(struct elm *)(malloc(MaxFiles*sizeof(struct elm)));
  mydisplay=XOpenDisplay(NULL);
  if(mydisplay == NULL) {
     fprintf(stderr," Cannot connect to server!  Bye!\n");
     exit(1);
    }
  myscreen = DefaultScreen(mydisplay);
  mybackground= WhitePixel(mydisplay,myscreen);
  myforeground= BlackPixel(mydisplay,myscreen);
  font_struct=XLoadQueryFont(mydisplay,font);
  init();
  myhint.flags =PPosition | PSize; 
  mywindow=XCreateSimpleWindow (mydisplay, DefaultRootWindow (mydisplay), myhint.x,
    myhint.y, myhint.width, myhint.height,5,myforeground,mybackground);
  XSetStandardProperties(mydisplay,mywindow,(write_read) ? "Save" :
    "Load" ,"choosefile",None,NULL,0, &myhint);
  mygc=XCreateGC(mydisplay,mywindow,0,0);
  rmygc=XCreateGC(mydisplay,mywindow,0,0);
  if (font_struct!=NULL)  
  { XSetFont(mydisplay,mygc,font_struct->fid);
    XSetFont(mydisplay,rmygc,font_struct->fid);
  }
  curs1=XCreateFontCursor(mydisplay,XC_top_left_arrow);
  curs2=XCreateFontCursor(mydisplay,XC_watch);
  XDefineCursor(mydisplay,mywindow,curs1);
  XSetBackground(mydisplay,mygc,mybackground);
  XSetForeground(mydisplay,mygc,myforeground);
  XSetBackground(mydisplay,rmygc,myforeground);
  XSetForeground(mydisplay,rmygc,mybackground);
  XSelectInput(mydisplay,mywindow,ButtonPressMask | PointerMotionMask | 
    ButtonReleaseMask | KeyPressMask | ExposureMask );
  XMapRaised(mydisplay,mywindow);
  while (done ==0)  
  { if (flag) 
    { XDefineCursor(mydisplay,mywindow,curs2); 
      message("");
      dirl=0;
      sprintf(shell,"cd %s; pwd",dum2);
      fp=popen(shell,"r");
      fgets(dum2,100,fp);     
      pclose(fp); 
      n=strlen(dum2);
      if (n>0 && dum2[n-1]=='\n') dum2[n-1]='\0';
      dirp=opendir(dum2);
      if (dirp!=NULL) 
      { for (dp=readdir(dirp); dp!=NULL; dp=readdir(dirp))
        { if (dirl<(MaxFiles-1))
          { strncpy((lst[++dirl].name),(dp->d_name),MaxName-1);
            if (strlen(dp->d_name)>=MaxName)
            { message("Some File Names are too long ");}
            strcpy(dum,dum2);
            strcat(dum,"/");
            lst[dirl].chose=0;
            lst[dirl].ftype=!((dumdir=opendir(strcat(dum,lst[dirl].name)))==NULL);
            if (lst[dirl].ftype) closedir(dumdir);
            if (!((lst[dirl].ftype && shwdir) ||
              (suflist(dp->d_name) && !(lst[dirl].ftype) ))) dirl--;
          }
          else {message("Too many files in the Directory"); }
        } 
        closedir(dirp);
      }
      flag=0;
      XDefineCursor(mydisplay,mywindow,curs1); 
    }
    if ((start) && (*namesc>0))
    { for(start=0;*namesc>0; (*namesc)--)
      { found=0;
        for(i=dirl; i>=1; i--)
          if (match(lst[i].name,*((*namesv)+(*namesc)-1)) && (!lst[i].ftype)) 
          { lst[i].chose=1; found=1; k=i-2;  k=max(min(dirl+2-rows,k),0);
            if (write_read) {i=0;*namesc=0;} 
          }
        if (found) strcpy(inp_string,*((*namesv)));
      }
    }
    if (rdraw) 
    { rdraw=0;
      XDrawImageString (mystuff,okbox.x+(okbox.width)/2-letwidth*2,
        okbox.y+okbox.height/2+letheight/2,(chgdir) ? "OPEN" : " OK ",4);
      for(i=1; i<=rows && (i+k)<=dirl; i++)
        if (lst[i+k].chose) 
        { XFillRectangle(mystuff,lstbox.x+1,lstbox.y+3+(i-1)*letheight,
            15*letwidth,letheight);
          XDrawString(rmystuff,lstbox.x+1,lstbox.y+i*letheight,
            lst[i+k].name, min(strlen(lst[i+k].name),10));
          if (lst[i+k].ftype) 
            XDrawString(rmystuff,lstbox.x+1+letwidth*10,lstbox.y+i*letheight,"<dir>",5);
        }
        else
        { XDrawImageString (mystuff, lstbox.x+1,lstbox.y
            +i*letheight,strcat(strcpy(dum3,lst[i+k].name),"               "),10);
          XDrawImageString(mystuff,lstbox.x+1+letwidth*10,lstbox.y+
             i*letheight,(lst[i+k].ftype) ? "<dir>" : "     ",5);
        }
      for(; i<=rows; i++)
      XDrawImageString (mydisplay, mywindow, mygc,lstbox.x+1,lstbox.y+i*letheight, 
        "                       ", 15 );
      XFillRectangles(mydisplay,mywindow,rmygc,&mvbox,1);
      XDrawRectangles(mydisplay,mywindow,mygc,&mvbox,1);
      XFillRectangle(mydisplay,mywindow,mygc,mvbox.x,mvbox.y+mvbox.height*
        k/max((dirl+2),rows),mvbox.width,1+mvbox.height*rows/max(dirl+2,rows));
    }
    XNextEvent(mydisplay, &myevent);
    switch(myevent.type) {
    case ButtonRelease:
      if (smooth) smooth=0;
      break;
    case MotionNotify:
      if (smooth)  
      { kold=k;
        k=max((myevent.xmotion.y-mvbox.y)*max(dirl+2,rows),0)/mvbox.height;
        k=max(min(dirl+2-rows,k),0); if (kold!=k) rdraw=1;
      }
      break;    
    case MappingNotify:
      XRefreshKeyboardMapping ( &myevent);
      break;
    case Expose:
      if  (myevent.xexpose.count==0)
        XGetWindowAttributes(mydisplay,mywindow, &sizeatt);
      if (sizeatt.height!=myhint.height) 
      { chrows=(sizeatt.height-myhint.height)/(letheight);
        chrows=max(5-rows,chrows);
        rows+=chrows; myhint.height+=chrows*letheight; init2();
        k=max(min(dirl+2-rows,k),0);
      }
      XDrawRectangles(mystuff,&fnamebox,1); 
      XDrawRectangles (mystuff,&lstbox,1);
      XDrawRectangles (mystuff, &mvbox,1);
      XDrawRectangles (mystuff, &upbox,1);
      XDrawRectangles (mystuff, &downbox,1); 
      XDrawRectangles (mystuff, &okbox,1); 
      XDrawRectangles (mystuff, &cancelbox,1);  
      XDrawImageString (mystuff,cancelbox.x+(cancelbox.width)/2
        -letwidth*3,cancelbox.y+cancelbox.height/2+letheight/2,"CANCEL",6);
      XDrawString(mystuff,10+fnamebox.x,(fnamebox.height+letheight)/2
       +fnamebox.y-3,strcat(strcat(strcpy(dum3,prompt_string),inp_string),(getting)
       ? "_" : " "),strlen(prompt_string)+strlen(inp_string)+1);
      rdraw=1; 
      break;
    case KeyPress:
      if (XLookupString(&myevent, text, 10, &mykey, 0)==1)
      { if (!getting) 
        { pstn = 0;
          y =(fnamebox.height+letheight)/2+fnamebox.y-3;
          x = 10+fnamebox.x + letwidth*strlen(prompt_string);
          XDrawImageString(mystuff,x,y,"_                             ",30);
          getting=1;
        }
        if((text[0] >= 32) && (text[0]!='/') && (text[0]!='{') && (text[0]!='}') 
          && (text[0] <= 126) && pstn<30) 
        { XDrawImageString(mystuff,x,y,text,1);
          x += letwidth;
          XDrawImageString(mystuff,x,y,"_",1);
          inp_string[pstn] = text[0];
          pstn++;
        }
        if(((text[0] == 8) || (text[0] == 127)) && (pstn>0)) 
        { pstn--;
          x -= letwidth;
          XDrawImageString(mystuff,x,y,"_ ",2);
        }
        if (text[0]=='\r') 
        { getting=0;
          XDrawImageString(mystuff,x,y,"  ",2);  
          inp_string[pstn] = 0;
          if (pstn>0)
          { Cleanlst(lst,dirl);
            chgdir=0;
            rdraw=1;
            found=0;
            message("");
            for(i=dirl; i>=1; i--)
              if (match(lst[i].name,inp_string) && (!lst[i].ftype)) 
              { lst[i].chose=1; found=1; k=i-2;  k=max(min(dirl+2-rows,k),0);
                if (write_read) i=0; 
              }
            if ((!found) && (!write_read)) {message("Not found");}
            if ((found) && (write_read)) {message("Note: Already Exists");}
          }
        }
        inp_string[pstn] = 0;
      }
      break; 
    case ButtonPress:
      if (inbox(cancelbox,myevent)) done=2;
      if (inbox(okbox,myevent)) 
      if (chgdir) 
      { XDefineCursor(mydisplay,mywindow,curs2); 

        flash(mystuff,okbox); 
        strcat(dum2,"/");
        strcat(dum2,inp);
        flag=1; k=0; 
        rdraw=1;
        chgdir=0;
      }
      else done=1;
      if (inbox(downbox,myevent)) { flash(mystuff,downbox); k++; }
      if (inbox(upbox,myevent)) {flash(mystuff,upbox); k--; }
      if (inbox(mvbox,myevent))
      { k=(myevent.xbutton.y-mvbox.y)*max(dirl+2,rows)/mvbox.height; smooth=1;}
      k=max(min(dirl+2-rows,k),0);
      if (inbox(upbox,myevent) || inbox(downbox,myevent) || inbox(mvbox,myevent)) 
        rdraw=1;
      if (inbox(lstbox,myevent))
      { ch=(myevent.xbutton.y-(lstbox.y+3))/letheight+1; 
        if (ch+k>dirl) ch=0;
        rdraw=1;
        if (chgdir) { Cleanlst(lst,dirl); chgdir=0;}
        lst[ch+k].chose=(!lst[ch+k].chose);
        if ((ch>=1) && (ch<=rows) && ((lst[ch+k].ftype==1) || (write_read)))   
        { strcpy(inp,lst[ch+k].name);
          Cleanlst(lst,dirl);
          lst[ch+k].chose=1;
          if (lst[ch+k].ftype) chgdir=1;
        }
      }
      break;
    }
  }
  chfree(namesc,namesv);
  *namesc=0;
  if (done==2) {*namesv=NULL; *dpath=NULL; }
  else
  { *namesv=(char **)malloc(dirl*sizeof(char *));
    for(i=1; i<=dirl; i++)
      if (lst[i].chose)
      { 
        *((*namesv)+(*namesc))=(char *)malloc(strlen(lst[i].name)+2);
        strcpy(*((*namesv)+(*namesc)),lst[i].name);
        (*namesc)++;
      }
  /*  if (dpath!=NULL) free(dpath); */
    *dpath=(char *)malloc(strlen(dum2)+2);
    strcpy(*dpath,dum2);
  }
  XFreeGC (mydisplay,mygc); 
  XDestroyWindow (mydisplay,mywindow);
  XCloseDisplay (mydisplay);
  return(*namesc);
}

