/* isom.d/src file orders.c */
#include <stdio.h>
#define tmalloc(D,T,N) {D = (T *) malloc(sizeof(T)*(N)); \
  if (D==0) { fprintf(stderr,"Out of space.\n"); return(-1);}}
#define tfree(D) {if (D) free( (char *) D); D=0;}
#define MAXSHORT  65536
int npt,nperms,**perm,*haveorder,*sv,*orb,*cp,*permprod;
char *hadpt,check=0,termio=0;

char *malloc();
FILE *fopen(),*ip,*op;
char inf[100],outf[100];

main(argc,argv) int argc; char *argv[];
{ int arg,i;
  char err;
  err=0;  arg=1;
  if (argc<=arg) termio=1;
  else
  { while (argv[arg][0]=='-')
    { if (argv[arg][1]=='c') check=1;
      else {err=1; goto error;}
      arg++;
      if (argc<=arg) break;
    }
    if (argc<=arg) termio=1;
    else
    { strcpy(inf,argv[arg]); strcpy(outf,inf); strcat(outf,".");
      arg++; if (argc<=arg) strcat(outf,"orders"); else strcat(outf,argv[arg]);
    }
  }
  orders();
error:
  if (err)
  { fprintf(stderr,"Usage:    orders [-c] [inf] [outf]\n");
    exit(2);
  }
  else exit(0);
}

orders()
{ int  i,j,k,n;
  if (termio) ip=stdin;
  else if ((ip=fopen(inf,"r"))==0)
  { fprintf(stderr,"Cannot open %s.\n",inf); exit(2); }
  fscanf(ip,"%d%d%d%d",&npt,&nperms,&j,&k); seeknln();
  if (j!=0) seeknln(); if (k!=0) seeknln();
  tmalloc(perm,int *,2*nperms);
  tmalloc(orb,int,npt+1);
  tmalloc(cp,int,npt+1);
  tmalloc(sv,int,npt+1);
  tmalloc(haveorder,int,npt+1);
  tmalloc(hadpt,char,npt+1);
  tmalloc(permprod,int,npt+1);
  for (i=1;i<=nperms;i++)
  { k=2*i-2;
    tmalloc(perm[k],int,npt+1);
    tmalloc(perm[k+1],int,npt+1);
    for (j=1;j<=npt;j++) fscanf(ip,"%d",perm[k]+j); seeknln();
    invert(perm[k],perm[k+1]);
  }
  if (termio==0) fclose(ip);

  if ((k=orbitsv(1,sv))!=npt)
  { fprintf(stderr,"Permutation representation is not regular.\n"); exit(2);}

  for (n=1;n<=npt;n++) haveorder[n]=0;
  for (n=1;n<=npt;n++)
  { cp[0]=0;
    addsv(n,sv);
    if (check)
    { for (i=1;i<=npt;i++) permprod[i]=image(i);
      haveorder[order(permprod)]++;
    }
    else
    { k=i=1;
      while (1)
      { j=image(i);
        if (j==1) break;
        i=j; k++;
      }
      haveorder[k]++;
    }
  }

  if (termio) op=stdout; else op=fopen(outf,"w");
  fprintf(op,"Format 2.2\norders {\n");
  for (n=1;n<=npt;n++) if (haveorder[n]>0)
    fprintf(op,"    %4d : %4d\n",n,haveorder[n]);
  fprintf(op,"}\n");
  if (termio=0) fclose(op);
}

order(per) int *per;
{ int h,i,j,k,l,order;
  order=0;
  for (i=1;i<=npt;i++) hadpt[i]=0;
  for (i=1;i<=npt;i++) if (hadpt[i]==0)
  { l=1; j=i;
    while ((k=per[j])!=i) {l++; j=k; hadpt[j]=1;}
    if (order==0) order=l;
    else if (order!=l)
    if ((k=orbitsv(1,sv))!=npt)
    { fprintf(stderr,"Permutation representation is not regular.\n"); exit(2);}
  }
  return(order);
}

seeknln()
{ char c; while ((c=getc(ip))!='\n'); }

orbitsv(pt,sv) int pt,*sv;
/* Computes orbit of pt under perms listed in pno, and writes 
   Schreier vector into sv
*/
{ int u,v,w,x,z,lo;
  for (u=1;u<=npt;u++) sv[u]=0;
  orb[1]=pt; lo=1; sv[pt]= -1;
  for (x=1;x<=lo;x++)
  { z=orb[x];
    for (w=0;w<2*nperms;w+=2)
    { v=perm[w][z];
      if (sv[v]==0) { lo++; orb[lo]=v; sv[v]=w+1; }
    }
  }
  return(lo);
}

addsv(pt,sv)  int pt,*sv;
/* The Schreier vector sv is applied to the point pt, and the resulting word
   added to the end of cp. It is assumed that pt is in the orbit. If not, the
   program will break down.
   Externals: cp.
*/
{ int pn;
  pn=sv[pt]; while (pn!= -1)
  { (*cp)++; cp[*cp]=pn; pt=perm[pn][pt]; pn=sv[pt]; }
  return(0);
}

image(pt) int pt;
/* The image of pt under cp is computed and returned.
   Externals: perm,cp.
*/
{ int i;
  for (i=1;i<= *cp;i++) pt=perm[cp[i]][pt];
  return(pt);
}

invert(ptr1,ptr2) int *ptr1,*ptr2;
/* permutation ptr1 is inverted and put in ptr2.
   Externals: npt.
*/
{ int i;
  for (i=1;i<=npt;i++) ptr2[ptr1[i]]=i;
  return(0);
}
