/* isom.d/src file findisoms.c */
# define ORDRELSOP ".ordrels"
# define KBEQNOP ".kbeqn"
# define ABQUOTOP ".abquot"
# define PERMIMOP "permim"
# include <stdio.h>
# include <ctype.h>
# include <sys/types.h>	/* Added by Mark Meuer,  90.10.24 */
# include <sys/times.h>
# include "defs.h"
# include "list.h"
# include "word.h"
# include "afsa.h"
# include "reduce.h"
# include "input.h"
# define ISOM 0
# define EPI 1
# define HOMO 2
FILE * keyboard=0;
FILE * rfile=stdin;
FILE * wfile=stdout;
struct tms buffer;
boolean timelimit = FALSE;
boolean ontolimit = FALSE;
int maxtime; /*in seconds*/
int time;
int maxontotime; 
int ontotime;
int mode = ISOM;
int exit_code = 1;
extern word * user_gen_name;
extern gen * inv_of;
extern int num_gens; 
extern int gen_array_size;
word * User_gen_name[2];
gen * Inv_of[2];
int Num_gens[2];
int Gen_array_size[2];
boolean nobound = TRUE;
int lengthsum=0;
int maxlength=8;
boolean simple_11test = TRUE;
boolean simple_ontotest = TRUE;
boolean verbose = FALSE;
boolean cconjtest = FALSE;
boolean abtest = FALSE;
boolean permtest = FALSE;
afsa  * WA[2];
int max_len[2];
boolean solstop=FALSE;
int *** rules[2];
word * rulewords[2][2];
int nrules[2];
int * relinvolve=0;
int paired_gens=0;
int indep_gens=0;
int irred_indep_gens=0;
int * pairnumber=0;
int num_rels[2];
int max_rel[2];
word * rels[2];
int * invstates=0;
int ** States=0;
word * image=0;
word * inverse_image=0;
boolean first_pass;
boolean * seen;
int * reduced0;
int * reduced1;
int abgens=0;
int abtorsion=0;
int freeabgens=0;
int * abinvariants=0;
int ** abF0=0;
int ** abF1=0;
int ** imabF0=0;
int permdegree;
int num_permreps=0;
int num_cycletypes = 0;
int *** cyclecounts=0;
int * imperm=0;
int * imcyclecount=0;
int ** permrep1=0;
boolean ** poss_cycletype=0;

static void
store_gen_info PARMS((int i));
static void
retrieve_gen_info PARMS((int i));
static boolean 
next_accepted_word PARMS((int i,word *wp,int *states,int n));
static boolean find_isoms PARMS((VOID));
static boolean find_next_homo PARMS((int M));
static void complete_homo PARMS((VOID));
static void find_image PARMS((word * w1p,word * w2p));
static boolean all_gens_check PARMS((VOID));
static boolean onto_check PARMS((VOID));
static boolean reverse_homo_check PARMS((VOID));
static boolean gen_images_check PARMS((VOID)); 
static boolean ab_images_check PARMS((int i));
static boolean perm_images_check PARMS((int i));
static void lowtri_abF0 PARMS((VOID));
static void reorganise PARMS((int m));
static boolean first_accepted_cconj PARMS((word * wp));


main(argc,argv)
        int argc;
        char * argv[];
{
  boolean interactive = FALSE;
  char gp0[50], gp1[50], permgp[50];
  char filename[50];
  int c;
  int i,j,k;
  int gpindex=0;
  char * label;
  word w;
  word rel;
  word new_rel;
  int v=0;
  max_len[0] = max_len[1] = 0;

  i=1;
  if (i>=argc) badusage();
    while (argv[i][0]=='-'){
      if (strcmp(argv[i],"-a")==0)
      abtest = TRUE;
        else if (strcmp(argv[i],"-c")==0)
            cconjtest=TRUE;
        else if (strcmp(argv[i],"-s")==0)
            solstop=TRUE;
      else if (strcmp(argv[i],"-e")==0 && mode==ISOM){
      mode = EPI;
      simple_11test=FALSE;
    }
        else if (strcmp(argv[i],"-h")==0 && mode==ISOM){
      mode = HOMO;
      simple_11test = FALSE;
      simple_ontotest = FALSE;
    }
        else if (strcmp(argv[i],"-i")==0)
          interactive=TRUE;
        else if (strcmp(argv[i],"-l")==0){
      nobound = FALSE;
      lengthsum=0;
      j=0;
      i++;
      if (i==argc) badusage();
      while (argv[i][j]!='\0') {
        if (!isdigit(argv[i][j])) badusage();
        lengthsum = 10*lengthsum + argv[i][j]-'0';
        j++;
      }
    }
        else if (strcmp(argv[i],"-m")==0){
      maxlength=0;
      i++;
      j=0;
      if (i==argc) badusage();
      while (argv[i][j]!='\0') {
        if (!isdigit(argv[i][j])) badusage();
        maxlength = 10*maxlength + argv[i][j]-'0';
        j++;
      }
          if (maxlength==0)
            verbose=TRUE;
    }
        else if (strcmp(argv[i],"-ot")==0){
      ontolimit = TRUE;
      maxontotime=0;
      i++;
      j=0;
      if (i==argc) badusage();
      while (argv[i][j]!='\0') {
        if (!isdigit(argv[i][j])) badusage();
        maxontotime = 10*maxontotime + argv[i][j]-'0';
        j++;
      }
    }
    else if (strcmp(argv[i],"-p")==0){
      permtest=TRUE;
      i++;
      if (argv[i][0]=='-') badusage();
      strcpy(permgp,argv[i]);
    }
        else if (strcmp(argv[i],"-tt")==0){
      timelimit = TRUE;
      maxtime=0;
      i++;
      j=0;
      if (i==argc) badusage();
      while (argv[i][j]!='\0') {
        if (!isdigit(argv[i][j])) badusage();
        maxtime = 10*maxtime + argv[i][j]-'0';
        j++;
      }
    }
        else if (strcmp(argv[i],"-v")==0)
            verbose=TRUE;
        else  badusage();
    i++;
    if (i>=argc) badusage();
     }
  if (i!=argc -2) badusage();
  if (mode!=ISOM){
    if (abtest){
      fprintf(wfile,
    "\t# Warning. Abelian quotient test doesn't make sense here.\n");
      fprintf(wfile,"\t# -a flag switched off.\n");
    }
    if (permtest){
      fprintf(wfile,
    "\t# Warning. Permutation test doesn't make sense here.\n");
      fprintf(wfile,"\t# -p flag switched off.\n");
    }
  }
  strcpy(gp0,argv[argc -2]);
  strcpy(gp1,argv[argc -1]);
  setbuf(stdout,(char*)0);
  setbuf(stderr,(char*)0);


  label=vzalloc2(char,9);
  WA[0]=WA[1]=0;
  rels[0]=rels[1]=0;
  num_rels[0]=num_rels[1]=0;
  max_rel[0]=max_rel[1]=0;
  rules[0]=rules[1]=0;

/* reading in parameters from standard input */
  if (interactive){
    keyboard = fopen("/dev/tty","w");
    fprintf(keyboard,"In interactive mode.\n");
    fprintf(keyboard,"Programme expects parameters input.\n");
    fprintf(keyboard,"\t Terminate parameter set with a closing \}.\n");
    fprintf(keyboard,"parameters {\n");
    rfile=fopen("/dev/tty","r");
    while (read_next_string(label,8,stdin)){
      if (strcmp(label,"lengthsu")==0){
        nobound = FALSE;
        read_next_int(&lengthsum,stdin);
      }
      else if (strcmp(label,"maxlengt")==0)
          read_next_int(&maxlength,stdin);
    }
    while (getc(stdin)!='\}')
      ;
    if (maxlength==0) verbose=TRUE;
  }

/* reading in the info from gp0.ordrels */
  strcpy(filename,gp0);
  strcat(filename,ORDRELSOP);
  if ((rfile=fopen(filename,"r"))==0)
      { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
  while (read_next_string(label,8,rfile)){
    if (strcmp(label,"Format  ")==0)
  		format_echocheck("2.2",rfile,stdout);
    else if (strcmp(label,"words   ")==0 || strcmp(label,"gens    ")==0){
      /* The order of the generators in the group is being specified */
      read_gen_name_array(rfile);
    }
    else if (strcmp(label,"inverses")==0){
        read_inverse_array(rfile);
        store_gen_info(0);
    }
    else if (strcmp(label,"rels    ")==0){
      list temp;
      word uw1,uw2,pw2;
      if (inv_of==0){
        default_inverse_array();
        store_gen_info(0);
      }
      while (getc(rfile)!='\{')
        ;
      list_init(&temp,WORD,FIFO);
      word_init(&rel);
      while (read_next_rel(&rel,rfile)){
        list_insert(&temp,(dp)&rel);
        if (word_length(&rel)>max_rel[0])
          max_rel[0]=word_length(&rel);
        num_rels[0]++;
        word_reset(&rel);
      }
      while (getc(rfile)!='\}')
        ;
    
      for (i=1;i<=num_gens;i++){
        if (inv(i)==i){
          word_put_last(&rel,i);
          word_put_last(&rel,i);
          if (list_insert(&temp,(dp)&rel))
            num_rels[0]++;
          if (max_rel[0]<2)
            max_rel[0] = 2;
          word_reset(&rel);
        }
      }

      rels[0]=vzalloc2(word,num_rels[0]+1);
      i=1;
      while (list_delget_first(&temp,(dp)&rel)){
        word_init(rels[0]+i);
        word_cpy(&rel,rels[0]+i);
        i++;
        word_reset(&rel);
      }
      word_clear(&rel);
      list_clear(&temp);
    }
    else if (strcmp(label,"relinvol")==0){
      while (getc(rfile)!='\{')
        ;
      if (relinvolve==0){
        pairnumber=vzalloc2(int,num_gens+1);
        for (i=1;i<=num_gens;i++){
          if (inv(i)<=i){
            paired_gens++;
            pairnumber[i]=pairnumber[inv(i)]=paired_gens;
          }
        }
        relinvolve=vzalloc2(int,paired_gens+1);
        i=1;
        while (i<=paired_gens){
          read_next_int(relinvolve+i,rfile);
          if (relinvolve[i]>=0)
            indep_gens++;
          i++;
        }
      }
      while (getc(rfile)!='\}')
        ;
    }
  }
  fclose(rfile);
/* reading in the info from gp0.ordrels.kbeqn */
  strcpy(filename,gp0);
  strcat(filename,ORDRELSOP);
  strcat(filename,KBEQNOP);
  if ((rfile=fopen(filename,"r"))==0)
    { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
  
  while (read_next_string(label,8,rfile)){
    if (strcmp(label,"Format  ")==0)
  		format_check("2.2",rfile);
    else if (strcmp(label,"fsa     ")==0){
      WA[0]=afsa_read(&user_gen_name,rfile); 
      if (WA[0]->eos){ 
        afsa * WAcopy; 
        WAcopy=WA[0];
        WA[0]=0;
        WA[0]=afsa_eosdelete(WAcopy);
        afsa_clear(WAcopy);
        Free_dp((dp)WAcopy); WAcopy=0;
      }
      nrules[0] = afsa_num_negstates(WA[0]);
    }
    else if (strcmp(label,"rels    ")==0){
      while (getc(rfile)!='\{')
        ;
      rulewords[0][0]=vzalloc2(word,nrules[0]+1);
      rulewords[0][1]=vzalloc2(word,nrules[0]+1);
      word_init(&w);
      for (j=1;j<=nrules[0];j++){
        for (i=0;i<=1;i++){
          word_init((rulewords[0][i])+j);
          (void)read_next_word(&w,rfile);
          word2prog_word(&w,(rulewords[0][i])+j);
          word_reset(&w);
        }
      }
      word_clear(&w);
      while (getc(rfile)!='\}')
        ;
      rules[0] = reduction_rules(rulewords[0],nrules[0]);
    }      
  }
  fclose(rfile);

/* reading in the info from gp0.abquot */
  
  if (abtest){
    strcpy(filename,gp0);
    strcat(filename,ABQUOTOP);
    if ((rfile=fopen(filename,"r"))==0)
      { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
    while (read_next_string(label,8,rfile)){
      if (strcmp(label,"Format  ")==0)
  		format_check("2.2",rfile);
      else if (strcmp(label,"abinvari")==0){
        while (getc(rfile)!='\{')
          ;
        abinvariants = vzalloc2(int,paired_gens+1);
        while (read_next_int(&i,rfile)){
          abgens++;
          if (i!=0)
            abtorsion++;
          abinvariants[abgens]=i;
        } 
        freeabgens = abgens - abtorsion;
        while (getc(rfile)!='\}')
          ;
      }
      else if (strcmp(label,"abimages")==0 && freeabgens!=0){
        while (getc(rfile)!='\{')
          ;
        abF0 = vzalloc2(int *,paired_gens);
        abF0--;
        for (i=1;i<=paired_gens;i++){
          abF0[i] = vzalloc2(int,freeabgens);
          abF0[i]--;
        }
        word_init(&w);
        while (read_next_word(&w,rfile)){
  /* we read the generators, which are printed at the beginning of the row, 
just in case they aren't in the expected order */
          int dummy; /* just a place to put the stuff we're not
interested in reading */
          word2prog_gen(&w,&i);
          i = pairnumber[i];
          for (j=1;j<=abgens;j++){
            if (j<=abtorsion)
              read_next_int(&dummy,rfile);
            else
              read_next_int(abF0[i]+j-abtorsion,rfile);
          }
          word_reset(&w);
        }
        word_clear(&w);
        while (getc(rfile)!='\}')
          ;
/* although the matrix should have been made upper triangular by abquot we
have to repeat the procedure in case the generators are in a different
order */
        lowtri_abF0();
        imabF0 = vzalloc2(int *,paired_gens);
        imabF0--;
        for (i=0;i<=paired_gens;i++){
          imabF0[i] = vzalloc2(int,freeabgens);
          imabF0[i]--;
        }
      }

    }
    fclose(rfile);
  }

  if (permtest){
    int ** tempccount;
    int l;
    boolean identical;
    strcpy(filename,gp0);
    strcat(filename,".");
    strcat(filename,permgp);
    strcat(filename,PERMIMOP);
    if ((rfile=fopen(filename,"r"))==0)
      { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
    while (read_next_string(label,8,rfile)){
      if (strcmp(label,"Format  ")==0)
  		format_check("2.2",rfile);
	  else if (strcmp(label,"permimag")==0){
      	num_permreps++;
        if (num_permreps==1){
          while (getc(rfile)!='\{')
            ;
          read_next_int(&permdegree,rfile);
          while (getc(rfile)!='\}')
            ;
        }
	  } 
   	}
    if (num_permreps!=0){
      cyclecounts = vzalloc2(int**, num_permreps);
      cyclecounts--;
      fclose(rfile);
      rfile=fopen(filename,"r");
      for (k=1;k<=num_permreps;k++){
        tempccount = vzalloc2(int *,paired_gens);
        tempccount--;
        find_keyword("permimage",rfile);
        while (getc(rfile)!='\{') 
          ;
        find_keyword("degree",rfile);
        (void)read_next_int(&i,rfile);
/*   we're not going to use this information, but we need to read past this
integer */
        word_init(&w);
        while (read_next_word(&w,rfile)){
  /* we read the generators, which are printed at the beginning of the row, 
just in case they aren't in the expected order */
          int * permim;
          permim = vzalloc2(int,permdegree+1);
          for (j=1;j<=permdegree;j++)
            permim[j]=j;
          word2prog_gen(&w,&i);
          while (getc(rfile)!=':')
            ;
          while ((c=getc(rfile))==' ' || c=='\t' || c=='\n')
            ;
          if (c=='I' || c=='i'){ 
            read_next_string(label,8,rfile);
            if (strcmp(label,"dentity ")!=0)
              bad_data();
          }
          else if (c=='\('){
            int x,y,z;
            do {
              read_next_int(&y,rfile);
              z = y;
              do {
                x = y;
                while ((c=getc(rfile))==' ' || 
                  c=='\t' || c=='\n')
                  ;
                if (c==','){
                  read_next_int(&y,rfile);
                  permim[x] = y;
                }
              } while (c==',');
              permim[x]=z;
            } while (getc(rfile)=='(');
          }
          else 
            bad_data();
          if (i<=inv(i)){
            int i2 = pairnumber[i];
            tempccount[i2] = vzalloc2(int,permdegree);
            tempccount[i2]--;
            for (j=1;j<=permdegree;j++){
              int l=j;
              int m;
              int cyclelength=1;
              while ((m=permim[l])!=j){
                l=m;
                cyclelength++;
              } 
              tempccount[i2][cyclelength]++;
            }
          }
          Free_dp((dp)permim);     
          permim=0;
          word_reset(&w);
        }
        while (getc(rfile)!='\}')
          ;
        word_clear(&w);
        for (l=1;l<=num_cycletypes;l++){
          identical = TRUE;
          for (i=1;i<=paired_gens;i++){
            for (j=1;j<=permdegree;j++){
              if (cyclecounts[l][i][j] !=tempccount[i][j]){
                identical = FALSE;
                break;
              }  
            }
            if (identical == FALSE)
              break;
          }
          if (identical)
            break;
        }
        if (identical){
          for (i=1;i<=paired_gens;i++){
            tempccount[i]++;
            Free_dp((dp)tempccount[i]); tempccount[i]=0;
          }
          tempccount++;
          Free_dp((dp)tempccount); tempccount=0;
        }
        else {
          num_cycletypes++;
          cyclecounts[num_cycletypes]=tempccount;
          tempccount=0;
        }
      }
            
      imperm = vzalloc2(int,permdegree);
      imperm--;
      imcyclecount = vzalloc2(int,permdegree);
      imcyclecount--;
      poss_cycletype = vzalloc2(boolean *,paired_gens+1);
      for (i=0;i<=paired_gens;i++)
        poss_cycletype[i] = vzalloc2(boolean,num_cycletypes+1);
      for (k=1;k<=num_cycletypes;k++)
        poss_cycletype[0][k] = TRUE;
    }
    else {
      fprintf(wfile,
        "\t# Warning. No permutation group images for first group.\n");
      fprintf(wfile,"\t# -p flag switched off.\n");
      permtest = FALSE;
    }
  }
  
  reduced0=vzalloc2(int,paired_gens+1);
  irred_indep_gens =indep_gens;
  word_init(&w);
  for (i=1;i<=num_gens;i++){
    word_put_last(&w,i);
    wa_reduction(WA[0],rules[0],&w);
    if (word_length(&w)==0)
      reduced0[pairnumber[i]]=0;
    else {
      word_get_last(&w,&j);
      reduced0[pairnumber[i]] = pairnumber[j];
    }
    word_reset(&w);
    if (i<=inv(i) && reduced0[pairnumber[i]]!=pairnumber[i] 
        && pairnumber[i]<=indep_gens)
      irred_indep_gens--;
  }
  word_clear(&w);

/* End of input for first group. Now we read in the info for the second
group */

  user_gen_name = 0;
  num_gens = 0;
  inv_of = 0;
  if (maxlength!=0){
/* reading in the info from gp1.ordrels */
    strcpy(filename,gp1);
    strcat(filename,ORDRELSOP);
    if ((rfile=fopen(filename,"r"))==0)
        { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
    while (read_next_string(label,8,rfile)){
      if (strcmp(label,"Format  ")==0)
        format_check("2.2",rfile);
      else if (strcmp(label,"words   ")==0 || strcmp(label,"gens    ")==0){
        /* The order of the generators in the group is being 
          specified */
        read_gen_name_array(rfile);
      }
      else if (strcmp(label,"inverses")==0){
        read_inverse_array(rfile);
        store_gen_info(1);
      }
      else if (strcmp(label,"rels    ")==0){
        list temp;
        word uw1,uw2,pw2;
        if (inv_of==0){
          default_inverse_array();
          store_gen_info(1);
        }
        while (getc(rfile)!='\{')
          ;
        list_init(&temp,WORD,FIFO);
        word_init(&rel);
        while (read_next_rel(&rel,rfile)){
          list_insert(&temp,(dp)&rel);
          if (word_length(&rel)>max_rel[1])
            max_rel[1]=word_length(&rel);
          num_rels[1]++;
          word_reset(&rel);
        }
        while (getc(rfile)!='\}')
          ;
      
        for (i=1;i<=num_gens;i++){
          if (inv(i)==i){
            word_put_last(&rel,i);
            word_put_last(&rel,i);
            if (list_insert(&temp,(dp)&rel))
              num_rels[1]++;
            if (max_rel[1]<2)
              max_rel[1] = 2;
            word_reset(&rel);
          }
        }

        rels[1]=vzalloc2(word,num_rels[1]+1);
        i=1;
        while (list_delget_first(&temp,(dp)&rel)){
          word_init(rels[1]+i);
          word_cpy(&rel,rels[1]+i);
          i++;
          word_reset(&rel);
        }
        word_clear(&rel);
        list_clear(&temp);
      }
    }
  }
  fclose(rfile);

/* reading in the info from gp1.ordrels.kbeqn */
  strcpy(filename,gp1);
  strcat(filename,ORDRELSOP);
  strcat(filename,KBEQNOP);
  if ((rfile=fopen(filename,"r"))==0)
    { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
    
  while (read_next_string(label,8,rfile)){
    if (strcmp(label,"Format  ")==0)
      format_check("2.2",rfile);
    else if (strcmp(label,"fsa     ")==0){ 
     WA[1]=afsa_read(&user_gen_name,rfile); 
      if (WA[1]->eos){ 
        afsa * WAcopy; 
        WAcopy=WA[1];
        WA[1]=0;
        WA[1]=afsa_eosdelete(WAcopy);
        afsa_clear(WAcopy);
        Free_dp((dp)WAcopy); WAcopy=0;
      }
      if (num_gens==0)
        num_gens = WA[1]->base_symbols;
      nrules[1] = afsa_num_negstates(WA[1]);
    }
    else if (strcmp(label,"inverses")==0 && inv_of == 0){
      read_inverse_array(rfile);
      store_gen_info(1);
    }
    else if (strcmp(label,"rels    ")==0){
      int * genoccurs;
      word_traverser wt;
      gen g;
      if (inv_of==0){
        default_inverse_array();
        store_gen_info(1);
      }
      while (getc(rfile)!='\{')
        ;
      genoccurs = vzalloc2(int,num_gens+1);
      rulewords[1][0]=vzalloc2(word,nrules[1]+1);
        rulewords[1][1]=vzalloc2(word,nrules[1]+1);
      word_init(&w);
      for (j=1;j<=nrules[1];j++){
        for (i=0;i<=1;i++){
          word_init((rulewords[1][i])+j);
          (void)read_next_word(&w,rfile);
          word2prog_word(&w,(rulewords[1][i])+j);
          if (simple_ontotest){
            word_traverser_init(&wt,rulewords[1][i] + j);
            while (word_next(&wt,&g)){
              if (g<=inv(g))
                genoccurs[g]++;
              else
                genoccurs[inv(g)]++;
            }
            word_traverser_clear(&wt);
          }
          word_reset(&w);
        }
        if (simple_ontotest){
          for (g=1;g<=num_gens;g++) {
            if (genoccurs[g]==1){
              fprintf(wfile,"\t# Generator ");
              gen_print(wfile,g);
              fprintf(wfile,
            " is redundant. Simple onto test switched off.\n");  
              simple_ontotest = FALSE;
              break;
            }
            else
              genoccurs[g]=0;
          }
        }
      }
      word_clear(&w);
      Free_dp((dp)genoccurs); genoccurs=0;
      rules[1] = reduction_rules(rulewords[1],nrules[1]);
      while (getc(rfile)!='\}')
        ;
    }      
  }
  fclose(rfile);
  
/* reading in the info from gp1.abquot */
  if (abtest){
    strcpy(filename,gp1);
    strcat(filename,ABQUOTOP);
    if ((rfile=fopen(filename,"r"))==0)
      { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
    while (read_next_string(label,8,rfile)){
      if (strcmp(label,"Format  ")==0)
        format_check("2.2",rfile);
      else if (strcmp(label,"abinvari")==0){
        while (getc(rfile)!='\{')
          ;
        i=1;
        while (read_next_int(&j,rfile)){
          if (abinvariants[i]!=j){
            fprintf(wfile,"\t# Abelian invariants don't match\n");
            fprintf(wfile,"\t# Groups cannot possibly be isomorphic.\n");
            exit(1);
          }
          else 
            i++;
        }
        while (getc(rfile)!='\}')
          ;
      }
      else if (strcmp(label,"abimages")==0 && freeabgens!=0){
        while (getc(rfile)!='\{')
          ;
        abF1 = vzalloc2(int *,num_gens);
        abF1--;
        for (i=1;i<=num_gens;i++){
          abF1[i] = vzalloc2(int,freeabgens);
          abF1[i]--;
        }
        word_init(&w);
        while (read_next_word(&w,rfile)){
  /* we read the generators, which are printed at the beginning of the row, 
just in case they aren't in the expected order */
          int dummy;
          word2prog_gen(&w,&i);
          for (j=1;j<=abgens;j++){
            if (j<=abtorsion)
              read_next_int(&dummy,rfile);
            else
              read_next_int(abF1[i]+j-abtorsion,rfile);
          }
          if (i!=inv(i)){
/* set the entries for the inverse generator */
            for (j=1;j<=freeabgens;j++)
                abF1[inv(i)][j] = -abF1[i][j];
          }
          word_reset(&w);
        }
        word_clear(&w);
        while (getc(rfile)!='\}')
          ;
      }
    }
    fclose(rfile);
  }

  if (permtest){
	boolean permimsfound = FALSE;
    strcpy(filename,gp1);
    strcat(filename,".");
    strcat(filename,permgp);
    strcat(filename,PERMIMOP);
    if ((rfile=fopen(filename,"r"))==0)
      { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
    while (read_next_string(label,8,rfile)){
      if (strcmp(label,"Format  ")==0)
  		format_check("2.2",rfile);
	  else if (strcmp(label,"permimag")==0){
		permimsfound = TRUE;
      	permrep1 = vzalloc2(int*,num_gens);
      	permrep1--;
      	while (getc(rfile)!='\{') 
       	 ;
      	find_keyword("degree",rfile);
      	(void)read_next_int(&i,rfile);
/* we're not going to use this information, but we need to read past this
integer */
      	word_init(&w);
     	 while (read_next_word(&w,rfile)){
  /* we read the generators, which are printed at the beginning of the row, 
just in case they aren't in the expected order */
       	 word2prog_gen(&w,&i);
       	 permrep1[i] = vzalloc2(int,permdegree);
       	 permrep1[i]--;
       	 while (getc(rfile)!=':')
       	   ;
  
       	 for (j=1;j<=permdegree;j++)
       	   permrep1[i][j]=j;
       	while ((c=getc(rfile))==' ' || c=='\t' || c=='\n')
        	  ;
          if (c=='I' || c=='i'){ 
            read_next_string(label,8,rfile);
            if (strcmp(label,"dentity ")!=0)
              bad_data();
          }
          else if (c=='\('){
            int x,y,z;
            do {
              read_next_int(&y,rfile);
              z = y;
              do {
                x = y;
                while ((c=getc(rfile))==' ' || c=='\t' || c=='\n')
                  ;
                if (c==','){
                  read_next_int(&y,rfile);
                  permrep1[i][x] = y;
                }
              }
              while (c==',');
              permrep1[i][x]=z;
            } while (getc(rfile)=='(');
          }
          else 
            bad_data();
          word_reset(&w);
		  if (i<inv(i)){
       	 	permrep1[inv(i)] = vzalloc2(int,permdegree);
       	    permrep1[inv(i)]--;
		    for (j=1;j<=permdegree;j++)
				permrep1[inv(i)][permrep1[i][j]] = j;
          }
        }  
        word_clear(&w);
        while (getc(rfile)!='\}')
           ;
		break;
      }
	}
    if (permimsfound == FALSE) {
      fprintf(wfile,
      "\t# Warning. No permutation group images for second group.\n");
      fprintf(wfile,"\t# -p flag switched off.\n");
      permtest = FALSE;
      for (k=1;k<=num_cycletypes;k++){
        for (i=1;i<=paired_gens;i++){
          cyclecounts[k][i]++;
          Free_dp((dp)cyclecounts[k][i]);
          cyclecounts[k][i]=0;
        }
        cyclecounts[k]++;
        Free_dp((dp)cyclecounts[k]); cyclecounts[k]=0;
      }
      cyclecounts++;
      Free_dp((dp)cyclecounts);
      cyclecounts=0;
      for (i=0;i<=paired_gens;i++){
        Free_dp((dp)poss_cycletype[i]); poss_cycletype[i]=0;
      }
      Free_dp((dp)poss_cycletype); poss_cycletype=0;
      imperm++;
      Free_dp((dp)imperm); imperm=0;
      imcyclecount++;
      Free_dp((dp)imcyclecount); imcyclecount=0;
    }
  }
  
  
  seen=vzalloc2(boolean,num_gens+1);
  reduced1=vzalloc2(int,num_gens+1);
  word_init(&w);
  for (i=1;i<=num_gens;i++){
    word_put_last(&w,i);
    wa_reduction(WA[1],rules[1],&w);
    if (word_length(&w)==0)
      reduced1[i]=0;
    else {
      word_get_last(&w,&j);
      reduced1[i] = j;
    }
    word_reset(&w);
  }
  word_clear(&w);

  (void)find_isoms();  

  Free_dp((dp)label); label=0;
  Free_dp((dp)relinvolve); relinvolve=0;

  for (gpindex=0;gpindex<=1;gpindex++){
    retrieve_gen_info(gpindex);
    for (i=0;i<gen_array_size;++i)
      word_clear(user_gen_name+i);
    Free_dp((dp)user_gen_name); user_gen_name=0;
    Free_dp((dp)inv_of); inv_of=0;
    if (rels[gpindex]!=0){
      for (i=1;i<=num_rels[gpindex];i++)
        word_clear(rels[gpindex]+i);
      Free_dp((dp)rels[gpindex]); rels[gpindex]=0;
    }
    for (i=0;i<=1;i++){
      for (j=1;j<=nrules[gpindex];j++)
        word_clear((rulewords[gpindex][i])+j);
      Free_dp((dp)rulewords[gpindex][i]);
      rulewords[gpindex][i]=0;
    }
    clear_reduction_rules(rules[gpindex]);
    Free_dp((dp)rules[gpindex]); rules[gpindex]=0;
    afsa_clear(WA[gpindex]);
    Free_dp((dp)WA[gpindex]); WA[gpindex]=0;
  }
  if (abtest){
    Free_dp((dp)abinvariants);
    abinvariants=0;
    if (freeabgens!=0){
      for (i=1;i<=paired_gens;i++){
        abF0[i]++;
        Free_dp((dp)abF0[i]); 
        abF0[i]=0;
      }
      abF0++;
      Free_dp((dp)abF0); abF0=0;
      for (i=1;i<=Num_gens[1];i++){
        abF1[i]++;
        Free_dp((dp)abF1[i]); 
        abF1[i]=0;
      }
      abF1++;
      Free_dp((dp)abF1); abF1=0;
      for (i=0;i<=paired_gens;i++){
        imabF0[i]++;
        Free_dp((dp)imabF0[i]); 
        imabF0[i]=0;
      }
      imabF0++;
      Free_dp((dp)imabF0); imabF0=0;
    }
  }
  if (permtest){
    for (k=1;k<=num_cycletypes;k++){
      for (i=1;i<=paired_gens;i++){
        cyclecounts[k][i]++;
        Free_dp((dp)cyclecounts[k][i]);
        cyclecounts[k][i]=0;
      }
      cyclecounts[k]++;
      Free_dp((dp)cyclecounts[k]); cyclecounts[k]=0;
    }
    cyclecounts++;
    Free_dp((dp)cyclecounts);
    cyclecounts=0;
    for (i=0;i<=paired_gens;i++){
      Free_dp((dp)poss_cycletype[i]); poss_cycletype[i]=0;
    }
    Free_dp((dp)poss_cycletype); poss_cycletype=0;
    imperm++;
    Free_dp((dp)imperm); imperm=0;
    imcyclecount++;
    Free_dp((dp)imcyclecount); imcyclecount=0;
    for (i=1;i<=Num_gens[1];i++){
      permrep1[i]++;
      Free_dp((dp)permrep1[i]);
      permrep1[i]=0;
    }
    permrep1++;
    Free_dp((dp)permrep1); permrep1=0;
  }
  Free_dp((dp)pairnumber); pairnumber=0;
  Free_dp((dp)seen); seen=0;
  Free_dp((dp)reduced0); reduced0=0;
  Free_dp((dp)reduced1); reduced1=0;
  exit(exit_code);
  assert(store_ptrs == 0);
}

static void
store_gen_info(i)
  int i;
{
  if (User_gen_name[i] == 0)
    User_gen_name[i]=user_gen_name;
  if (Num_gens[i] == 0)
    Num_gens[i]=num_gens;
  if (Inv_of[i] == 0)
    Inv_of[i]=inv_of;
  if (Gen_array_size[i] == 0)
    Gen_array_size[i]=gen_array_size;
}

static void
retrieve_gen_info(i)
  int i;
{
  user_gen_name=User_gen_name[i];
  num_gens=Num_gens[i];
  inv_of=Inv_of[i];
  gen_array_size=Gen_array_size[i];
}

/* this function can only be used as stands for prefix closed languages */
static boolean
next_accepted_word(index,wp,states,n)
  int index; /* 0 or 1, indexing the group */
  word * wp;
  int * states;
  int n;
{
  int ** array=WA[index]->array;
  int symbols=WA[index]->symbols;
  boolean ans=FALSE;
  boolean backtrack=FALSE;
  gen g=INVALID_GEN;
  int l=word_length(wp);
  int k;
  if (l==0 && states[0]==0){
/* we mustn't forget that the identity can be accepted. This way it's picked
up on the first pass through */
    states[0]=1;
    return TRUE;
  }
  else if (n==0 ||symbols==0) {
    word_reset(wp);
    states[0]=0;
    return FALSE; /* only the identity should be accepted */
  }
  g=1;
  while (l>0||backtrack==FALSE) {
    if (l==n)
      backtrack=TRUE;
    while (backtrack){
      word_delget_last(wp,&g);
      l--;
    /* find the next generator, if there is one */
      if (g!=symbols){
        g++;
        backtrack=FALSE;
      }
      else {
        if (l==0)
          break;
      }
    }
    if ((backtrack)&&l==0)
      break;
      /* Now  try to move forward */
    while ((k=array[g][states[l]])<=0){
      if (g!=symbols)
        g++;
      else {
        backtrack=TRUE;
        break;
      }
    }
    if (backtrack)
      continue;
    else {
      assert(k>0);
      states[l+1] = k;
      word_put_last(wp,g);
      max_len[index] = (max_len[index] > (l+1)? max_len[index] : l+1);
      return TRUE;
    }
  }
  if (ans==FALSE){
    word_reset(wp);
    for (l=0;l<=n;l++)
      states[l]=0;
  }
  return ans;
}

static boolean
find_isoms()
{
  boolean success=FALSE;
  int i;
  int M;
  list_traverser lt;

  boolean loop=FALSE; 
/* in certain circumstances we want to make sure we go through a loop
precisely once. This variables controls that  */


  States = vzalloc2(int *,paired_gens+1);
  invstates = vzalloc2(int,maxlength+1);
  image = vzalloc2(word,paired_gens+1);
  inverse_image=vzalloc2(word,Num_gens[1]+1);
  for (i=0;i<=Num_gens[1];i++)
    word_longinit(inverse_image+i,maxlength+1);

  for (M=0;(nobound)||M<=lengthsum;M++){
    if (timelimit){
      times(&buffer);
      time = (buffer.tms_utime)/60; 
      if (time > maxtime){
        fprintf(wfile,
          "\t# Time limit of %d secs exceeded. Exiting.\n",maxtime);
        exit(exit_code);
      }
    }
    for (i=0;i<=paired_gens;i++){
      if (i!=0)
        States[i]=vzalloc2(int,M+1);
      if (i<=indep_gens)
        word_longinit(image+i,M+1);
      else if (relinvolve[i] != -num_rels[0]-1)
        word_longinit(image+i,M*max_rel[0]+1);
      else
        word_longinit(image+i,maxlength+1);
/* it seems safer to ensure that a word is never allocated zero space */
    }
    fprintf(wfile,"\t# Sum of relevant image lengths = %d\n",M);
    if ((simple_11test) && M < irred_indep_gens)
      continue;
    if (M==0 && irred_indep_gens==0)
      loop = TRUE; 
    first_pass = TRUE;
    while ((find_next_homo(M))||(loop)){
      complete_homo();
      if (mode==HOMO || verbose){
        fprintf(wfile,"\n\t# Images:-\n\t# ");
        for (i=1;i<=Num_gens[0];i++){
          if (Inv_of[0][i]>=i){
            retrieve_gen_info(0);
            gen_print(wfile,i);
            fprintf(wfile," -> ");
            retrieve_gen_info(1);
            word_print(wfile,image+pairnumber[i]);
            fprintf(wfile," ");
          }
        }
        fprintf(wfile,"\n");
      }
      if (maxlength!=0){
        if (onto_check()){
          if (mode==HOMO || verbose)
      fprintf(wfile,"\t# The map is an epimorphism.\n");
          else if (mode==EPI){
            fprintf(wfile,"\n\t# Images:-\n\t# ");
            for (i=1;i<=Num_gens[0];i++){
              if (Inv_of[0][i]>=i){
                retrieve_gen_info(0);
                gen_print(wfile,i);
                fprintf(wfile," -> ");
                retrieve_gen_info(1);
                word_print(wfile,image+pairnumber[i]);
                fprintf(wfile," ");
              }
            }
            fprintf(wfile,"\n");
          }
          if (mode!=ISOM || verbose){
            fprintf(wfile,"\t# Reverse images:-\n\t# ");
            for (i=1;i<=Num_gens[1];i++) {
              if (i<=Inv_of[1][i]){  
                retrieve_gen_info(1);
                gen_print(wfile,i);
                fprintf(wfile," -> ");
                retrieve_gen_info(0);
                word_print(wfile,inverse_image+i);
                fprintf(wfile," ");
              }
            }
            fprintf(wfile,"\n");
          }
          if (reverse_homo_check()){
            if (mode!=ISOM || verbose)
      fprintf(wfile,"\t# Reverse mapping is a homomorphism.\n");
            if (gen_images_check()) {
  /* check the reverse images of the images of the generators; that should 
  give us the generators back again */
              if (mode==ISOM && verbose==FALSE){
                fprintf(wfile,"\n\t# Images:-\n\t# ");
                for (i=1;i<=Num_gens[0];i++){
                  if (Inv_of[0][i]>=i){
                    retrieve_gen_info(0);
                    gen_print(wfile,i);
                    fprintf(wfile," -> ");
                    retrieve_gen_info(1);
                    word_print(wfile,image+pairnumber[i]);
                    fprintf(wfile," ");
                  }
                }
                fprintf(wfile,"\n");
                fprintf(wfile,"\t# Inverse images:-\n\t# ");
                for (i=1;i<=Num_gens[1];i++) {
                  if (i<=Inv_of[1][i]){  
                    retrieve_gen_info(1);
                    gen_print(wfile,i);
                    fprintf(wfile," -> ");
                    retrieve_gen_info(0);
                    word_print(wfile,inverse_image+i);
                    fprintf(wfile," ");
                  }
                }
                fprintf(wfile,"\n");
                if (solstop) exit(0);
                else exit_code = 0;
              }
              else {
        fprintf(wfile,"\t# Reverse mapping is inverse.\n");
        fprintf(wfile,"\t# The map is an isomorphism.\n");
        if (solstop) exit(0);
        else exit_code = 0;
              }
            }
            else if (mode!=ISOM || verbose)
  fprintf(wfile,"\t# Reverse mapping does not appear to be inverse.\n");
          }
          else if (mode!=ISOM || verbose)
  fprintf(wfile,"\t# Reverse mapping does not appear to be a homomorphism.\n");
        }  
      }
      else {
        if (solstop) exit(0);
        else exit_code = 0;
      }
        
      loop=FALSE;
    }
    for (i=0;i<=paired_gens;i++){
      if (i!=0)
        Free_dp((dp)States[i]);
      word_clear(image+i);
    }
    if ( M > max_len[1] * paired_gens + 1){
      fprintf(wfile,
        "\t# No words in 2nd group of length > %d.\n", max_len[1]);
      fprintf(wfile,"\t# Halted search after lengthsum %d.\n",M);
      exit(exit_code);
    }
  }
  for (i=0;i<=Num_gens[1];i++)
    word_clear(inverse_image+i);
  Free_dp((dp)invstates); invstates=0;
  Free_dp((dp)States); States=0;
  Free_dp((dp)image); image=0;
  Free_dp((dp)inverse_image); inverse_image=0;
  return success;  
}

static boolean 
find_next_homo(M)
  int M; /* the sum of the lengths of the words */
{
  boolean ans=TRUE;
  boolean success=TRUE;
  boolean not_backtracking=TRUE;
  boolean repeat;
  int i=0;
  int j;
  int k;
  int sum=0;
  int m;
  word rel;
  word w;


  inv_of = Inv_of[1];
  if (irred_indep_gens==0)
/* in this case all the independent generators must reduce to the identity,
and therefore map onto it. To avoid endless looping through this function we
deal with this case separately. */
    return FALSE;
  if (first_pass)
    i=1;
  else
    i=indep_gens;
  for (j=1;j<=i-1;j++)
    if (reduced0[j]==j)
      sum += word_length(image+j);

  word_longinit(&rel,max_rel[0]+1);
  word_longinit(&w,max_rel[0]*M+1);
/* w is used to hold the image of a relator. Each of the generators
appearing in the generator will have an image of length at most M (and
almost certainly less than M) */

  while (1!=0) {
    if (timelimit){
      times(&buffer);
      time = (buffer.tms_utime)/60; 
      if (time > maxtime){
        fprintf(wfile,
          "\t# Time limit of %d secs exceeded. Exiting.\n",maxtime);
        exit(exit_code);
      }
    }
    while (i>0){
/*  At this stage, the images of the first i-1 generators are set, 
and all relators involving just those generators hold. 
sum is equal to the sum of the lengths of the first
i-1 images (discounting images of reducible generators). */
      if (reduced0[i]==i)
        not_backtracking=TRUE; 
/*  We normally
backtrack one step at a time, but always continue a backtrack to pass 
unreduced generators */
      m = M - sum;
      j=i+1;
      if (simple_11test){
        while (j<=indep_gens){
          if (reduced0[j]==j)
            m--;
          j++;
        }
      }
      assert(m>=0);
      if (not_backtracking){
/* if the generators in the i-th pair aren't reduced, we simply set their
images to be the images of their reductions */
        if ((k=reduced0[i])!=i){
          int j;
          word_cpy(image+k,image+i);
          if (abtest)
            for (j=1;j<= freeabgens ;j++)
              imabF0[i][j] = imabF0[k][j];
        /* the abelian test can't possibly fail at this stage, but
we don't want to be missing the row of the imabF0 matrix */
        }
        else {
/* provided the generators in the i-th pair are reduced, we look for images
for them that fit all the tests we're currently applying. not_backtracking becomes false
if we can't find any images */
          not_backtracking=next_accepted_word(1,image+i,States[i],m);
/* image[i] would now be the identity if States[i][0] had previously been
undefined */
          if (not_backtracking==TRUE &&
              (simple_11test||abtest||cconjtest||permtest)){
            do {
              repeat = FALSE;
              if (i==indep_gens)
                while (not_backtracking && 
                    sum + word_length(image+i) < M)
                  not_backtracking=
          next_accepted_word(1,image+i,States[i],m);
              if (not_backtracking==TRUE && (simple_11test)){
                for (j=0;j<i;j++){
                  while ((word_sgn(image+j,image+i)==0 ||
              word_eqinv(image+j,image+i)==TRUE) &&
      (not_backtracking=next_accepted_word(1,image+i,States[i],m)))
                    j = 0;
                  if (not_backtracking==FALSE)
                    break;
                }
              }
              if (not_backtracking==TRUE && (cconjtest) && i==1)
                if (first_accepted_cconj(image+1)==FALSE && 
  (not_backtracking=next_accepted_word(1,image+1,States[i],m))==TRUE){
                  repeat = TRUE;
                  continue;
              }
              if (not_backtracking==TRUE && (abtest))
                if (ab_images_check(i)==FALSE && 
  (not_backtracking=next_accepted_word(1,image+i,States[i],m))==TRUE){
                  repeat = TRUE;
                  continue;
              }
              if (not_backtracking==TRUE && permtest)
                if (perm_images_check(i)==FALSE && 
  (not_backtracking=next_accepted_word(1,image+i,States[i],m))==TRUE){
                  repeat = TRUE;
                  continue;
              }
            } while (repeat);
          }
        }
      }
      if (not_backtracking){
        if (reduced0[i]==i)
          sum += word_length(image+i);
/*  now sum is equal to the sum of the lengths of the first i images */
        break;
      }
      else {
        i--;
        if (reduced0[i]==i)
          sum -= word_length(image+i);
/* so now sum is equal to the sum of the lengths of the first i-1 images,
ready for the next run through the loop */
      }
    }
    if (i==0){
      ans=FALSE;
      break;
    }
    else {
      /* the array image contains a sequence  of i accepted words;
we'll try these as our images */
      success=TRUE;
      assert(sum<=M);
      if (i==indep_gens && 
          (sum!=M||((simple_ontotest)&&all_gens_check()==FALSE)))    
        success=FALSE;
      else {
        for (j=relinvolve[i-1]+1;j<=relinvolve[i];j++){
          find_image(rels[0]+j,&w);
          wa_reduction(WA[1],rules[1],&w);
          if (word_length(&w)!=0){
            success=FALSE;
            word_reset(&w);
            break;
          }
          word_reset(&w);
        }
      }
    }
    if (ans==FALSE)
      break;
    else if (success){
      if (i==indep_gens){
        ans=TRUE;
        break;
      }
      else {
        i++;
        assert(i<=indep_gens);
      }
    }
    else { /* try for another image for generator in pair i */
      if (reduced0[i]==i)
        sum -= word_length(image+i);
/* now the sum is equal to the sum of the lengths of the first i-1 (relevant)
images ready for the next run through the loop */
    }
  } 
  word_clear(&w);
  word_clear(&rel);
  first_pass = FALSE;
  return ans;
}

static void
complete_homo()
{
  boolean ans=TRUE;
  int i;
  word w;
  word inverse;
  gen g;
  word_longinit(&w,max_rel[0]);
  inv_of = Inv_of[1];
  for (i=indep_gens+1;i<=paired_gens;i++){
    if (relinvolve[i]== -num_rels[0]-1)
      continue;
    word_reset(image+i);
    word_cpy(rels[0]+(-relinvolve[i]),&w);
    word_del_last(&w);  
    while (word_delget_first(&w,&g)){
      if (g<=Inv_of[0][g])
        word_append(image+i,image+pairnumber[g]);
      else  
        word_invappend(image+i,image+pairnumber[g]);
    }
    wa_reduction(WA[1],rules[1],image+i);
    word_reset(&w);
  }
  word_clear(&w);
}

static void
find_image(w1p,w2p)
  word * w1p;
  word * w2p;
{
  word temp;
  gen g;
  word_traverser wt;
  word_traverser_init(&wt,w1p);
  word_init(&temp);
  inv_of = Inv_of[1];
  
  while (word_next(&wt,&g)){  
    if (g<=(Inv_of[0])[g])
      word_append(w2p,image + pairnumber[g]);
    else 
      word_invappend(w2p,image + pairnumber[g]);
  }
  word_traverser_clear(&wt);
  word_clear(&temp);
}

static boolean 
all_gens_check()
{
  boolean ans=TRUE;
  word_traverser wt;
  int i;
  gen g;
  for (g=1;g<=Num_gens[1];g++)
    if (reduced1[g]==g)
      seen[g]=FALSE;
    else
      seen[g]=TRUE;
  for (i=1;i<=indep_gens;i++){
    word_traverser_init(&wt,image+i);
    while (word_next(&wt,&g))
      seen[g]=seen[Inv_of[1][g]]=TRUE;
    word_traverser_clear(&wt);
  }
  for (g=1;g<=Num_gens[1];g++)  
    if (seen[g]==FALSE){
      ans=FALSE;
      break;
    }
  return ans;
}

static boolean 
onto_check()
{
  boolean ans=TRUE;
  gen g;
  int m;
  word w1;
  word w2;
  int i;
  int starttime;
  word_init(&w1);
  word_init(&w2);
  for (i=1;i<=Num_gens[1];i++)
    word_reset(inverse_image+i);
  if (ontolimit){
    times(&buffer);
    starttime = (buffer.tms_utime)/60; 
  }
  for (m=1;m<=maxlength;m++){
    if (ontolimit){
      times(&buffer);
      ontotime = (buffer.tms_utime)/60 - starttime; 
      if (ontotime > maxontotime){
        fprintf(wfile,
          "\t# onto_check limit of %d secs exceeded.\n",maxontotime);
        fprintf(wfile,
          "\t# Exiting loop after checking to length %d.\n",m - 1);
        break;
      }
    }
    while (next_accepted_word(0,&w1,invstates,m)){
      find_image(&w1,&w2);
      wa_reduction(WA[1],rules[1],&w2);
      if (word_length(&w2)==1){
        word_get_last(&w2,&g);
        if (word_length(inverse_image+g)==0){
          word_cpy(&w1,inverse_image+g);
          inv_of=Inv_of[0]; 
        /* this is to make word_inv work OK */
          if (Inv_of[1][g]!=g)
         	 word_inv(inverse_image+g,inverse_image+Inv_of[1][g]);
        }
      }
      else if (word_length(&w2)==0 && word_length(&w1)>0){
        if (verbose){
          fprintf(wfile,"\t# Non-trivial kernel contains ");
          retrieve_gen_info(0);
          word_print(wfile,&w1);
          retrieve_gen_info(1);
          fprintf(wfile,"\n");
        }
        if (simple_11test){
          word_clear(&w1);
          word_clear(&w2);
          return FALSE;
        }
      }
      word_reset(&w2);
    }
    if (max_len[0]<m){ /* that means there are no accepted words of
length m. So we might as well save time in future by resetting maxlength */
      fprintf(wfile,
        "No words in first group of length > %d.\n",max_len[0]);
      maxlength = max_len[0];
    }
    ans=TRUE;
    for (g=1;g<=Num_gens[1];g++){  
      gen h;
      if ((h=reduced1[g])==g){
        if (word_length(inverse_image+g)==0){
          ans=FALSE;
          if (m == maxlength && (mode==HOMO || verbose)){
    fprintf(wfile,"\t# No inverse image found for generator ");
            gen_print(wfile,g);
fprintf(wfile,", for example.\n\t# The map might not be an epimorphism.\n");
          }
          break;
        }
      }
      else
        word_cpy(inverse_image+h,inverse_image+g);
    }
    if (ans==TRUE)
      break; /* no need to look any further */
  }
  word_clear(&w1);
  word_clear(&w2);
  return ans;
}
      
static boolean 
reverse_homo_check()
{
  boolean ans=TRUE;
  int i;
  word w;
  word_traverser wt;
  gen g;
  word_init(&w);
  for (i=1;i<=num_rels[1];i++){
    word_traverser_init(&wt,rels[1]+i);
    while (word_next(&wt,&g))
      word_append(&w,inverse_image+g);
    word_traverser_clear(&wt);
    wa_reduction(WA[0],rules[0],&w);
    if (word_length(&w)!=0){
      ans=FALSE;
      break;
    }
    word_reset(&w);
  }
  word_clear(&w);
  return ans;
}



static boolean 
gen_images_check()
{
  boolean ans=TRUE;
  int i;
  word w;
  word_traverser wt;
  gen g;
  word_init(&w);
  for (i=1;i<=paired_gens;i++){
    if (reduced0[i]!=i)
      continue;
    word_traverser_init(&wt,image+i);
    while (word_next(&wt,&g))
      word_append(&w,inverse_image+g);
    word_traverser_clear(&wt);
    wa_reduction(WA[0],rules[0],&w);
    if (word_length(&w)!=1){
      ans=FALSE;
      break;
    }
    else {
      word_get_last(&w,&g);
      if (g>Inv_of[0][g] || pairnumber[g]!=i){
        ans=FALSE;
        break;
      }
    }
    word_reset(&w);
  }
  word_clear(&w);
  return ans;
} 

static boolean
ab_images_check(i)
  gen i;
{
  boolean ans = TRUE;
  int j;
  word_traverser wt;
  gen g;
  word_traverser_init(&wt,image+i);
  for (j=1;j<=freeabgens;j++)
    imabF0[i][j] = 0;
  while (word_next(&wt,&g)){
    for (j=1;j<=freeabgens;j++)
      imabF0[i][j] += abF1[g][j];  
  }
  word_traverser_clear(&wt);
  reorganise(i);
  for (j=1;j<=freeabgens;j++){
    if (imabF0[i][j]!=abF0[i][j]){
      ans = FALSE;
      break;
    }
  }
  return ans;
}


static void
lowtri_abF0()
{
  int r = paired_gens;
  int diag=0;
  int i,j,k,temp;
  while (diag<freeabgens && r>0){
    int smallest=0;
    boolean repeat = FALSE;
/* find the smallest entry in the current row to the right of the diagonal */
    for (j=diag+1;j<=freeabgens;j++){
      int x = abF0[1][j];
      if (x>0 && (x<smallest || smallest==0)){
        smallest = x;
        k = j;
      }
      else if (x<0 && (-x < smallest || smallest ==0)){
        smallest = -x;
        k = j;
      }
    }
    if (smallest==0){
/*  There are only zeroes to the right of the diagonal in this row. Move down 
  to the next row */
      abF0++;
      r--;
    }
    else {
  /* multiply by -1 if necessary to make the smallest entry positive */
      if (abF0[1][k]<0){
        for (i=1;i<=r;i++)
          abF0[i][k] *= -1;
      }
  /* subtract multrfileles of this selected  column from all columns to the 
left of it. This should result in entries >=0 everywhere earlier in the
row */
      for (j=1;j<=freeabgens;j++){
        int lambda;
        if (j!=k){
          if (abF0[1][j]>=0)
            lambda = -((abF0[1][j])/(abF0[1][k]));  
          else
              lambda = (-abF0[1][j] + abF0[1][k] - 1)/(abF0[1][k]);
          for (i=1;i<=r;i++)
            abF0[i][j] += lambda* abF0[i][k];
          if (j>diag && abF0[1][j]!=0)
            repeat = TRUE;
        }
      }
      if (repeat==FALSE){
  /*   move column k as far left as possible */
        for (i=1;i<=r;i++){
          temp = abF0[i][diag+1];
          abF0[i][diag+1] = abF0[i][k];
          abF0[i][k] = temp;
        }
        diag++;
        r--;
        abF0++;
      }
    }
  }    
  abF0 -= paired_gens - r;
}

static void
reorganise(m)
  int m;
{
  int diag=0;
  int i,j,k,temp;
  int smallest;
  boolean repeat;
  boolean founddiag = FALSE;
  /* find the diagonal */
  if (m>1)
  for (j=freeabgens;j>=1;j--){
    for (k=1;k<m;k++){
      if (imabF0[k][j]!=0){
        diag = j;
        founddiag = TRUE;
        break;
      }
    }
    if (founddiag) break;
  }
/* find the smallest entry in the m-th row to the right of the diagonal */
  do {
    repeat = FALSE;
    smallest = 0;
    for (j=diag+1;j<=freeabgens;j++){
      int x = imabF0[m][j];
      if (x>0 && (x<smallest || smallest==0)){
        smallest = x;
        k = j;
        if (smallest==1) break;
      }
      else if (x<0 && (-x < smallest || smallest ==0)){
        smallest = -x;
        k = j;
        if (smallest==1) break;
      }
    }
    if (smallest==0)
      return;
  /* multiply by -1 if necessary to make the smallest entry positive */
    if (imabF0[m][k]<0){
      if (m < indep_gens)
      for (i=1;i<=Num_gens[1];i++)
        abF1[i][k] *= -1;
      imabF0[m][k] *= -1;
    }
/* subtract multiples of this selected  column from all other columns 
to give positive entries less in absolute value than everywhere else 
in the row */
    for (j=1;j<=freeabgens;j++){
      int lambda;
      if (j!=k){
        if (imabF0[m][j]>=0)
          lambda = -((imabF0[m][j])/(imabF0[m][k]));  
        else
          lambda = (-imabF0[m][j] + imabF0[m][k] - 1)/(imabF0[m][k]);
        if (lambda) {
          imabF0[m][j] += lambda* imabF0[m][k];
          if (m < indep_gens)
          for (i=1;i<=Num_gens[1];i++)
            abF1[i][j] += lambda* abF1[i][k];
        }
        if (j>diag && imabF0[m][j]!=0)
          repeat = TRUE;
      }
    }
  } while (repeat);
/* move column k as far left as possible */
  temp = imabF0[m][diag+1];
  imabF0[m][diag+1] = imabF0[m][k];
  imabF0[m][k] = temp;
  if (m < indep_gens)
  for (i=1;i<=Num_gens[1];i++){
    temp = abF1[i][diag+1];
    abF1[i][diag+1] = abF1[i][k];
    abF1[i][k] = temp;
  }
}

static boolean 
perm_images_check(i)
  int i;
{
  boolean ans = FALSE;
  int j,k;
  word_traverser wt;
  gen g;
  boolean * poss = poss_cycletype[i];
  boolean * last_poss = poss_cycletype[i-1];
  for (k=1;k<=num_cycletypes;k++)
    poss[k] = last_poss[k];
  for (j=1;j<=permdegree;j++){
    imperm[j] = j;
    imcyclecount[j]=0;
  }
  word_traverser_init(&wt,image+i);
  while (word_next(&wt,&g)){
    for (j=1;j<=permdegree;j++)
      imperm[j] = permrep1[g][imperm[j]];  
  }
  word_traverser_clear(&wt);
  for (j=1;j<=permdegree;j++){
    int cyclelength=1;
    k=j;
    while (imperm[k]!=j){
      k=imperm[k];
      cyclelength++;
    } 
    imcyclecount[cyclelength]++;
  }
  
  for (k=1;k<=num_cycletypes;k++){
    if (poss[k]){
      for (j=1;j<=permdegree;j++){
        if (imcyclecount[j]!=cyclecounts[k][i][j]){
          poss[k] = FALSE;
          break;
        }
      }
      if (poss[k]==TRUE){
        ans = TRUE;
      }
    }
  }
return ans;
}

static boolean 
first_accepted_cconj(wp)
  word * wp;
{
  boolean ans=TRUE;
  int n=word_length(wp);
  int i,j;
  gen g;
  word temp;
  word_traverser wt;
  int ** array=WA[1]->array;
  word_longinit(&temp,2*n);
  word_creduce(wp,&temp);  
  for (i=1;i<=n;i++){
    word_delget_first(&temp,&g);
    word_put_last(&temp,g);
    if (word_sgn(&temp,wp)==1){
      word_traverser_init(&wt,&temp);
      j=1;
      while (word_next(&wt,&g)){
      if ((j=array[g][j])<=0)
        break;
      }
      word_traverser_clear(&wt);
      if (j>0)
        ans = FALSE;
    }
    if (ans==FALSE)
      break;
        
  }
  word_clear(&temp);
  return ans;
}

badusage(){
            fprintf(stderr,"Usage: findisoms [-a] [-c] [-e] \
 [-h] [-i] [-l int] [-m int] [-tt int] [-ot int] [-p permgpname] \
[-s] [-v] gpname1 gpname2 \n");
        exit(2);
     }     
