/* automata.d/src file screengraphics.c */
#include "defs.h"
#include <cgidefs.h>
#define DEVNUM 1
#define MP1 2
#define MP2 3
#define MP3 4

int blackscreen;
int whiteindex;
int blackindex; 
Cint name;
Cvwsurf device;
Cinrep sample;
Ccoor samp;
Ccoor bottomleft;
Ccoor topright;
Pixrect * pr_open();
static int screen_type();

static int screen_type()
{
	Pixrect * screen;
	int incolour;
	screen=pr_open("/dev/fb");
	incolour=(screen->pr_depth)>1;
	pr_close(screen);
	return incolour;
}

void screengraphics_screen_init(blackscreen,x1,y1,x2,y2)
	int blackscreen,x1,y1,x2,y2;
{
	int incolour = screen_type();

	if (incolour) { 
		NORMAL_VWSURF(device,CGPIXWINDD);
	}
	else {
		NORMAL_VWSURF(device,PIXWINDD);
	}
	open_cgi();
	open_vws(&name,&device);

	NORMAL_VWSURF(device,CGPIXWINDD);
	if (incolour) {
		Ccentry colourlist;
		unsigned char ucr=255;
		unsigned char ucb=255;
		unsigned char ucg=255;
		colourlist.ra = &ucr;
		colourlist.ga = &ucg;
		colourlist.ba = &ucb;
		colourlist.n=1;
		if (blackscreen) {
			whiteindex = 7;
			blackindex = 0;
		}
		else {
			whiteindex = 0;
			blackindex = 7;	
		}
		color_table(whiteindex,&colourlist);
			/* mixing white from  red, blue and green */
		ucb=0;
		ucr=ucg=255;
		color_table(2,&colourlist);
			/* mixing yellow from red and green */
		ucb=255;
		ucr=0;
		color_table(4,&colourlist);
		/* mixing cyan from blue and green */
		ucr=255;
		ucg=0;
		color_table(6,&colourlist);
		/* mixing magenta from red and blue */
	}
	bottomleft.x = x1;
	bottomleft.y = y1;
	topright.x = x2;
	topright.y = y2;
	vdc_extent(&bottomleft,&topright);

	text_precision(STROKE);
	text_alignment(CNTER,HALF,0.0,0.0);
}

void screengraphics_screen_reset(x1,y1,x2,y2)
	int x1,y1,x2,y2;
{
	clear_view_surface(name,OFF,0);

	bottomleft.x = x1;
	bottomleft.y = y1;
	topright.x = x2;
	topright.y = y2;
	vdc_extent(&bottomleft,&topright);
}

void screengraphics_screen_clear()
{
	close_vws(name);
	close_cgi();
}

int screengraphics_screen_reconfigured()
{
	return 0;
}

void
screengraphics_circle(x,y,radius,colour)
	int x,y,radius,colour;
{
	Ccoor centre;
	centre.x = x;
	centre.y = y;
	perimeter_color(colour);
	circle(&centre,radius);
}

void
screengraphics_text(x,y,string,a,b,c,d,size,colour)
	int x,y;
	char * string;
	double a,b,c,d;
	int size;
	int colour;
{
	Ccoor marker;
	marker.x = x;
	marker.y = y;
	character_orientation(a,b,c,d);
	character_height(size);
	text_color(colour);
	text(&marker,(Cchar *)string);
}

void
screengraphics_line(x1,y1,x2,y2,colour)
	int x1,y1,x2,y2;
	int colour;
{
	Ccoorlist edge;
	Ccoor vpair[2];
	edge.ptlist = vpair;
	edge.n = 2;
	vpair[0].x = x1;
	vpair[0].y = y1;
	vpair[1].x = x2;
	vpair[1].y = y2;
	line_color(colour);	
	polyline(&edge);
}

void
screengraphics_rectangle(x1,y1,x2,y2,colour)
	int x1,y1,x2,y2,colour;
{
	Ccoorlist perimeter;
	Ccoor vpair[5];
	perimeter.ptlist = vpair;
	perimeter.n = 5;
	vpair[0].x = x1;
	vpair[0].y = y1;
	vpair[1].x = x2;
	vpair[1].y = y1;
	vpair[2].x = x2;
	vpair[2].y = y2;
	vpair[3].x = x1;
	vpair[3].y = y2;
	vpair[4].x = x1;
	vpair[4].y = y1;
	line_color(colour);	
	polyline(&perimeter);
}

void
screengraphics_clear_outside_rectangle(x1,y1,x2,y2)
	int x1,y1,x2,y2;
{
	Ccoor rb;
	Ccoor lt;
	interior_style(SOLIDI,OFF);
	fill_color(0);
	rb.x = x1;
	rb.y = bottomleft.y;
	lt.x = bottomleft.x;
	lt.y = topright.y;
	rectangle(&rb,&lt);
	rb.x = topright.x;
	rb.y = bottomleft.y;
	lt.x = x2;
	lt.y = topright.y;
	rectangle(&rb,&lt);
	rb.x = x2;
	rb.y = bottomleft.y;
	lt.x = x1;
	lt.y = y1;
	rectangle(&rb,&lt);
	rb.x = x2;
	rb.y = y2;
	lt.x = x1;
	lt.y = topright.y;
	rectangle(&rb,&lt);
	interior_style(HOLLOW,ON);
 
	
/*
	int xx1 = (int)((x1 - left) * pixelscale);
	int yy1 = (int)((top- y1) * pixelscale);
	int xx2 = (int)((x2 - left) * pixelscale);
	int yy2 = (int)((top- y2) * pixelscale);
	XSetForeground(display, gc, (unsigned long)0);
	XFillRectangle(display, window, gc,0, 0, xx1, window_height);
	XFillRectangle(display, window, gc,xx2, 0, window_width, window_height);
	XFillRectangle(display, window, gc,xx1, 0, xx2, yy1);
	XFillRectangle(display, window, gc,xx1, yy2, xx2, window_height);
	XFlush(display);
*/
}
void
screengraphics_mouse_init()
{
	sample.xypt = &samp;
	samp.x=0;
	samp.y=0;
	initialize_lid(IC_LOCATOR,DEVNUM,&sample);
	associate(MP1,IC_LOCATOR,DEVNUM);
	associate(MP2,IC_LOCATOR,DEVNUM);
	associate(MP3,IC_LOCATOR,DEVNUM);
}

void
screengraphics_mouse_locate(xp,yp,bp)
	int * xp;
	int * yp;
	int * bp;
{
	Cawresult stat;
	Cint trigger;

	request_input(IC_LOCATOR,DEVNUM,-1,&stat,&sample,&trigger);
	*bp=trigger-1;
	*xp=sample.xypt->x;
	*yp=sample.xypt->y;
}

void
screengraphics_mouse_clear()
{
	dissociate(MP1,IC_LOCATOR,DEVNUM);
	dissociate(MP2,IC_LOCATOR,DEVNUM);
	dissociate(MP3,IC_LOCATOR,DEVNUM);
	release_input_device(IC_LOCATOR,DEVNUM);
} 
