/* automata.d/src file procrels.c */ 
#include <stdio.h>
# include <ctype.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "input.h"
# define PROCRELSOP ".procrels"
FILE * rfile=stdin;
FILE * wfile=stdout;
list rels;
extern word * user_gen_name;
extern gen * inv_of;
extern int gen_array_size;	
extern int num_gens;
boolean subst_option=FALSE;
boolean tri_option=FALSE;
int new_gens=0;
gen * rewrite=0;
gen * renumber=0;
static void process_rels PARMS((VOID));
static int find_substitutions PARMS((VOID));
static void rewrite_rule_for PARMS((gen x,gen y,gen A[]));
static void display_redundant_gens PARMS((VOID));
static void revise_dictionary PARMS((VOID));
static boolean reduce_num_gens PARMS ((VOID));
static void make_substitutions PARMS((VOID));
static void creduce_rels PARMS ((VOID));
static boolean substitute_strings PARMS((VOID));
static void create_new_gens PARMS((word* wp,word* invp,gen* xp,gen* Xp));
static boolean triangulate PARMS((VOID));
static int longest_repeated_string PARMS((word * wp, int limit));
static boolean substitution_gives_short_rels
				PARMS((word *wp,word *invp,int n,gen x,gen X));

main(argc,argv)
	int argc;
	char * argv[];
{
	int i;
	word rel;
	char * label;
	int n;
	boolean commandline_parameters=FALSE;
	int max_archive_size=0;

	char gpname[100];
	char filename[100];
	assert(INVALID_GEN==0); 
/* initially we need the entries of |user_gen_name| and |inv_of| to be equal 
to |INVALID_GEN|, so it's important that that is equal to zero */

	i=1;
    while (i<argc && argv[i][0]=='-'){
		if (strcmp(argv[i],"-s")==0)
			subst_option=TRUE;
		else if (strcmp(argv[i],"-t")==0)
			tri_option=TRUE;
		else if (argv[i][1]=='k' || argv[i][1]=='K'){
			int j=0;
			commandline_parameters=TRUE;
			i++;
			if (i==argc){
				fprintf(stderr,
					"Usage: procrels [-s] [-t] [-k posint] [gpname]\n");
				exit(2);
			}
			max_archive_size=0;
			while (argv[i][j]!='\0') {
				if (!isdigit(argv[i][j])){
					fprintf(stderr,
						"Usage: procrels [-s] [-t] [-k posint] [gpname]\n");
					exit(2);
				}
				max_archive_size = 10*max_archive_size + argv[i][j]-'0';
				j++;
			}
		}
		else {
			fprintf(stderr,"Usage: procrels [-s] [-t] [-k posint] [gpname]\n");
			exit(2);
		}
		i++;
	}
	if (i<argc-1){
		fprintf(stderr,"Usage: procrels [-s] [-t] [-k posint] [gpname]\n");
		exit(2);
	}
	else if (i==argc-1){
/* the input and output files are being specified as gpname and gpname.procrels
*/
		strcpy(gpname,argv[argc -1]);
		strcpy(filename,gpname);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		strcat(filename,PROCRELSOP);
		wfile=fopen(filename,"w");
	}

	setbuf(stdout,(char*)0);
	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);
	list_init(&rels,WORD,ORDERED);
	label=vzalloc2(char,9);

	while (read_next_string(label,8,rfile)){
		if (strcmp(label,"Format  ")==0)
			format_echocheck("2.2",rfile,wfile);
		else if (strcmp(label,"gens    ")==0 || strcmp(label,"words   ")==0)
			/* The order of the generators is being specified */
			read_gen_name_array(rfile);
		else if (strcmp(label,"inverses")==0)
			read_inverse_array(rfile);
		else if (strcmp(label,"rels    ")==0){
			if (inv_of==0)
				default_inverse_array();
			while (getc(rfile)!='\{')
				;
			word_init(&rel);
			while (read_next_rel(&rel,rfile)){
				list_insert(&rels,(dp)&rel);
				word_reset(&rel);
			}
			word_clear(&rel);
			while (getc(rfile)!='\}')
				;
			
			process_rels();

			fprintf(wfile,"gens \{ ");
			for (i=1;i<=num_gens;i++){
				gen_print(wfile,i);
				fprintf(wfile," ");
			}
			fprintf(wfile,"\}\n");
			fprintf(wfile,"inverses \{\n");
			for (i=1;i<=num_gens;i++){
				fprintf(wfile,"inv(");
				gen_print(wfile,i);
				fprintf(wfile,")=");
				gen_print(wfile,inv(i));
				fprintf(wfile," ");
			}
			fprintf(wfile,"\n\}\n");
			fprintf(wfile,"rels \{\n");
			list_print(wfile,&rels);
			fprintf(wfile,"\}\n");
			list_clear(&rels);
		}
		else if (commandline_parameters==FALSE && strcmp(label,"paramete")==0){
	/* we might want to put the parameters for diff1 at the end of this file
in case we want to run the sequence of programs. In that case, the parameters
should simply be copied into the output file, which will be used as input for
diff1. */
			while (getc(rfile)!= '\{')
				;
			fprintf(wfile,"parameters \{\n");
			while (read_next_string(label,8,rfile)){
				if (strcmp(label,"KBtreesi")==0 ||
							strcmp(label,"kbtreeesi")==0){
					read_next_int(&n,rfile);
					fprintf(wfile,"KBtreesize %d\n",n);
				}
			}
			while (getc(rfile)!= '\}')
				;
			fprintf(wfile,"\}\n");
		}
	}
	if (commandline_parameters){
		fprintf(wfile,"parameters \{\n");
		fprintf(wfile,"KBtreesize %d\n",max_archive_size);
		fprintf(wfile,"\}\n");
	}
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name);
	user_gen_name=0;
	Free_dp((dp)inv_of);
	inv_of=0;
	Free_dp((dp)label); label=0;
	assert(store_ptrs==0);
	exit(0);
}






static void 
process_rels()
{
	renumber=vzalloc2(gen,gen_array_size);
    rewrite=vzalloc2(gen,gen_array_size);
    do {
        creduce_rels();
        if (num_gens==0)
            break;
    } while (reduce_num_gens()==TRUE
			||substitute_strings()==FALSE||triangulate()==FALSE);
    Free_dp((dp)renumber); renumber=0;
    Free_dp((dp)rewrite); rewrite=0;
}

static boolean
reduce_num_gens()
{
	boolean ans=FALSE;
  int subst=0; 
  do { 
     gen g;  
 
     for (g=0;g<=gen_array_size-1;++g) { 
      	  if (1<=g && g<=num_gens) renumber[g] = g; 
          else renumber[g] = INVALID_GEN; 
     } 
     for (g=0;g<=gen_array_size-1;++g) { 
      	  if (1<=g && g<=num_gens) rewrite[g] = g; 
          else rewrite[g] = INVALID_GEN; 
     } 

	if (subst=find_substitutions() != 0) {
		display_redundant_gens();
		revise_dictionary();
		make_substitutions();
		ans = TRUE;
	}
  } while (subst==1); 
	/* that means that some generator has been found to be trivial */
	return ans;
}

/*
We search through all relators of length 1 or 2 for rewrite rules,
collected in the array |rewrite|. Once we have a collection of rules we find
their transitive closure.
The function returns an integer, equal to 0 if no substitutions have been
found, to 1 if a single generator has been found to be trivial, and to 2 if
no trivial generators have been found but two previously distinct generators
have been found to be equal.

Warning:
  We assume that the list of relators is ordered at least by length of
words, i.e that shorter words come first.
*/

static int
find_substitutions()
{
	int ans = 0;
  word rel; 
		gen g,h;

  word_init(&rel); 
	while (list_delget_first(&rels,(dp)&rel)) {
		int length;
		length = word_length(&rel);
		if (length > 2){
			(void)list_insert(&rels,(dp)&rel);
			break;
	}
		else {
			(void)word_delget_first(&rel,&g);
			if (length == 1) {
				ans = 1;
         		rewrite_rule_for(g,IDENTITY,rewrite); 
         		rewrite_rule_for(inv_of[g],IDENTITY,rewrite);  
			}
			else /* length 2 */ {
				(void)word_delget_first(&rel,&h);	
				if (h != inv_of[g]){
          			rewrite_rule_for(g,inv_of[h],rewrite); 
         			rewrite_rule_for(inv_of[g],h,rewrite); 
					if (ans == 0)
						ans = 2;
				}
			}
    }
  } 
/* Now we find the transitive closure of the rewrite rules */ 
    for (g = 1; g <= num_gens; ++g)  
         while ((h = rewrite[g]) != g && h != IDENTITY && rewrite[h] != h)  
                                       rewrite[g] = rewrite[h]; 
  word_clear(&rel); 
	return ans;
} 
 



/*
Aim: The function |rewrite_rule_for()| deduces a new rewrite rule, where one 
exists, from the identity |x = y| (where each of |x,y| is either a generator or 
the identity) and amends the array where rewrite rules are
stored (here called |A[]|), accordingly. 
  First each of |x,y| is rewritten as far as possible using existing
rules. The resultant values are compared. If they're equal there's no new
rewrite rule. Otherwise, where |s| is the larger of the two and |t| the smaller
(we consider the |IDENTITY| to be smaller than any generator), we now have the 
new rule that |s| can be rewritten as |t|. So we redefine |A[s]| to be 
|t|.
*/
static void rewrite_rule_for(x,y,A) 
gen x,y; 
gen A[]; 

{
  while (x != IDENTITY && x != rewrite[x]) x = rewrite[x]; 
  /* this rewrites |x| as far as possible */ 
  while (y != IDENTITY && y != rewrite[y]) y = rewrite[y]; 
  /* this rewrites |y| */

  if (y == x) return; 
  else { 
    if (x == IDENTITY) A[y] = x; 
    else if (y == IDENTITY || y < x) A[x] = y;  
    else A[y] = x; 
    return; 
  } 

} 

 





static void
display_redundant_gens()
{     
  gen g; 

  for (g=1; g<=num_gens; ++g)   
   	 if (rewrite[g] != g) { 
		fprintf(wfile,"\t# The generator ");
		gen_print(wfile,g);
		fprintf(wfile," is equal to ");
		gen_print(wfile,rewrite[g]);
		fprintf(wfile,".\n");
	  }  
} 

static void
revise_dictionary()
{ 
  gen g; 
  int redundancies = 0; 

	/* Rewrite inverse array entries and mark redundant generators */

  for(g = 1; g <= num_gens; ++g) {
       inv_of[g] = rewrite[inv_of[g]]; 
       if (rewrite[g] != g)  
         word_reset(user_gen_name+g); 
  }

	/* Throw away redundant generators and close up gaps in the arrays */

  for(g = 1; g <= num_gens - redundancies; ++g) { 
        int i=0;
		int j=0;
        while (g+i<=num_gens-redundancies&&word_length(user_gen_name+g+i)==0) 
             i++;
        if (i) { 
             redundancies += i;
             for(j = g; j <= num_gens; j++) { 
               if (j <= num_gens - redundancies) { 
                   word_cpy(user_gen_name+j+i,user_gen_name+j); 
                   inv_of[j] = inv_of[j+i]; 
               } 
               else { 
                   word_reset(user_gen_name+j); 
                   inv_of[j] = INVALID_GEN; 
               } 
               if (j >=g + redundancies - i && j < g+redundancies) 
                   renumber[j] = INVALID_GEN; 
               else if (j >= g + redundancies)
                   renumber[j] -= i; 
             } 
        } 
  } 
  num_gens -= redundancies; 
  for(g=1;g<=num_gens;g++)
    inv_of[g] = renumber[inv_of[g]]; 
} 


static void
make_substitutions()
{  
  word rel, new_rel;  
  gen g,h;  
  list new_rels; 

  list_init(&new_rels,WORD,ORDERED); 
  word_init(&rel); 
  word_init(&new_rel); 

  while (list_delget_first(&rels,(dp)&rel)) { 
     while (word_delget_first(&rel,&g))  
         if ((h = rewrite[g]) != IDENTITY) 
              word_put_last(&new_rel,renumber[h]); 
     if (word_length(&new_rel) != 0) 
	 	(void)list_insert(&new_rels,(dp)&new_rel); 
     word_reset(&rel); 
     word_reset(&new_rel); 
  }  
  list_cpy(&new_rels,&rels); 
  word_clear( &new_rel); 
  word_clear(&rel); 
  list_clear(&new_rels); 
} 



/* Relators are cyclically reduced.  */
static void
creduce_rels()
{  
  word rel, new_rel;  
  list new_rels; 

  list_init(&new_rels,WORD,ORDERED); 
  word_init(&rel); 
  word_init(&new_rel); 

  while (list_delget_first(&rels,(dp)&rel)){ 
     	(void)word_creduce(&rel,&new_rel); 
     	if (word_length(&new_rel) != 0)  {  
		(void)list_insert(&new_rels,(dp)&new_rel); 
        word_reset(&new_rel); 
     } 
     else (void)list_insert(&new_rels,(dp)&rel); 
     word_reset(&rel); 
  }  
  list_cpy(&new_rels,&rels); 
  word_clear( &new_rel); 
  word_clear(&rel); 
  list_clear(&new_rels); 
} 

/*If the string substitution option has been requested
strings of length 2 or more that appear more than once in the relators are
replaced by new generators. (Occurrences of the inverse of a string are also
counted.) The process stops if a relator of length 1 or 2 appears out of
this process or when no string appears more than once. Returns |TRUE| in the
latter case.
|TRUE| is also returned if this option was not selected.
*/
static boolean
substitute_strings()
{
	boolean ans = TRUE;
	if (subst_option) {
		int n;
		int limit=0;
		word w;
		word inverse;
		word_init(&w);
		word_init(&inverse);
		while ((n=longest_repeated_string(&w,limit))>1) {
			gen x,X;
			word_inv(&w,&inverse);
			create_new_gens(&w,&inverse,&x,&X);
			fprintf(wfile,"\t# \tNew generators ");
			gen_print(wfile,x);
			fprintf(wfile," and ");
			gen_print(wfile,X);
			fprintf(wfile,"\n\t# \twere substituted for ");
			word_print(wfile,&w);
			fprintf(wfile," and its inverse.\n");
			if (substitution_gives_short_rels(&w,&inverse,n,x,X)) {
				ans = FALSE;
				break;
			}
			word_reset(&w);
			word_reset(&inverse);
			limit=n;
		}
		word_clear(&w);
		word_clear(&inverse);
	}
	return ans;
}


static void
create_new_gens(wp,invp,xp,Xp)
	word *wp;
	word * invp;
	gen *xp;
	gen *Xp;
{
	int j,k;
	*xp = ++num_gens; 
	if (word_sgn(wp,invp)!=0) 
		*Xp = ++num_gens;
	else 
		*Xp = *xp;
	if (gen_array_size<num_gens+1) {
		int i;
		word * cpy1;
		gen * cpy2;
		cpy1 = vzalloc2(word,2*num_gens+1);
		for (i=0;i<2*num_gens+1;++i) 
			word_init(cpy1+i);
		cpy2 = vzalloc2(gen,2*num_gens+1);
		for (i=0;i<gen_array_size;++i) {
			word_cpy(user_gen_name+i,cpy1+i);
			cpy2[i] = inv_of[i];
		}
		gen_array_size = 2*num_gens + 1;
		Free_dp((dp)user_gen_name);
		user_gen_name=0;
		user_gen_name = cpy1;
		Free_dp((dp)inv_of);
		inv_of=0;
		inv_of = cpy2;
	}
	new_gens++;
	k=new_gens;
	do {
		j = k%10;
		word_put_first(user_gen_name + *xp,j + '0');
	} while ((k=(k - j)/10)>=1);
	word_put_first(user_gen_name + *xp,'g');
	word_put_first(user_gen_name + *xp,'w');
	word_put_first(user_gen_name + *xp,'e');
	word_put_first(user_gen_name + *xp,'n');
	inv_of[*xp] = *Xp;
	if (*xp != *Xp){
		new_gens++;
		k=new_gens;
		do {
			j = k%10;
			word_put_first(user_gen_name + *Xp,j + '0');
		} while ((k=(k - j)/10)>=1);
		word_put_first(user_gen_name + *Xp,'g');
		word_put_first(user_gen_name + *Xp,'w');
		word_put_first(user_gen_name + *Xp,'e');
		word_put_first(user_gen_name + *Xp,'n');
		inv_of[*Xp] = *xp;
	}
}

static void create_new_gens PARMS((word* wp,word* invp,gen* xp,gen* Xp));

/*
Cuts the relators up into triangles, by replacing at each stage the first
adjacent pair of generators in a relator of length 4 or more 
by a single new generator. Stops if a 
relator of length 1 or 2 appears out of this process or if all relators are
triangles. Returns |TRUE| in the latter case.
*/
static boolean
triangulate()
{
	boolean ans = TRUE;
	if (tri_option) {
		word rel;
		word w;
		word_init(&w);
		word_init(&rel);
		do {
			list_traverser trels;
			list_traverser_init(&trels,&rels);
			while(list_next(&trels,(dp)&rel)) {
				if (word_length(&rel) > 3) {
					gen g;
					(void)word_delget_first(&rel,&g);
					word_put_last(&w,g);
					(void)word_delget_first(&rel,&g);
					word_put_last(&w,g);
					break;
				}
				else
					word_reset(&rel);
			}
			list_traverser_clear(&trels);
			if (word_empty(&w)) 
				break;
			else {
				gen x,X;
				word inverse;
				word_init(&inverse);
				word_inv(&w,&inverse);
				create_new_gens(&w,&inverse,&x,&X);	
			if (substitution_gives_short_rels(&w,&inverse,2,x,X))
					ans = FALSE;
				else {
					word_reset(&w);
					word_reset(&rel);
				}
				word_clear(&inverse);
			}
		} while (ans == TRUE); 
		word_clear(&w);
		word_clear(&rel);
	}
	return ans; 
}


static int
longest_repeated_string(wp,limit)
	word * wp;
	int limit;
{
	list_traverser trels1;
	list_traverser trels2;
	word rel1;
	word rel2;
	int length=1;
	list_traverser_init(&trels1,&rels);
	word_init(&rel1);
	word_init(&rel2);
	while (list_next(&trels1,(dp)&rel1)){
		list_traverser_init(&trels2,&rels);
		while (list_next(&trels2,(dp)&rel2)) {
			int sgn;
			if ((sgn=word_sgn(&rel1,&rel2))<0)
				continue;
			else if (sgn==0) {
				crepeat_subword(&rel1,wp,&length,limit);
				cinv_repeat_subword(&rel1,wp,&length,limit);
			}
			else {
				word temp;
				cmatch_subword(&rel1,&rel2,wp,&length,limit);
				word_init(&temp);
				word_inv(&rel2,&temp);
				cmatch_subword(&rel1,&temp,wp,&length,limit);
				word_clear(&temp);
			}
			if (length==limit)
				break;
			word_reset(&rel2);
		}
		list_traverser_clear(&trels2);
		if (length==limit)
			break;
		word_reset(&rel1);
	}
	list_traverser_clear(&trels1);
	word_clear(&rel2);
	word_clear(&rel1);
	return length;
}

static int longest_repeated_string PARMS((word * wp, int limit));

static boolean
substitution_gives_short_rels(wp,invp,n,x,X)
	word * wp;
	word * invp;
	int n;
	gen x;
	gen X;
{
	boolean ans = FALSE;
	list new_rels;
	word rel;
	list_init(&new_rels,WORD,ORDERED);
	word_init(&rel);
	word_cpy(wp,&rel);
	word_put_last(&rel,X);
	(void)list_insert(&new_rels,(dp)&rel);
	word_reset(&rel);
	while(list_delget_first(&rels,(dp)&rel)){
		if (word_length(&rel)>=n)
			word_csubst(&rel,wp,x);
		if (word_length(&rel)>=n && x!=X)
			word_csubst(&rel,invp,X);
		if (word_length(&rel)<3)
			ans = TRUE;
		(void)list_insert(&new_rels,(dp)&rel);
		word_reset(&rel);
	}
	word_clear(&rel);
	list_cpy(&new_rels,&rels);
	list_clear(&new_rels);
	return ans;
}
			
				 	
static boolean substitution_gives_short_rels
			PARMS((word *wp,word *invp,int n,gen x,gen X));
