/* automata.d/src file graphics.c */
#include <stdio.h>
#include <math.h>
#include "defs.h"
#include "screengraphics.h"
#include "list.h"
#include "word.h"
#include "lg.h"
#include "graphics.h"

#define PAGEHT 540.0
#define PAGEWD 792.0
double scale;
int incolour=FALSE;
int blackscreen;
extern boolean two_var;
extern int rmax;
extern int depth;
extern int lprad;
extern int ptrad;
extern int charht;
extern int pointcolour;
extern int edgecolour;
extern int labelcolour;
static void screen_direct_edge PARMS((int pointx,pointy,double a,double b));
static void screen_label_edge PARMS((int markerx, int markery,gen g,double a,double b));
static void 
ps_direct_edge PARMS ((double pointx,double pointy,double a,double b,
			FILE * file));
static void 
ps_label_edge PARMS ((double markerx,double markery,gen g,double a,double b,
                         boolean loop, FILE * file));

void
screen_plot(x,y,cat,label,lambda)
	int x,y;
	int cat;
	int label;
	double lambda;
{
	char * string;
	int markerx, markery;

	screengraphics_circle(x,y,ptrad,pointcolour);
	if (cat==ACCEPTSTATE)
		screengraphics_circle(x,y,2*ptrad,pointcolour);

	if (cat==ACCEPTSTATE){
		markerx = x + (2*ptrad+0.8*charht)*cos(lambda*2*M_PI); 
		markery = y + (2*ptrad+0.8*charht)*sin(lambda*2*M_PI);
	}
	else {
		markerx = x + (ptrad+0.8*charht)*cos(lambda*2*M_PI); 
		markery = y + (ptrad+0.8*charht)*sin(lambda*2*M_PI);
	}

	string = vzalloc2(char,10);
	sprintf(string,"%d",label);
	screengraphics_text(markerx,markery,string,1.0,0.0,0.0,1.0,charht,labelcolour);
	Free_dp((dp)string);
	string = 0;
}


void
pt_label_posn(x,y,cat,lambda,xxp,yyp)
	int x,y;
	int cat;
	double lambda;
	int * xxp;
	int * yyp;
{
	if (cat==ACCEPTSTATE){
		*xxp = x + (2*ptrad+0.7*charht)*cos(lambda*2*M_PI); 
		*yyp = y + (2*ptrad+0.7*charht)*sin(lambda*2*M_PI);
	}
	else {
		*xxp = x + (ptrad+0.7*charht)*cos(lambda*2*M_PI); 
		*yyp = y + (ptrad+0.7*charht)*sin(lambda*2*M_PI);
	}
}

double
pt_lambda(x,y,xx,yy)
	int x,y,xx,yy;
{
	double lambda;
	int a,b;
	double theta;
	a=xx-x;
	b=yy-y;
	
	if (a>0)
		theta=atan((double)(b)/(double)(a));
	else if (a<0)
		theta=atan((double)(b)/(double)(a)) + M_PI;
	else if (b>=0) /* a==0 */
		theta=M_PI/2;
	else /* b<0, a==0 */
		theta=3*M_PI/2;
	lambda=theta/(2.0*M_PI);
	return lambda;
}


void
loop_centre_posn(x,y,mu,xxp,yyp)
	int x,y;
	double mu;
	int * xxp;
	int * yyp;
{
	double theta;
	if (x>0)
		theta=atan((double)(y)/(double)(x));
	else if (x<0)
		theta=atan((double)(y)/(double)(x)) + M_PI;
	else if (y>=0) /* x==0 */
		theta=M_PI/2;
	else /* y<0, x==0 */
		theta=3*M_PI/4;
	theta += mu;
	*xxp = x + lprad * cos(theta);
	*yyp = y + lprad * sin(theta);
}

double
nearest_mu(x,y,xx,yy)
	int x,y,xx,yy;
{
	double mu;
	int a,b;
	double theta;
	double phi;
	a=xx-x;
	b=yy-y;
	
	if (a>0)
		theta=atan((double)(b)/(double)(a));
	else if (a<0)
		theta=atan((double)(b)/(double)(a)) + M_PI;
	else if (b>=0) /* a==0 */
		theta=M_PI/2;
	else /* b<0, a==0 */
		theta=3*M_PI/2;
	if (x>0)
		phi=atan((double)(y)/(double)(x));
	else if (x<0)
		phi=atan((double)(y)/(double)(x)) + M_PI;
	else if (y>=0) /* x==0 */
		phi=M_PI/2;
	else /* y<0, x==0 */
		phi=3*M_PI/4;
	mu = theta-phi;
	return mu;
}

void
screen_join(x1,y1,cat1,x2,y2,cat2,g,lambda)
	int x1,y1,cat1,x2,y2,cat2;
	gen g;
	double lambda;
{
	int markerx,markery,pointx,pointy;
	double a,b;
	double e;
	double alpha;
	double beta;

	a = x2 - x1;
	b = y2 - y1;
	e = sqrt((double)(a*a+b*b));
	a=a/e; b=b/e;

	pointx = x1 + KAPPA * e*a;
	pointy = y1 + KAPPA * e*b;
	screen_direct_edge(pointx,pointy,a,b);

	if (g>0) {
		if (a>0) {
			markerx = x1 + lambda*e*a - 0.7*charht*b;   
			markery = y1 + lambda*e*b + 0.7*charht*a;
		}
		else {
			markerx = x1 + lambda*e*a + 0.7*charht*b;   
			markery = y1 + lambda*e*b - 0.7*charht*a;
		}
		screen_label_edge(markerx,markery,g,a,b);
	}

	if (cat1==ACCEPTSTATE)
		alpha=2*ptrad;
	else 
		alpha=ptrad;
	if (cat2==ACCEPTSTATE)
		beta=2*ptrad;
	else 
		beta=ptrad;

	
	x1 += alpha*a;
	y1 += alpha*b;
	x2 -= beta*a;
	y2 -= beta*b;
	screengraphics_line(x1,y1,x2,y2,edgecolour);
}

void
line_label_posn(x1,y1,x2,y2,lambda,xxp,yyp)
	int x1,y1,x2,y2;
	double lambda;
	int * xxp;
	int * yyp;
{
	double a,b,e;
	a = x2 - x1;
	b = y2 - y1;
	e = sqrt((double)(a*a + b*b));
	a = a/e;
	b = b/e;

		if (a>0) {
			*xxp = x1 + lambda*e*a -0.7*charht*b;   
			*yyp = y1 + lambda*e*b + 0.7*charht*a;
		}
		else {
			*xxp = x1 + lambda*e*a + 0.7*charht*b;   
			*yyp = y1 + lambda*e*b - 0.7*charht*a;
		}
}

double
line_lambda(x1,y1,x2,y2,x,y)
	int x1,y1,x2,y2,x,y;
{
	double lambda;
	double cc,dd,ee;
	ee=(x2-x1)*(x2-x1)+(y2-y1)*(y2-y1);
	cc=(x-x1)*(x-x1)+(y-y1)*(y-y1);
	cc=cc/ee;
	dd=(x-x2)*(x-x2)+(y-y2)*(y-y2);
	dd=dd/ee;
	lambda=(double)(cc-dd+1.0)/2.0;
	if (lambda<0.05)
		lambda=0.05;
	else if (lambda>0.95)
		lambda=0.95;
	return lambda;
}
	
		

static void
screen_direct_edge(pointx,pointy,a,b)
	int pointx,pointy;
	double a,b; /* a*a + b*b=1 */
{
	int x,y;
	x = pointx -charht*(a+b)/2;
	y = pointy +charht*(a-b)/2;
	screengraphics_line(pointx,pointy,x,y,edgecolour);
	x = pointx +charht*(b-a)/2;
	y = pointy -charht*(a+b)/2;
	screengraphics_line(pointx,pointy,x,y,edgecolour);
}

static void
screen_label_edge (markerx,markery,g,a,b)
	int markerx, markery;
	gen g;
	double a,b;
{
	char * genlabel;
	int length;
	int i=0;
	gen h;

	if (two_var){
		word w1,w2;
		word_init(&w1);
		word_init(&w2);
		gen2user_name(1+(g-1)/(num_gens+1),&w1);
		gen2user_name((g-1)%(num_gens+1)+1,&w2);
		length=word_length(&w1)+word_length(&w2)+3;
		genlabel = vzalloc2(char,length+1);
		genlabel[i++]='(';
		while(word_delget_first(&w1,&h))
			genlabel[i++]=(char)h;
		genlabel[i++]=',';
		while(word_delget_first(&w2,&h))
			genlabel[i++]=(char)h;
		genlabel[i++]=')';
		genlabel[length]= '\0';
		word_clear(&w1); 
		word_clear(&w2); 
	} 
	else { 
		word w;
		word_init(&w);
		gen2user_name(g,&w);
		length = word_length(&w);	
		genlabel = vzalloc2(char,length+1);
		while(word_delget_first(&w,&h))
		genlabel[i++]=(char)h;
		genlabel[length]= '\0';
		word_clear(&w);
	}
	if (a<0){
		a =	-a;
		b = -b;
	}
	screengraphics_text(markerx,markery,genlabel,a,b,-b,a,charht,labelcolour);
	Free_dp((dp)genlabel); genlabel=0;
}

void
screen_loop(x,y,cat,g,lambda,mu)
	int x,y,cat;
	gen g;
	double lambda;
	double mu;
{
	int centrex, centrey;
	int markerx, markery;
	int pointx, pointy;
	double a,b,e;
	double phi;
	double theta;

	if (x>0)
		theta=atan((double)(y)/(double)(x));
	else if (x<0)
		theta=atan((double)(y)/(double)(x)) + M_PI;
	else if (y>=0) /* x==0 */
		theta=M_PI/2;
	else /* y<0, x==0 */
		theta=3*M_PI/4;
	theta += mu;
	centrex = x + lprad * cos(theta);
	centrey = y + lprad * sin(theta);

	screengraphics_circle(centrex,centrey,lprad,edgecolour);

	pointx = centrex  + lprad*cos((double)(KAPPA*2*M_PI));
	pointy = centrey + lprad*sin((double)(KAPPA*2*M_PI));
	screen_direct_edge(pointx,pointy,-sin((double)(KAPPA*2*M_PI)),
						cos((double)(KAPPA*2*M_PI)));

	phi = (double)(lambda*2*M_PI);
	markerx = centrex+(lprad+0.7*charht)*cos(phi);
	markery = centrey+(lprad+0.7*charht)*sin(phi);
	screen_label_edge(markerx,markery,g,-sin(phi),cos(phi));
}

void
loop_label_posn(x,y,lambda,mu,xxp,yyp)
	int x,y;
	double lambda,mu;
	int * xxp;
	int * yyp;
{
	double phi;
	double theta;

	if (x>0)
		theta=atan((double)(y)/(double)(x));
	else if (x<0)
		theta=atan((double)(y)/(double)(x)) + M_PI;
	else if (y>=0) /* x==0 */
		theta=M_PI/2;
	else /* y<0, x==0 */
		theta=3*M_PI/4;
	theta += mu;
	phi = (double)(lambda*2*M_PI);
	*xxp = (int)(x + lprad*cos(theta)+(lprad+0.7*charht)*cos(phi));
	*yyp = (int)(y + lprad*sin(theta)+(lprad+0.7*charht)*sin(phi));
}

double
loop_lambda(x,y,mu,xx,yy)
	int x,y;
	double mu;
	int xx,yy;
{
	double lambda;
	double phi;
	double theta;
	double c,d;

	if (x>0)
		theta=atan((double)(y)/(double)(x));
	else if (x<0)
		theta=atan((double)(y)/(double)(x)) + M_PI;
	else if (y>=0) /* x==0 */
		theta=M_PI/2;
	else /* y<0, x==0 */
		theta=3*M_PI/4;
	theta += mu;
	c=(double)(xx-x-lprad*cos(theta));
	d=(double)(yy-y-lprad*sin(theta));
	if (c>0)
		phi=atan((double)(d)/(double)(c));
	else if (c<0)
		phi=atan((double)(d)/(double)(c)) + M_PI;
	else if (d>=0) /* c==0 */
		phi=M_PI/2;
	else /* d<0, d==0 */
		phi=3*M_PI/2;
	lambda=phi/(2.0*M_PI);
	return lambda;
}

void ps_graphics_init(file)
	FILE* file;
{
	int originx,originy;
	int charhts;
	double f1,f2;

        f1=2*rmax/PAGEWD;  f2=(rmax+depth)/PAGEHT;
        scale= f1>f2 ? f1 : f2;

        originx=PAGEWD/2+20; originy= -PAGEHT*rmax/(rmax+depth);

	    putc('%',file);
	charhts = charht/scale;
        fprintf(file,"!\n/scaletimes\n{/Times-Roman findfont\n");
        fprintf(file,"  exch scalefont\n  setfont } def\n\n");
        fprintf(file,"90 rotate\n%d %d translate\n",originx,originy);
	fprintf(file,"0.1 0.1 scale\n");
	scale /= 10;
        fprintf(file,"%d scaletimes\n\n",(charhts+2)*10);
	fprintf(file,"6 setlinewidth\n");
}


void ps_graphics_clear(file)
	FILE * file;
{
	fprintf(file,"showpage\n");
}

void 
ps_plot(centrex,centrey,cat,label,lambda,file)
	int centrex,centrey,cat;
	int label;
	double lambda;
	FILE *file;
{
	double markerx,markery;
	int centrexs,centreys,markerxs,markerys,ptrads;
	double mu;
	centrexs = centrex/scale;
	centreys = centrey/scale;
	ptrads = ptrad/scale;
	fprintf(file,"newpath\n%d %d %d 0 360 arc\nstroke\n"
		,centrexs,centreys,ptrads);

	mu = lambda - 0.25;
	if (mu < 0) mu += 1;
	if (cat==ACCEPTSTATE)
		fprintf(file,"newpath\n%d %d %d 0 360 arc\nstroke\n"
			,centrexs,centreys,2*ptrads);

	if (cat==ACCEPTSTATE){
		markerx = centrex + (2*ptrad+charht/2)*cos(lambda*2*M_PI)
					- charht*sin(lambda*M_PI)/3; 
		markery = centrey + (2*ptrad+charht/2)*sin(lambda*2*M_PI)
					- charht*sin(mu*M_PI)/2;
	}
	else {
		markerx = centrex + (ptrad+charht/2)*cos(lambda*2*M_PI) 
					- charht*sin(lambda*M_PI)/3; 
		markery = centrey + (ptrad+charht/2)*sin(lambda*2*M_PI)
					- charht*sin(mu*M_PI)/2;
	}
	markerxs = markerx/scale;
	markerys = markery/scale;
        fprintf(file,"%d %d moveto\n(%d) show\n",
                     markerxs,markerys,label);
}

void
ps_join(x1,y1,cat1,x2,y2,cat2,g,lambda,file)
	int x1,y1,cat1,x2,y2,cat2;
	gen g;
	double lambda;
	FILE* file;
{
	int xx1, yy1, xx2, yy2;
	double markerx,markery,pointx,pointy;
	char *genlabel;
	double a,b;
	double e;
	double alpha;
	double beta;

	a = x2 - x1;
	b = y2 - y1;
	e = sqrt((double)(a*a+b*b));
	a=a/e; b=b/e;

	pointx = x1 + KAPPA * e*a;
	pointy = y1 + KAPPA * e*b;
	ps_direct_edge(pointx,pointy,a,b,file);

	if (g>0) {
		if (a> -.0001) {
			markerx = x1 + lambda*e*a - 0.2*charht*b;   
			markery = y1 + lambda*e*b + 0.2*charht*a;
		}
		else {
			markerx = x1 + lambda*e*a + 0.2*charht*b;   
			markery = y1 + lambda*e*b - 0.2*charht*a;
		}
		ps_label_edge(markerx,markery,g,a,b,FALSE,file);
	}

	if (cat1==ACCEPTSTATE)
		alpha=2*ptrad;
	else 
		alpha=ptrad;
	if (cat2==ACCEPTSTATE)
		beta=2*ptrad;
	else 
		beta=ptrad;

	x1 = x1 + alpha*a;
	y1 = y1 + alpha*b;
	x2 = x2 - beta*a;
	y2 = y2 - beta*b;
	xx1 = x1/scale;
	xx2 = x2/scale;
	yy1 = y1/scale;
	yy2 = y2/scale;

	fprintf(file,"newpath\n%d %d moveto\n%d %d lineto\nstroke\n",
		xx1,yy1,xx2,yy2);


}

void
ps_loop(x,y,cat,g,lambda,mu,file)
	int x,y;
	int cat;
	gen g;
	double lambda;
	double mu;
	FILE* file;
{
	double centrex,centrey;
	int centrexs,centreys;
	double markerx,markery;
	double pointx,pointy;
	double theta;
	int lprads;
	double deg1,deg2;
	double phi;

	if (x>0)
		theta=atan((double)(y)/(double)(x));
	else if (x<0)
		theta=atan((double)(y)/(double)(x)) + M_PI;
	else if (y>=0) /* x==0 */
		theta=M_PI/2;
	else /* y<0, x==0 */
		theta=3*M_PI/4;
	theta += mu;
	centrex = x + lprad * cos(theta);
	centrey = y + lprad * sin(theta);
	centrexs = centrex/scale;
	centreys = centrey/scale;
	lprads = lprad/scale;
	if (cat==ACCEPTSTATE){
		deg1 = (M_PI + theta + (double) 2*ptrad/lprad)*180/M_PI;
		deg2 = (M_PI + theta - (double) 2*ptrad/lprad)*180/M_PI;
	}
	else {
		deg1 = (M_PI + theta + (double) ptrad/lprad)*180/M_PI;
		deg2 = (M_PI + theta - (double) ptrad/lprad)*180/M_PI;
	}
	fprintf(file,"newpath\n%d %d %d %f %f arc\nstroke\n"
		,centrexs,centreys,lprads,deg1,deg2);


	pointx = centrex  + lprad*cos((double)(KAPPA*2*M_PI));
	pointy = centrey + lprad*sin((double)(KAPPA*2*M_PI));
	ps_direct_edge(pointx,pointy,-sin((double)(KAPPA*2*M_PI)),
					cos((double)(KAPPA*2*M_PI)),file);

	phi = (double)(lambda*2*M_PI);
	markerx = centrex+(lprad+0.2*charht)*cos(phi);
	markery = centrey+(lprad+0.2*charht)*sin(phi);
	ps_label_edge(markerx,markery,g,
                     -sin(phi),cos(phi),TRUE,file);
}

static void
ps_direct_edge(pointx,pointy,a,b,file)
        double pointx,pointy;
        double a,b; /* a*a + b*b=1 */
	FILE * file;
{
        double arrowx[3],arrowy[3];
        int arrowxs[3],arrowys[3];

	arrowx[0]=pointx-charht*(a+b)/2;
	arrowy[0]=pointy+charht*(a-b)/2;
	arrowx[1]=pointx;
	arrowy[1]=pointy;
	arrowx[2]=pointx+charht*(b-a)/2;
	arrowy[2]=pointy-charht*(a+b)/2;
	arrowxs[0] =arrowx[0]/scale;
	arrowys[0] =arrowy[0]/scale;
	arrowxs[1] =arrowx[1]/scale;
	arrowys[1] =arrowy[1]/scale;
	arrowxs[2] =arrowx[2]/scale;
	arrowys[2] =arrowy[2]/scale;
	fprintf(file,"newpath\n%d %d moveto\n",arrowxs[0],arrowys[0]);
	fprintf(file,"%d %d lineto\n%d %d lineto\nstroke\n",
			arrowxs[1],arrowys[1],arrowxs[2],arrowys[2]);
}

static void
ps_label_edge (pointx,pointy,g,a,b,loop,file)
        double pointx,pointy;
        gen g;
        double a,b;
	boolean loop;
	FILE * file;
{
	int pointxs,pointys,charhts;
    char *genlabel;
    int length;
    int i=0;
	gen h;
	int deg;
	boolean upsidedown=FALSE;

	if (two_var){
		word w1,w2;
		word_init(&w1);
		word_init(&w2);
		gen2user_name(1+(g-1)/(num_gens+1),&w1);
		gen2user_name((g-1)%(num_gens+1)+1,&w2);
		length=word_length(&w1)+word_length(&w2)+3;
		genlabel = vzalloc2(char,length+1);
		genlabel[i++]='(';
		while(word_delget_first(&w1,&h))
			genlabel[i++]=(char)h;
		genlabel[i++]=',';
		while(word_delget_first(&w2,&h))
			genlabel[i++]=(char)h;
		genlabel[i++]=')';
		genlabel[length]= '\0';
		word_clear(&w1);
		word_clear(&w2);
	}
	else {
		word w;
		word_init(&w);
		gen2user_name(g,&w);
		length = word_length(&w);	
		genlabel = vzalloc2(char,length+1);
		while(word_delget_first(&w,&h))
		genlabel[i++]=(char)h;
		genlabel[length]= '\0';
		word_clear(&w);
	}

   if (a<= -.0001){
   	    a = -a;
        b = -b;
    }
	else upsidedown=TRUE;
	if (a<0.0001 && a> -.0001) deg= b>0 ? 90 : -90;
	else deg=atan((double)b/a)*180/M_PI;
	pointxs = pointx/scale;
	pointys = pointy/scale;
	charhts = charht/scale;
	fprintf(file,"%d %d translate\n",pointxs,pointys);
        if (upsidedown && loop)
	fprintf(file,"%d rotate\n0 %d moveto\n",deg,-charhts);
        else fprintf(file,"%d rotate\n0 0 moveto\n",deg);
        fprintf(file,"(%s)show\n0 0 moveto\n%d rotate\n",genlabel,-deg);
        fprintf(file,"%d %d translate\n",-pointxs,-pointys);

        Free_dp((dp)genlabel); genlabel=0;
}
