/* automata.d/src file eosdel.c */
# include <stdio.h>
# include "defs.h"
# include "list.h"
# include "word.h"
# include "input.h"
#include "afsa.h"
#define EOSDELOP ".eosdel"
FILE * wfile = stdout;
FILE *rfile = stdin;
extern word * user_gen_name;
extern int gen_array_size;
extern int num_gens;

main(argc,argv)
	int argc;
	char * argv[];
{
	int i=0;
	afsa *fsa=0;
	afsa *eos_del=0;
	char filename[100];

	if (argc>2){
		fprintf(stderr,"Usage: eosdel [filename]\n");
		exit(2);
	}
	else if (argc==2){
		strcpy(filename,argv[1]);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		strcat(filename,EOSDELOP);
		wfile=fopen(filename,"w");
	}

	setbuf(stdout,(char*)0);
	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);


	while (copy_to_keyword("fsa","2.2",rfile,wfile)){
		boolean eos=FALSE;
		fsa=afsa_read(&user_gen_name,rfile);
		eos=fsa->eos;
		if (eos || fsa->variables > 1)
			num_gens = fsa->base_symbols - 1;
		else
			num_gens = fsa->base_symbols;
		if (eos){
			eos_del=afsa_eosdelete(fsa);
			afsa_print(wfile,eos_del);
			afsa_clear(eos_del);
			Free_dp((dp)eos_del); eos_del=0;
		}
		else{
			fprintf(stderr,"# Warning. Input fsa was already \"no_eos\"\n");
			afsa_print(wfile,fsa);
		}
		afsa_clear(fsa);
		Free_dp((dp)fsa); fsa=0;
		for (i=0;i<gen_array_size;++i)
			word_clear(user_gen_name+i);
		Free_dp((dp)user_gen_name); user_gen_name=0;
	}
	assert(store_ptrs==0);
	exit(0);
}
