/* automata.d/src file enumerate.c */
# include <stdio.h>
# include <ctype.h>
# include "defs.h"
# include "list.h"
# include "word.h"
# include "input.h"
# include "afsa.h"
# define DENUMERATEOP ".d.enumerate"
# define ENUMERATEOP ".enumerate"
FILE * rfile=stdin;
FILE * wfile=stdout;
FILE * keyboard=0;
extern word * user_gen_name;
extern int num_gens;
extern int gen_array_size;
afsa * fsap=0;
#define LINEAR 0
#define CIRCULAR 1
int order=LINEAR;
int n=0;
static void
afsa_language_enumerate PARMS((VOID));

main(argc,argv)
	int argc;
	char * argv[];
{
	int i;
	char * label;
	char filename[100];
	boolean commandline_parameters=FALSE;
	boolean del_eos=FALSE;
	boolean interactive=FALSE;
	
	i=1;
    while (i<argc && argv[i][0]=='-'){
		if (strcmp(argv[i],"-c")==0)
			order=CIRCULAR;
		else if (strcmp(argv[i],"-i")==0)
			interactive = TRUE;
		else if (strcmp(argv[i],"-d")==0)
			del_eos = TRUE;
		else if (argv[i][1]=='m'){
			int j=0;
			i++;
			if (i==argc){
				fprintf(stderr,
				"Usage: enumerate [-c] [-d] [-i] [-m posint] [filename]\n");
				exit(2);
			}
			commandline_parameters=TRUE;
			while (argv[i][j]!='\0') {
				if (!isdigit(argv[i][j])) {
					fprintf(stderr,
					"Usage: enumerate [-c] [-d] [-i] [-m posint] [filename]\n");
					exit(2);
				}
				n = 10*n + argv[i][j]-'0';
				j++;
			}
		}
		i++;
	}
	if (i<argc-1){
		fprintf(stderr,
			"Usage: enumerate [-c] [-d] [-i] [-m posint] [filename]\n");
		exit(2);
	}
	else if (i==argc-1){
/* the input and output files are being specified as filename and 
filename.enumerate or filename.d.enumerate*/
		strcpy(filename,argv[argc -1]);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		if (del_eos)
			strcat(filename,DENUMERATEOP);
		else
			strcat(filename,ENUMERATEOP);
		wfile=fopen(filename,"w");
	}

	setbuf(stdout,(char*)0);
	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);

	label=vzalloc2(char,9);
	while (read_next_string(label,8,rfile)){
		if (strcmp(label,"Format  ")==0)
			format_echocheck("2.2",rfile,wfile);
		else if ((strcmp(label,"fsa     ")==0) && fsap==0){
			fsap=afsa_read(&user_gen_name,rfile);
			if (fsap->eos==FALSE)
				num_gens = fsap->base_symbols;
			else
				num_gens = fsap->base_symbols - 1;
			}	
		else if (interactive == FALSE && commandline_parameters==FALSE
				&& strcmp(label,"paramete")==0){
			while (getc(rfile)!='\{')
				;
			if (find_keyword("maxlength",rfile))
					read_next_int(&n,rfile);
			while (getc(rfile)!='\}')
				;
		}
	}
	Free_dp((dp)label); label=0;
	if (fsap==0){
		fprintf(stderr,"\t# No fsa received as input.\n");
		bad_data();
	}
	if (del_eos){
		if (fsap->eos==FALSE)
			fprintf(stderr,"\t# fsa was already no-eos\n");
		else {
			afsa * fsa2p=afsa_eosdelete(fsap);
			afsa_clear(fsap);
			Free_dp((dp)fsap); fsap=0;
			fsap=fsa2p;
		}
	}
	if (interactive){
		keyboard = fopen("/dev/tty","w");
		fprintf(keyboard,"In interactive mode.\n");
		fprintf(keyboard,"Programme expects parameters input,\n");
		fprintf(keyboard,
			"that is, the keyword maxlength followed by a positive integer.\n");
		fprintf(keyboard,"Terminate parameter set with a closing \}.\n");
		fprintf(keyboard,"parameters {\n");
		rfile=fopen("/dev/tty","r");
		while (find_keyword("maxlength",rfile)){
			read_next_int(&n,rfile);
			fprintf(wfile,"\t# maxlength = %d\n",n);
			fprintf(wfile,"words \{\n");
			afsa_language_enumerate();
			fprintf(wfile,"\}\n");
		}
		while (getc(rfile)!='\}')
			;
	}
	else {
		if (n==0)
			fprintf(stderr,"\t# Warning. maxlength=0.\n");
		fprintf(wfile,"\t# maxlength = %d\n",n);
		fprintf(wfile,"words \{\n");
		afsa_language_enumerate();
		fprintf(wfile,"\}\n");
	}
	afsa_clear(fsap);
	Free_dp((dp)fsap); fsap=0;
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name); user_gen_name=0;
	assert(store_ptrs==0);
	exit(0);
}

static void
afsa_language_enumerate()
{
	word w;
	word w1;
	word w2;
	gen g=INVALID_GEN;
	gen h = INVALID_GEN;
	int l=0;
	int * states;
	int ** array=fsap->array;
	int symbols = fsap->symbols;
	int base_symbols=fsap->base_symbols;
	boolean backtrack=FALSE;
	
	int k;
	boolean double_strings=FALSE;
	if (fsap->variables==2){
		double_strings=TRUE;
		word_init(&w1);
		word_init(&w2);
	}
	word_init(&w); 
	states = vzalloc2(int,n+1);
	states[0]=1;
	if (array[0][states[l]]==ACCEPTSTATE) {
		if (double_strings==FALSE)
			word_print(wfile,&w);
		else {
			word_print(wfile,&w1);
			fprintf(wfile,"  ");
			word_print(wfile,&w2);
		}
		fprintf(wfile,"\n");
	}
	if (symbols>0)
		g=1;
	if (n>0){
		while (l>0|| !(backtrack)) {
			if (l==n)
				backtrack = TRUE;
			while (backtrack) {  /* backtrack */
				if (double_strings){
					word_del_last(&w1);
					word_del_last(&w2);
				}
				word_delget_last(&w,&g);
				l--;
			/* find the next generator, if there is one */
				if ((order==CIRCULAR&&(word_get_last(&w,&h))&&h==g)
						||(order==LINEAR&&g==symbols)){
			/* carry on backtracking, unless back at the start */
					if (l==0)
						break;
				}
				else if (order==CIRCULAR&&g==symbols){
					if (l==0)
						break;
					else {
						g=1;
						backtrack=FALSE;
					}
				}
				else{
					g++;
					backtrack=FALSE;
				}
			}
			if (backtrack && l==0)
				break;
			 /* Now try to move forward */
			while ((k=array[g][states[l]])<=0){
			/* try the next generator, if there is one */
				if ((order==CIRCULAR&&(word_get_last(&w,&h))&&h==g)
							||(order==LINEAR&&g==symbols)){
					backtrack=TRUE;
					break;
				}
				else if (order==CIRCULAR&&g==symbols){
					if (l!=0)
						g=1;
					else {
						backtrack=TRUE;
						break;
					}
				}
				else
					g++;
			}
			if (backtrack)
				continue;
			else {
				assert (k>0);
				states[l+1] = k;
				word_put_last(&w,g);
				if (double_strings){
					word_put_last(&w1,1+((g-1)/base_symbols));
					word_put_last(&w2,(g-1)%base_symbols+1);
				}
				if (order==CIRCULAR && g<symbols)
					g = g+1;
				else
					g = 1;
				if (states[l+1]>=0&&array[0][states[l+1]]==ACCEPTSTATE) {
					if (double_strings==FALSE)
						word_print(wfile,&w);
					else {
						word_print(wfile,&w1);
						fprintf(wfile,"  ");
						word_print(wfile,&w2);
					}
					fprintf(wfile,"\n");
				}
				l++;
			}
		}
	}
	Free_dp((dp)states); states=0;
	word_clear(&w);
	if (double_strings){
		word_clear(&w1);
		word_clear(&w2);
	}
}	

