/* automata.d/src file density.c */
#include <stdio.h>
#include <ctype.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "reduce.h"
#include "input.h"
#include "afsa.h"
#include "reduce.h"
#define LIMIT 10000
extern word * user_gen_name;
extern gen * inv_of;
extern int num_gens;
extern int gen_array_size;
afsa * WA;
twoafsa * DIFF=0;
#define DIFF1OP ".diff1"
#define WAOP ".wa"
FILE * rfile=stdin;
FILE * wfile=stdout;
FILE * keyboard=0;
static void density PARMS((int n));

main(argc,argv)
	int argc;
	char * argv[];
{
	char * label;
	char gpname[100];
	char filename[100];
	int n=0;
	int i;
	int readfile=0;
	boolean first_fc = TRUE;
	boolean interactive = FALSE;
	boolean commandline_parameters = FALSE;
	
	i=1;
    while (i<argc && argv[i][0]=='-'){
		if (argv[i][1]=='l'){
			int j=0;
			commandline_parameters=TRUE;
			i++;
			if (i==argc){
				fprintf(stderr,
					"Usage: density [-l posint] [-i] [gpname]\n");
				exit(2);
			}
			while (argv[i][j]!='\0') {
				if (!isdigit(argv[i][j])){
					fprintf(stderr,
						"Usage: density [-l posint] [-i] [gpname]\n");
					exit(2);
				}
				n = 10*n + argv[i][j]-'0';
				j++;
			}
		}
		else if (strcmp(argv[i],"-i")==0)
			interactive=TRUE;
		else {
			fprintf(stderr,"Usage: density [-l posint] [-i] [gpname]\n");
			exit(2);
		}
		i++;
	}
	if (i<argc-1){
		fprintf(stderr,"Usage: density [-l posint] [-i] [gpname]\n");
		exit(2);
	}
	else if (i==argc-1){
		strcpy(gpname,argv[argc -1]);
		strcpy(filename,gpname);
		strcat(filename,DIFF1OP);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		readfile=1;
	}

	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);
	label=vzalloc2(char,9);

	while
	((read_next_string(label,8,rfile)) ||readfile==1){
		if (strcmp(label,"Format  ")==0){
			if (first_fc){
				format_echocheck("2.2",rfile,wfile);
				first_fc = FALSE;
			}
			else
				format_check("2.2",rfile);
		}
		else if (strcmp(label,"fsa     ")==0){
			if (DIFF==0){
				DIFF=twoafsa_read(&user_gen_name,rfile);
				num_gens=DIFF->base_symbols - 1;
	/* |num_gens| is set now */
			}
			else if (WA==0){
				WA=afsa_read(&user_gen_name,rfile);
				if (WA->symbols > num_gens){
					afsa * WAcopy;
					WAcopy=WA;
					WA=0;
					WA=afsa_eosdelete(WAcopy);
					afsa_clear(WAcopy);
					Free_dp((dp)WAcopy); WAcopy=0;
				}
			}
		}
		else if (strcmp(label,"inverses")==0){
			if (inv_of==0)
				read_inverse_array(rfile);
		}
		else if (interactive==FALSE && commandline_parameters==FALSE 
			&& strcmp(label,"paramete")==0){
			while (getc(rfile)!='\{')
				;
			if (find_keyword("length",rfile))
					read_next_int(&n,rfile);
			while (getc(rfile)!='\}')
				;
		}
		else if (readfile==1){
			strcpy(filename,gpname);
			strcat(filename,WAOP);
			if ((rfile=fopen(filename,"r"))==0)
  				{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
			readfile=2;
		}
	}

	if (DIFF==0 ||WA==0) {
		fprintf(stderr,
			"Expected difference machine and word acceptor in input.\n");
		bad_data();
	}
	if (inv_of==0)
		default_inverse_array();

	if (interactive){
		keyboard = fopen("/dev/tty","w");
		fprintf(keyboard,"In interactive mode.\n");
		fprintf(keyboard,"Programme expects parameters input,\n");
		fprintf(keyboard,
			"that is, the keyword length followed by a positive integer.\n");
		fprintf(keyboard,"Terminate parameter set with a closing \}.\n");
		fprintf(keyboard,"parameters {\n");
		rfile=fopen("/dev/tty","r");
		while (find_keyword("length",rfile)){
			read_next_int(&n,rfile);
			fprintf(wfile,"\t# length = %d\n",n);
			while (n<=0){
				fprintf(stderr,
					"\t# Length parameter must be a positive integer.\n");
				fprintf(stderr,"\t# Try again.\n");
				read_next_int(&n,rfile);
				fprintf(wfile,"\t# length = %d\n",n);
			}
			density(n);
		}
		while (getc(rfile)!='\}')
			;
	}
	else {
		if (n<=0){
			fprintf(stderr,"Length parameter not set to a positive integer.\n");
			bad_data();
		}
		fprintf(wfile,"\t# length = %d\n",n);
		density(n);
	}
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name); user_gen_name=0;
	Free_dp((dp)inv_of); inv_of=0;
	Free_dp((dp)label); label=0;
	afsa_clear(WA);
	Free_dp((dp)WA); WA=0;
	twoafsa_clear(DIFF);
	Free_dp((dp)DIFF); DIFF=0;
	exit(0);
}

static void
density(n)
	int n;
{
	int ** array=WA->array;
	int seed=3;
	word w;
	int len=0;
	int v=1; 
	int * count;
	int total=0;
	int nreduced=0;
	boolean reduced=TRUE;;
	word_init(&w);
	count = vzalloc2(int,n+1);

	srandom(seed);
	while (total<=LIMIT){
		int r=random();
		gen g;
		while (r>=num_gens){
			g = r%num_gens;
/* g is then in the range |0,1,2...num_gens-1| */
			r = r/num_gens;
            word_put_last(&w,g+1);
            len++;
			v=array[g+1][v];
/* v is the vertex we get by tracing out the reduction of w in the word
acceptor. So every time we find a reduction in w we need to retrace v */
			if (v==0|| array[0][v]==NONACCEPTSTATE){
				word_traverser wt;
				diff_reduction(DIFF,&w);
				v=1;
				word_traverser_init(&wt,&w);
				while (word_next(&wt,&g));
					v=array[g][v];
				word_traverser_clear(&w);
				reduced=FALSE;
			}
			if (len==n){
				if (reduced) nreduced++;
				count[word_length(&w)]++;
				word_reset(&w);
				v=1;
				len=0;
				total++;
				reduced=TRUE;
				if (total%5000==0){
					int i;
fprintf(wfile,"\t#Reduced lengths for %d random words length %d:-\n\t#",total,n);
					for (i=0;i<=n;++i)
						fprintf(wfile,"%d ",count[i]);
			fprintf(wfile,"   Number already reduced: %d\n",nreduced);
				}
				if (total>LIMIT)
					break;
			}
		}
	}
	word_clear(&w);
	Free_dp((dp)count);count=0;
}	
