/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

/************KEEP FILE************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#import <objc/objc.h>
#include "link_types.h"
#include "link_edit_types.h"
#include "link_edit_global.h"
#import "EditView.h"


int LinkPrintStrand3D(LinkStatus *gnrc,FILE *fp,LinkList *lnk)

/* Prints out coordinate data for lnk, incorporating in */
/* the crossings as part of the data.  The result is a */
/* tubable strand.  The header is printed by the caller */
/* The format is the geometry group LINK format */
/* If a strand is not closed a warning message is printed */
{
  
  LinkPointList *pnt;
  LinkCrossingList *crssng;

  if(!lnk->closed) {
     fprintf(stderr,"Warning! Strand not closed! Printing data anyway...\n");
    }
  pnt = lnk->point.next;
  while(pnt != NULL) {
     fprintf(fp,"    %.4lf  %.4lf  %.4lf\n",pnt->x,pnt->y,pnt->z);
     crssng = pnt->crossing.next;
     while(crssng != NULL) {
        fprintf(fp,"    %.4lf  %.4lf  %.4lf\n",crssng->x,crssng->y,crssng->z);
        crssng = crssng->next;
       }
     pnt = pnt->next;
    }
  return(0);
}
