/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  setting_menu.c: Functions for setting menu window.           */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <stdio.h>   
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include "source/Hcad.h"

#include "Hcadext.h"

/*------------------------------------------------------------

  Function : setting_menu(int)

-------------------------------------------------------------*/
setting_menu(invert_num)
int invert_num;
{

	int looping,i,cnt;
	char text_buffer[40], s[5];
	int text_width;
	XSetWindowAttributes  atr;

	sub_menuhint.x = 400;
	sub_menuhint.y = 35 + 20*invert_num;
	sub_menuhint.width = 0;
	sub_menuhint.height = 0;
	sub_menuhint.flags = PPosition | PSize;

	/*  File menu */
	switch(invert_num){
	case 0:
		/* representation menu */
		sub_menuhint.width = 350;
		sub_menuhint.height = 250;
		break;
	case 1:
		/* rotation angle menu */
		sub_menuhint.width = 300;
		sub_menuhint.height =100;
		break;
	case 2:
		/* size menu */
		sub_menuhint.width = 300;
		sub_menuhint.height =100;
		break;
	default:
		return;
	}

	sub_menuwin = XCreateSimpleWindow(disp,basewin,sub_menuhint.x,sub_menuhint.y,
	sub_menuhint.width,sub_menuhint.height,
	2,black,white);
	sub_menugc = XCreateGC(disp,sub_menuwin,0,0);
	XSetBackground(disp,sub_menugc,white);
	XSetForeground(disp,sub_menugc,black);
	XSetFunction(disp,sub_menugc,GXcopy);
        if(font_flg == TRUE){
          XSetFont(disp,sub_menugc,font);
        }
	atr.save_under = True;
	XChangeWindowAttributes(disp,sub_menuwin,CWSaveUnder,&atr);
	XMapRaised(disp,sub_menuwin);
	looping = 0;
	show_setting_menu(invert_num);
	XWarpPointer(disp,None,sub_menuwin,0,0,0,0,100,40);
	cnt = 0;
	while(looping == 0){
		if(XEventsQueued(disp,QueuedAfterReading)==0){
			XFlush(disp);
		}
		XNextEvent(disp,&ev);

		switch(ev.type){
		case MotionNotify:
			if(ev.xmotion.subwindow != sub_menuwin){
				looping = 1;
			}
			break; 
		case ButtonPress:
			setting_menu_act(invert_num);        
			break;

		default:
			break;
		}
	}
	XFreeGC(disp,sub_menugc);
	XDestroyWindow(disp,sub_menuwin);
}      

/*------------------------------------------------------------

  Function : show_setting_menu(int)

-------------------------------------------------------------*/
show_setting_menu(invert_num)
int invert_num;
{
	int i,num;
	char text_buffer[20];

	XClearWindow(disp,sub_menuwin);
	switch(invert_num){
	case 0:
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,346,246);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,342,242);
		XDrawString(disp,sub_menuwin,sub_menugc,10,30,"* show coordinate",
		strlen("* show coordinate"));
		XDrawString(disp,sub_menuwin,sub_menugc,10,60,"* show unit ball",
		strlen("* show unit ball"));
		XDrawString(disp,sub_menuwin,sub_menugc,10,90,"* render",
		strlen("* render"));
		XDrawString(disp,sub_menuwin,sub_menugc,10,120,"* drawing pattern",
		strlen("* drawing pattern"));
		XDrawString(disp,sub_menuwin,sub_menugc,20,150,
		"1:Hidden lines are drawn by solid lines",
		strlen("1:Hidden lines are drawn by solid line"));
		XDrawString(disp,sub_menuwin,sub_menugc,20,175,
		"2:Hidden lines are drawn by dotted lines",
		strlen("2:Hidden lines are drawn by dotted lines"));
		XDrawString(disp,sub_menuwin,sub_menugc,20,200,
		"3:Hidden lines are not drawn",
		strlen("3:Hidden lines are not drawn"));

		XDrawString(disp,sub_menuwin,sub_menugc,20,225,
		"4:Every lines are not drawn",
		strlen("4:Every lines are not drawn"));

		for(i=0;i<3;i++){
			draw_button(sub_menuwin,sub_menugc,190,10+30*i,45,21,
			200,28+30*i,"YES");
			draw_button(sub_menuwin,sub_menugc,265,10+30*i,45,21,
			275,28+30*i,"N O");

		}

		if(disp_coord_flg == TRUE){
			draw_inv_str(sub_menuwin,sub_menugc,ON,192,12,42,18,
			200,28,"YES");
		}
		else{
			draw_inv_str(sub_menuwin,sub_menugc,ON,267,12,42,18,
			275,28,"N O");
		}
		if(disp_unit_flg == TRUE){
			draw_inv_str(sub_menuwin,sub_menugc,ON,192,42,42,18,
			200,58,"YES");
		}
		else{
			draw_inv_str(sub_menuwin,sub_menugc,ON,267,42,42,18,
			275,58,"N O");
		}
		if(shadow_flg == ON){
			draw_inv_str(sub_menuwin,sub_menugc,ON,192,72,42,18,
			200,88,"YES");
		}
		else{
			draw_inv_str(sub_menuwin,sub_menugc,ON,267,72,42,18,
			275,88,"N O");
		}
		for(i = 0;i<4;i++){
			draw_button(sub_menuwin,sub_menugc,190+35*i,105,27,25,
			200+35*i,122," ");
		}
		draw_inv_str(sub_menuwin,sub_menugc,draw_pattern == 1,192,107,24,22,
		200,122,"1");
		draw_inv_str(sub_menuwin,sub_menugc,draw_pattern == 2,227,107,24,22,
		235,122,"2");
		draw_inv_str(sub_menuwin,sub_menugc,draw_pattern == 3,262,107,24,22,
		270,122,"3");
		draw_inv_str(sub_menuwin,sub_menugc,draw_pattern == 4,297,107,24,22,
		305,122,"4");

		break;

	case 1:
		XClearWindow(disp,sub_menuwin);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,296,96);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,292,92);
		XDrawString(disp,sub_menuwin,sub_menugc,10,30,"rotation angle---",
		strlen("rotation angle---"));
		draw_button(sub_menuwin,sub_menugc,20,58,35,22,
		30,75,"-10");
		draw_button(sub_menuwin,sub_menugc,63,58,35,22,
		73,75,"-5");
		draw_button(sub_menuwin,sub_menugc,106,58,35,22,
		116,75,"-1");
		draw_button(sub_menuwin,sub_menugc,149,58,35,22,
		159,75,"+1");
		draw_button(sub_menuwin,sub_menugc,192,58,35,22,
		202,75,"+5");
		draw_button(sub_menuwin,sub_menugc,235,58,35,22,
		245,75,"+10");
		i=rotation_angle;
		sprintf(text_buffer,"%d",i);
		draw_inv_str(sub_menuwin,sub_menugc,ON,135,14,25,20,140,30,text_buffer);
		sprintf(text_buffer,"degree");
		XDrawString(disp,sub_menuwin,sub_menugc,170,30,text_buffer
		    ,strlen(text_buffer));
		break;

	case 2:
		XClearWindow(disp,sub_menuwin);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,296,96);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,292,92);
		XDrawString(disp,sub_menuwin,sub_menugc,80,30,"<< magnification >>",
		strlen("<< magnification >>"));
		for(i = 0;i<5;i++){
			draw_button(sub_menuwin,sub_menugc,20 + 50*i,58,38,20,
			30 + 50*i,75," ");
		}
		num = (int)(log(magnification)/log(2.0));
		draw_inv_str(sub_menuwin,sub_menugc,num == 0,22,60,35,17,30,75,"1x");
		draw_inv_str(sub_menuwin,sub_menugc,num == 1,72,60,35,17,80,75,"2x");
		draw_inv_str(sub_menuwin,sub_menugc,num == 2,122,60,35,17,130,75,"4x");
		draw_inv_str(sub_menuwin,sub_menugc,num == 3,172,60,35,17,180,75,"8x");
		draw_inv_str(sub_menuwin,sub_menugc,num == 4,222,60,35,17,230,75,"16x");
		break;

	default:
		break;
	}
}

/*------------------------------------------------------------

  Function : setting_menu_act(int)

-------------------------------------------------------------*/
setting_menu_act(invert_num)
int invert_num;
{
	int i;
	char text_buffer[10];
	switch(invert_num){
	case 0:
		if((ev.xbutton.y > sub_menuhint.y+10)&&(ev.xbutton.y<sub_menuhint.y+35)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+235)
			    &&(disp_coord_flg == FALSE)){
				disp_coord_flg = TRUE;
				draw_inv_str(sub_menuwin,sub_menugc,ON,192,12,42,18,
				200,28,"YES");
				draw_inv_str(sub_menuwin,sub_menugc,OFF,267,12,42,18,
				275,28,"N O");
				XClearWindow(disp,drawin);
				show_object(0);
			}
			else{
				if((ev.xbutton.x>sub_menuhint.x+265)&&(ev.xbutton.x<sub_menuhint.x+310)
				    &&(disp_coord_flg == TRUE)){
					disp_coord_flg = FALSE;
					draw_inv_str(sub_menuwin,sub_menugc,OFF,192,12,42,18,
					200,28,"YES");
					draw_inv_str(sub_menuwin,sub_menugc,ON,267,12,42,18,
					275,28,"N O");
					XClearWindow(disp,drawin);
					show_object(0);
				}
			}
			return;
		}
		if((ev.xbutton.y > sub_menuhint.y+40)&&(ev.xbutton.y<sub_menuhint.y+65)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+235)
			    &&(disp_unit_flg == FALSE)){
				disp_unit_flg = TRUE;
				draw_inv_str(sub_menuwin,sub_menugc,ON,192,42,42,18,
				200,58,"YES");
				draw_inv_str(sub_menuwin,sub_menugc,OFF,267,42,42,18,
				275,58,"N O");
				XClearWindow(disp,drawin);
				show_object(0);
			}
			else{
				if((ev.xbutton.x>sub_menuhint.x+265)&&(ev.xbutton.x<sub_menuhint.x+310)
				    &&(disp_unit_flg == TRUE)){
					disp_unit_flg = FALSE;
					draw_inv_str(sub_menuwin,sub_menugc,OFF,192,42,42,18,
					200,58,"YES");
					draw_inv_str(sub_menuwin,sub_menugc,ON,267,42,42,18,
					275,58,"N O");
					XClearWindow(disp,drawin);
					show_object(0);
				}
			}
			return;
		}
		if((ev.xbutton.y > sub_menuhint.y+70)&&(ev.xbutton.y<sub_menuhint.y+95)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+235)
			    &&(shadow_flg == OFF)){
				shadow_flg = ON;
				draw_inv_str(sub_menuwin,sub_menugc,ON,192,72,42,18,
				200,88,"YES");
				draw_inv_str(sub_menuwin,sub_menugc,OFF,267,72,42,18,
				275,88,"N O");
				XClearWindow(disp,drawin);
				show_object(0);
			}
			else{
				if((ev.xbutton.x>sub_menuhint.x+265)&&(ev.xbutton.x<sub_menuhint.x+310)
				    &&(shadow_flg == ON)){
					shadow_flg = OFF;
					draw_inv_str(sub_menuwin,sub_menugc,OFF,192,72,42,18,
					200,88,"YES");
					draw_inv_str(sub_menuwin,sub_menugc,ON,267,72,42,18,
					275,88,"N O");
					XClearWindow(disp,drawin);
					show_object(0);
				}
			}
			return;
		}
		if((ev.xbutton.y > sub_menuhint.y+100)&&(ev.xbutton.y<sub_menuhint.y+130)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+220)
			    &&(draw_pattern!=1)){
				draw_pattern = 1;
				show_setting_menu(0);
				XClearWindow(disp,drawin);
				show_object(0);
			}
			if((ev.xbutton.x>sub_menuhint.x+225)&&(ev.xbutton.x<sub_menuhint.x+255)
			    &&(draw_pattern!=2)){
				draw_pattern = 2;
				show_setting_menu(0);
				XClearWindow(disp,drawin);
				show_object(0);
			}
			if((ev.xbutton.x>sub_menuhint.x+260)&&(ev.xbutton.x<sub_menuhint.x+290)
			    &&(draw_pattern!=3)){
				draw_pattern = 3;
				show_setting_menu(0);
				XClearWindow(disp,drawin);
				show_object(0);
			}
			if((ev.xbutton.x>sub_menuhint.x+295)&&(ev.xbutton.x<sub_menuhint.x+325)
			    &&(draw_pattern!=4)){
				draw_pattern = 4;
				show_setting_menu(0);
				XClearWindow(disp,drawin);
				show_object(0);
			}
		}
		break;

	case 1:
		if((ev.xbutton.y > sub_menuhint.y+58)&&(ev.xbutton.y<sub_menuhint.y+78)){
			if((ev.xbutton.x>sub_menuhint.x+20)&&(ev.xbutton.x<sub_menuhint.x+58)){
				rotation_angle -= 10.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+63)&&(ev.xbutton.x<sub_menuhint.x+101)){
				rotation_angle -= 5.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+106)&&(ev.xbutton.x<sub_menuhint.x+144)){
				rotation_angle -= 1.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+149)&&(ev.xbutton.x<sub_menuhint.x+187)){
				rotation_angle += 1.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+192)&&(ev.xbutton.x<sub_menuhint.x+230)){
				rotation_angle += 5.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+235)&&(ev.xbutton.x<sub_menuhint.x+273)){
				rotation_angle += 10.0;
			}
			if(rotation_angle >90.0){
				rotation_angle = 90.0;
			}
			if(rotation_angle <0.0){
				rotation_angle = 0.0;
			}
			i=rotation_angle;
			show_setting_menu(invert_num);

		}
		break;


	case 2:
		if((ev.xbutton.y > sub_menuhint.y+58)&&(ev.xbutton.y<sub_menuhint.y+78)){
			if((ev.xbutton.x>sub_menuhint.x+20)&&(ev.xbutton.x<sub_menuhint.x+60)
			    &&(magnification != 1.0)){
				magnification = 1.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+70)&&(ev.xbutton.x<sub_menuhint.x+110)
			    &&(magnification != 2.0)){
				magnification = 2.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+120)&&(ev.xbutton.x<sub_menuhint.x+160)
			    &&(magnification != 4.0)){
				magnification = 4.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+170)&&(ev.xbutton.x<sub_menuhint.x+210)
			    &&(magnification != 8.0)){
				magnification = 8.0;
			}
			if((ev.xbutton.x>sub_menuhint.x+230)&&(ev.xbutton.x<sub_menuhint.x+270)
			    &&(magnification != 16.0)){
				magnification = 16.0;
			}
			show_setting_menu(invert_num);
			XClearWindow(disp,drawin);
			show_object(0);
		}
		break;


	default:
		break;
	}
}



