/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  menubar.c: Function for menubar window.                      */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <stdio.h>   
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <string.h>
#include "source/Hcad.h"

#include "source/Hcadext.h"

/*------------------------------------------------------------

  Function : set_menu()

-------------------------------------------------------------*/
set_menu(){
	int i;

	XClearWindow(disp,menubar);
	for(i = 0;i<MENU_MAX;i++){
		XDrawString(disp,menubar,menubargc,100*i+30,20,menu_name[i],strlen(menu_name[i]));
	}
}


/*------------------------------------------------------------

  Function : menu_task()

-------------------------------------------------------------*/
menu_task(menum)
int menum;
{

	int looping,max_menu,invert_num,invert_back;
	char *name[7];
	int i;
	XSetWindowAttributes  atr;

	menuhint.x = 100*menum;
	if(menum == 0){
		menuhint.x = 20;
	}
	if(menum == 7){
		menuhint.x = 620;
	}

	menuhint.y = 35;
	menuhint.width = 155;
	menuhint.height = 20*SUBMENU_MAX + 5;
	menuhint.flags = PPosition | PSize;


	max_menu = menuhint.height / 20;
	invert_num = max_menu + 5;

	menuwin = XCreateSimpleWindow(disp,basewin,menuhint.x,menuhint.y,menuhint.width,
	menuhint.height,2,black,white);
	menugc = XCreateGC(disp,menuwin,0,0);
	XSetBackground(disp,menugc,white);
	XSetForeground(disp,menugc,black);
	XSetFunction(disp,menugc,GXcopy);
        if(font_flg == TRUE){
          XSetFont(disp,menugc,font);
        }
	atr.save_under = True;
	XChangeWindowAttributes(disp,menuwin,CWSaveUnder,&atr);
	XMapRaised(disp,menuwin);
	looping = 0;
	for(i = 0; i < SUBMENU_MAX; i++){
		XDrawString(disp,menuwin,menugc,10,15+20*i,submenu_name[menum][i]
		    ,strlen(submenu_name[menum][i]));
	}
	XFillRectangle(disp,menuwin,menugc,150,0,5,5);
	XFillRectangle(disp,menuwin,menugc,150,7,3,menuhint.height - 12);
	XFillRectangle(disp,menuwin,menugc,0,menuhint.height - 5,5,5);
	XFillRectangle(disp,menuwin,menugc,7,menuhint.height - 5,146,3);

	XWarpPointer(disp,None,menuwin,0,0,0,0,50,50);
	invert_num = 2;
	draw_inv_str(menuwin,menugc,ON,2,invert_num*20,145,20,
	10,15+20*invert_num,submenu_name[menum][invert_num]);
	while(looping == 0){
		if(XEventsQueued(disp,QueuedAfterReading)==0){
			XFlush(disp);
		}
		XNextEvent(disp,&ev);

		switch(ev.type){
		case MotionNotify:
			if(ev.xmotion.subwindow != menuwin){
				looping = 1;
			}
			else{
				if(invert_num!=(ev.xmotion.y - 35) / 20){
					if(invert_num < max_menu){
						draw_inv_str(menuwin,menugc,OFF,2,invert_num*20,145,20,
						10,15+20*invert_num,submenu_name[menum][invert_num]);
					}
					invert_num = (ev.xmotion.y - 35) / 20;
					if(invert_num < max_menu){
						draw_inv_str(menuwin,menugc,ON,2,invert_num*20,145,20,
						10,15+20*invert_num,submenu_name[menum][invert_num]);
					}
				}
			}
			break;
		case ButtonPress:
			switch(menum){
			case 0:
				file_menu(invert_num);
				break;

			case 1:
				data_menu(invert_num);
				break;

			case 2:
				print_menu(invert_num);
				break;

			case 3:
				select_menu(invert_num);
				break;

			case 4:
				help_menu(invert_num);
				break;

			case 5:
				demo_menu(invert_num);
				break;

			case 7:
				setting_menu(invert_num);
				if(invert_num == 3){
					looping = 1;
					continue;
				}
				break;

			default:
				break;
			}
			XClearWindow(disp,menuwin);
			for(i = 0; i < SUBMENU_MAX; i++){
				XDrawString(disp,menuwin,menugc,10,15+20*i,submenu_name[menum][i]
				    ,strlen(submenu_name[menum][i]));
			}
			XDrawLine(disp,menuwin,menugc,150,0,150,menuhint.height - 5);
			XDrawLine(disp,menuwin,menugc,0,menuhint.height - 5,150,menuhint.height - 5);
			XFillRectangle(disp,menuwin,menugc,150,0,5,5);
			XFillRectangle(disp,menuwin,menugc,150,7,3,menuhint.height - 12);
			XFillRectangle(disp,menuwin,menugc,0,menuhint.height - 5,5,5);
			XFillRectangle(disp,menuwin,menugc,7,menuhint.height - 5,146,3);
			invert_num = max_menu + 5;
			break;
		default :
			break;
		}
	}
	XFreeGC(disp,menugc);
	XDestroyWindow(disp,menuwin);
	if(disp_coord_flg == TRUE){
		show_coordinate(0);
	}
	if(disp_unit_flg == TRUE){ 
		show_unit_ball(0);
	}
	if((menum == 7)&&(invert_num == 3)){
		show_object(0);
	}
}


