/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  Hcad.h: Header file for defines and structs.                 */
/*                                                               */
/*                                                               */
/*****************************************************************/

#define PLANE_MAX   100
#define CROSS_MAX   60
#define LINE_MAX    300
#define MENU_MAX    8
#define SUBMENU_MAX 7
#define NAME_MAX    1024
#define FALSE       0
#define TRUE        1
#define INSIDE      2
#define OUTSIDE     0
#define PIE         3.1415926535897
#define LIMIT       100.0
#define ON          1
#define OFF         0
#define DR          300.0
#define PDR         2000.0
#define DX          400
#define DY          345
#define PDX         2900
#define PDY         3800
#define SELECT_WID  3
#define NONSELECT   0
#define ZERO  10.0E-10


/* Structure for a point */
typedef struct{
	double x;
	double y;
	double z;
}
HPoint;

/* Structure for a line */
typedef struct{
	int id;   /* line id */
	int id1;  /* plane id1 */
	int id2;  /* plane id2 */
	int pnum; /* the number of divided points */
	double length;
	double angle;
	double pr;
	HPoint pc; 
	HPoint bip[17];
}
HLine;


/**************************************************************/
/*  Structure for a hyperbolic plane                          */
/*                                                            */
/*     id        : plane id                                   */
/*     side      : inside or outside                          */
/*     x         :                                            */
/*     y         :                                            */
/*     z         :                                            */
/*     cross     : search_cross() use this                    */
/**************************************************************/


typedef struct{
	int id;
	int side;
	double x;
	double y;
	double z;
	double r;
	int cross[CROSS_MAX];
}
HPlane;
/********************** option **********************************/

typedef struct{
	int angle[6];
	int reflection[4];
}
apollo_data;

typedef struct{
	int num;
	int x;
	int y;
	int width;
	int height;
	char name[20];
}
button_type;

