/* This program creates a GL object to represent the eye, with an iris
   and a pupil...the object is then rendered into the face,

   pupil dilation and eye orietation are incorporated 

   STeve Franks
   Sony Computer Science Lab	Tokyo 

*/

#include <malloc.h>
#include <math.h>
#include <gl/gl.h>
#include <gl/device.h>
#include <sphere.h>
#include <forms.h>
#include "standard.h"
#include "proto.h"
#include "lights.h"

#define PI 3.1415926
    
#define RAD_DIV	16
#define PUPIL_DIV  4.0
#define IRIS_DIV	6
#define WHITE_DIV	6

/* static so it doesn't use the one in graphics.c or anyplace else
   by mistake */

static void calc_eye_normal(float *,float*,float *,float *);
extern	eye_info	iball;	

/* note: because innvalid parameters cause a bus dump, esp if puppil is larger 
than iris etc.. I am changing the meaning of pup_rad and iris_rad to be
percentages, ie. pup_rad=.50 means 1/2 the size of the iris
the iris is defined in relation to the eyeball.
*/

Object make_eye_object()
{

    Object	eye;
    float	pup_rad,iris_rad,white_rad;
    float	cent[3];
    float	p[16][16][3]; 	/* for the iris and eyewhite */
    float	nrml[16][16][3]; /* normals for the eye */
    float	phi,theta;
    float	center_nrml[3];
    
    int		i,j,i_mindx,j_mindx;
    float	k;
    float	st,fin,inc;
    int		phi_indx, theta_indx;

    white_rad = 1.0;	/* not really radius, but how much of spehre to make*/
    iris_rad = (iball.iris * white_rad); 
    pup_rad =  (iball.pupil* iris_rad);
  

    if (DEBUGGING)
      printf("Creating Eye with Pupil Size %5.3f \t Iris Size %5.3f \n",
	     pup_rad,iris_rad);
     
  
    cent[0] = 0.0;
    cent[1] = 0.0;
    cent[2] = 1.0;	/* work with unit eye */
  
    center_nrml[0] = 0;
    center_nrml[1] = 0;
    center_nrml[2] = 1.0;	/* should this be -1 ? */


    makeobj(eye=genobj());


    /*************************** PUPIL	*****************************/

    st = 0.025;
    fin = pup_rad;
    inc = (fin-st)/PUPIL_DIV;
    
    phi_indx = theta_indx = 0;

    for (theta = st; theta<=fin+inc; theta+= inc) {
	k = fsqrt(1.0-theta * theta); 
	for (phi=0; phi< 2.0*PI; phi+= 2.0*PI/RAD_DIV) {
	    p[theta_indx][phi_indx][0] = theta * fcos(phi);
	    p[theta_indx][phi_indx][1] = theta * fsin(phi);
	    p[theta_indx][phi_indx][2] = k ; 
	    phi_indx++;
	}
	theta_indx++;
	phi_indx = 0;
    }
    i_mindx = PUPIL_DIV-1;
    j_mindx = RAD_DIV-1;
    for (i = 0 ; i <=i_mindx+1; i++) {
	for (j=0;j<=j_mindx; j++) {
	    calc_eye_normal(p[i][j],p[i+1][j],p[i][(j+1)%RAD_DIV],nrml[i][j]);
	}
    }


    lmbind(MATERIAL,PUPIL_MAT);

    for (j=0; j<=j_mindx; j++) {/* add triangles from (0,0) to first band*/
	bgnpolygon();
	n3f(center_nrml);
	v3f(cent);
	n3f(nrml[0][j]);
	v3f(p[0][j]);
	n3f(nrml[0][(j+1)%RAD_DIV]);
	v3f(p[0][(j+1)%RAD_DIV]);
	endpolygon();
	
    }
    
    for (i=0; i<=i_mindx; i++)
      for (j=0; j<=j_mindx; j++) {
	  bgnpolygon();
	  n3f(nrml[i][j]);
	  v3f(p[i][j]);
	  n3f(nrml[i+1][j]);
	  v3f(p[i+1][j]);
	  n3f(nrml[i+1][(j+1)%16]);
	  v3f(p[i+1][(j+1)%16]);
	  n3f(nrml[i][(j+1)%16]);
	  v3f(p[i][(j+1)%16]);
	  endpolygon();
      }


 /*************************** IRIS	*****************************/
  
    st = pup_rad;
    fin = iris_rad;
    inc = (fin-st)/IRIS_DIV;
    
    
    theta_indx = phi_indx = 0;
    for (theta = st; theta<=fin+inc; theta+= inc) {
	k = fsqrt(1.0-theta * theta); 
	for (phi=0; phi< 2*PI; phi+= 2.0*PI/RAD_DIV) { 
       	    p[theta_indx][phi_indx][0] = theta * fcos(phi);
	    p[theta_indx][phi_indx][1] = theta * fsin(phi);
	    p[theta_indx][phi_indx][2] = k ; 
	    phi_indx++;
	}
	phi_indx = 0;
	theta_indx++;
    }


    i_mindx = IRIS_DIV-1; 
    j_mindx = RAD_DIV-1;

    for (i = 0 ; i <=i_mindx+1; i++) {
	for (j=0;j<=j_mindx; j++) {
	    calc_eye_normal(p[i][j],p[i+1][j],p[i][(j+1)%RAD_DIV],nrml[i][j]);
	}
    }


    lmbind(MATERIAL,IRIS_MAT);
    for (i=0; i<=i_mindx; i++)
      for (j=0; j<=j_mindx; j++) {
	  /* should bind the correct material here */
	  bgnpolygon();
	  n3f(nrml[i][j]);
	  v3f(p[i][j]);
	  n3f(nrml[i+1][j]);
	  v3f(p[i+1][j]);
	  n3f(nrml[i+1][(j+1)%RAD_DIV]);
	  v3f(p[i+1][(j+1)%RAD_DIV]);
	  n3f(nrml[i][(j+1)%RAD_DIV]);
	  v3f(p[i][(j+1)%RAD_DIV]);
	  endpolygon();
      }

	  
 /*************************** EYEWHITE	*****************************/

    st = iris_rad;
    fin = white_rad;
    inc = (fin-st)/WHITE_DIV;
    theta_indx = phi_indx = 0;
    for (theta = st; theta<=fin; theta+= inc) {
	k = fsqrt(1.0- (theta * theta) ); 
	for (phi=0; phi< 2*PI; phi+= 2.0*PI/(float)RAD_DIV) { 
       	    p[theta_indx][phi_indx][0] = theta * fcos(phi);
	    p[theta_indx][phi_indx][1] = theta * fsin(phi);
	    p[theta_indx][phi_indx][2] = k ; 
	    phi_indx++;
	}
	theta_indx++;
	phi_indx=0;
    }


    i_mindx = WHITE_DIV; 
    j_mindx = RAD_DIV; 

    for (i = 0 ; i <=i_mindx; i++) {
	for (j=0;j<=j_mindx; j++) {
	    calc_eye_normal(p[i][j],p[i+1][j],p[i][(j+1)%RAD_DIV],nrml[i][j]);
	}
    }


    lmbind(MATERIAL,EYEW_MAT);
    for (i=0; i<i_mindx-1; i++)
      for (j=0; j<j_mindx; j++) {
	  /* should bind the correct material here */
	  bgnpolygon();
	  n3f(nrml[i][j]);
	  v3f(p[i][j]);
	  n3f(nrml[i+1][j]);
	  v3f(p[i+1][j]);
	  n3f(nrml[i+1][(j+1)%RAD_DIV]);
	  v3f(p[i+1][(j+1)%RAD_DIV]);
	  n3f(nrml[i][(j+1)%RAD_DIV]);
	  v3f(p[i][(j+1)%RAD_DIV]);
	  endpolygon();
      }
    closeobj();
    return(eye);
}





/*** void calc_eye_normal ***/
static void calc_eye_normal(float *a,float *b,float *c,float *dest)
{


    float	v[3],w[3];
    int	vtx1,vtx2,vtx3;
   
    v[0] = b[0] - a[0]; 
    v[1] = b[1] - a[1]; 
    v[2] = b[2] - a[2]; 
    
    w[0] = c[0] - a[0];
    w[1] = c[1] - a[1];
    w[2] = c[2] - a[2];
    
    dest[0] = v[1]*w[2] - v[2]*w[1];
    dest[1] = v[2]*w[0] - v[0]*w[2];
    dest[2] = v[0]*w[1] - v[1]*w[0];
  
}



/*** plot_eyelids -- add eyelids over the eyes ***/
void	plot_eyelids(float open_ang)
{

    extern float *face;
    int	i;
      
    /* OK - we will assume that the eyes are spheres, so if oppisite
       vertexes on the socket are considered on the surface of the sphere
       the intermediate vertexes connected should be > sphere level.

       as a first test just add 1 high vertex, eventually make the
       lids an object which is rotated to blink.
       */

    typedef  struct	 {
	float	x,y,z;
    }pnt;


    pnt  lid[13+6];	/* 6 intermediate nodes as a test */
 
    return;
    /* First copy over vertexes for private use */

    lid[0].x = 32767;

    bcopy(&face[163*3-2],&lid[0],sizeof(float)*3);
    bcopy(&face[209*3-2],&lid[1],sizeof(float)*3);
    bcopy(&face[249*3-2],&lid[2],sizeof(float)*3);
    bcopy(&face[279*3-2],&lid[3],sizeof(float)*3);
    bcopy(&face[323*3-2],&lid[4],sizeof(float)*3);
    bcopy(&face[343*3-2],&lid[5],sizeof(float)*3);
    bcopy(&face[371*3-2],&lid[6],sizeof(float)*3);
    bcopy(&face[361*3-2],&lid[7],sizeof(float)*3);
    bcopy(&face[327*3-2],&lid[8],sizeof(float)*3);
    bcopy(&face[293*3-2],&lid[9],sizeof(float)*3);
    bcopy(&face[255*3-2],&lid[10],sizeof(float)*3);
    bcopy(&face[221*3-2],&lid[11],sizeof(float)*3);
    bcopy(&face[173*3-2],&lid[12],sizeof(float)*3);

    for (i=1;i<7;i++) {
	lid[12+i].x = (lid[i].x + lid[13-i].x)/2.0;
	lid[12+i].y = (lid[i].y + lid[13-i].y)/2.0;
	/* make the z+constant dependent on radius of eyeball */
	/* and how far from the center you are */
	lid[12+i].z = (lid[i].z + lid[13-i].z)/2.0+.5;
    }


    /* The lid will be rotateed about an axis connecting point 0
       with point #6 */

    /* and assume the center point of the eye is the center
       of the square 3-4-9-10 , the "hite" of the eye at the center point
       can be "computed" by the eye-position and eye-radius? */
    
    lmbind(MATERIAL,SKIN);
    bgntmesh();
    v3f(&lid[0]);
    v3f(&lid[1]);
    v3f(&lid[13]);
    v3f(&lid[2]);
    v3f(&lid[14]);
    v3f(&lid[3]);
    v3f(&lid[15]);
    v3f(&lid[4]);
    v3f(&lid[16]);
    v3f(&lid[5]);
    v3f(&lid[17]);
    v3f(&lid[6]);
    v3f(&lid[18]);
    v3f(&lid[7]);

    v3f(&lid[17]);
    v3f(&lid[8]);
    v3f(&lid[16]);
    v3f(&lid[9]);
    v3f(&lid[15]);
    v3f(&lid[10]);
    v3f(&lid[14]);
    v3f(&lid[11]);
    v3f(&lid[13]);
    v3f(&lid[12]);
    v3f(&lid[0]);
    endtmesh();
    

    /* A quick test to see what it looks like */
    for (i=0;i<19; i++)
      lid[i].x = (-lid[i].x);

    cpack(0xFFFFFF);
    bgntmesh();
    v3f(&lid[0]);
    v3f(&lid[1]);
    v3f(&lid[13]);
    v3f(&lid[2]);
    v3f(&lid[14]);
    v3f(&lid[3]);
    v3f(&lid[15]);
    v3f(&lid[4]);
    v3f(&lid[16]);
    v3f(&lid[5]);
    v3f(&lid[17]);
    v3f(&lid[6]);
    v3f(&lid[18]);
    v3f(&lid[7]);

    v3f(&lid[17]);
    v3f(&lid[8]);
    v3f(&lid[16]);
    v3f(&lid[9]);
    v3f(&lid[15]);
    v3f(&lid[10]);
    v3f(&lid[14]);
    v3f(&lid[11]);
    v3f(&lid[13]);
    v3f(&lid[12]);
    v3f(&lid[0]);
    endtmesh();
    printf("Done Plotting the Experimental Eyelid \n");

}




