/** This contains all the IPC routines for use by both the client
  and server 
  IPC2.c is an InterNet version

  Steve Franks		Sony Computer Science Lab
  March 92
**/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <fcntl.h>

#define SERVER_PORT	(IPPORT_USERRESERVED + 124)

#include "IPC.h"
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>
#define NEW_VERSION

/*** setup_server_IPC -- setup the interprocess communication stuff ***/
int setup_server_IPC()
{
    
    int		sock,msgsock;
    struct sockaddr_un server;
    char 	buf[1024];
    char	com[50];
    int		pid,dpid;
   
    int length;
    struct sockaddr_in sin;
    
    /* create a socket */
    sock = socket (AF_INET,SOCK_STREAM,0);
    if (sock < 0) {
	perror("Error opening socket");
	exit(1);
    }
    
    
    /* initialize socket address structure */
    
    bzero((char *) &sin, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(SERVER_PORT);
    sin.sin_addr.s_addr = INADDR_ANY;
    
    /* bind socket data structure to this socket */
    
    if (bind (sock,&sin,sizeof(sin))) {
	perror("Error binding socket");
	close(sock);
	exit(1);
    }
    
    /* prepare socket queue for connection requests and accept
       connections */
 

while (1) {
  
    listen(sock,5);
    
    length = sizeof(sin);
    msgsock = accept(sock, &sin, &length);
    if (msgsock < 0) {
	perror("accept");
	close(sock);
	exit(1);
    }
    
    printf("Connection from host %s, port %u\n",
	   inet_ntoa(sin.sin_addr), ntohs(sin.sin_port));
    fflush(stdout);


    /* Here we want to fork and let the child continue.
       have the parent wait for the child to die, then loop back up to the
       listen/accept part */
    printf("Forking the Child Process \n");
    pid = fork();

    if (pid==-1) {
	printf("FATAL Error Forking a Facial Animation Process \n");
	perror();
	exit(-1);
    }

    if (pid !=0) { /* I am the parent process */
	/* SIGCLD - 18[2] death of a child signal */
	printf("waiting for the death of %d \n",pid);
	dpid = waitpid(pid,NULL,NULL);	/* wait for this child to die ! */
	printf("\07 received obit from %d \n",dpid);
    }
    else	/* I am the child so break out of this loop */
      break;
}

    close(sock);
    
    
    printf("Returning Socket #%d \n",msgsock);
    return(msgsock);
    
}	




/*** setup_client_IPC -- client IPC initialization ***/
int setup_client_IPC()
{
    
    
    int i;
    int sock;
    struct sockaddr_un server;
    char *hostname;
    struct hostent *hp;
    struct sockaddr_in sin;
    int msgsock;
    int length;
    
    
    hostname = "asura";
    
    /* create a socket */
    sock = socket (AF_INET,SOCK_STREAM,0);
    if (sock < 0) {
	perror("Error opening socket");
	exit(1);
    }
    
    
    /* initialize socket address structure */
    bzero((char *) &sin, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(SERVER_PORT);
    
    hp = gethostbyname(hostname);
    if (hp == NULL) {
	herror(hostname);
	exit(1);
    }
    bcopy (hp->h_addr, &(sin.sin_addr.s_addr), hp->h_length);
    
    /* connect to remote host */
    
    if (connect(sock,&sin,sizeof(sin)) < 0) {
	close(sock);
	perror("Can't connect to server");
	exit(1);
    }
    printf("Connection established\n");
    fflush(stdout);
    return(sock);
}	



/*** close_server_IPC() - server closes and cleans up the socket ***/
void close_server_IPC()
{


}



/*** send_data_packet -- put data over a Unix domain socket ***/
send_data_packet(int skt,packet_format *buff, int buff_siz)
{
    
    print_data_packet(buff);
    if (write(skt,buff,buff_siz) < 0) {
	perror("Client: Write on INET Socket");
    }


}



/*** receive_data_packet - receive data on a Unix socket ***/
int receive_data_packet(int skt,packet_format *buff, int buff_siz)
{

    int		cc,flags;

    bzero(buff,buff_siz);
    cc= read(skt,buff,buff_siz);
    if (cc==-1) {
	perror("Reading From  Port");
    }
  
    if (cc!=buff_siz) {
	printf("WARNING \07 \n");
	printf("Buffer Size = %d\n",buff_siz);
	printf("cc Read     = %d\n",cc);
	exit(0);
    }

/*    print_data_packet(buff); /* */
    return(cc);

}



/*** print_data_packet - debugging routine to peek a at packets ***/
print_data_packet(packet_format *d)
{
    int		i;

    printf("\n DATA PACKET \t %d\n",d->id);
    
    for (i=0;i<14; i++) {
	printf("%5.4f\t",d->param[i]);
    }
    printf("\n");
}


