/***
This code was written with time and equipment provided by Sony Computer
Science Lab. It is freely distributable for research purposes. 

It is hoped making this available will facilitate research on facial
animation. If you make significant changes/extensions to this, or have
a different system I would appreciate hearing about it.


The latest versions of this and other animation systems are
available by anonymous FTP from:
     
        scslwide.sony.co.jp
	ftp2/SGI/Facial-Animation

  Copyright 1992	

  Written:	Steve Franks
                Sony Computer Science Labs
		Tokyo, Japan	
		Febuary 1992
		stevef@csl.sony.co.jp


*******/
/* Main Pull3d Experimental Controller */

#include <forms.h>
#include "master_fl.h"
#include <gl/gl.h>
#include <gl/device.h>
#include <math.h>
#include <time.h>

#include "IPC.h"
#include "muscle.def"

packet_format 	dp;			/* Data packet define in IPC.h */
int		sckt;			/* INET Socket to send data over*/


main()
     
{
    FL_OBJECT	*obj;
  

    sckt = setup_client_IPC();
    printf("Connection Complete -- Socket #%d\n",sckt);


    /* Initialze the Data Array */
    dp.param[I_PUPL]	= 0.50;	
    dp.param[I_XDIR]	= 0.50; 
    dp.param[I_YDIR]	= 0.50; 
    dp.param[I_RAD] 	= 0.50;
    dp.param[I_DIST]	= 0.83;
    dp.param[I_XPOS]	= 0.71;
    dp.param[I_YPOS]	= 0.91;
    dp.param[I_ZPOS]	= 0.63;
    dp.param[I_ISIZ]	= 0.50;
    dp.param[XROT] = 0.5;
    dp.param[YROT] = 0.5;
    foreground();		/* bind to window for debugging */
    create_the_forms();		/* Initialize Forms */
    fl_show_form(cntrl_menu,FL_PLACE_MOUSE,TRUE,"Master Form");
    while (1) {
	printf("Test1 \n");
	obj = fl_do_forms(); 
    }

}


send_data()
{

    send_data_packet(sckt,&dp,sizeof( packet_format));

}


/*** musc_3d() -- callback from forms ***/
void musc_3d(FL_OBJECT *obj,long val)
{
    float	new_val;

    new_val = fl_get_slider_value(obj);
    dp.param[val] = new_val;
    
    send_data();
}


/*** musc-1d_dp.param -- callback from forms ***/
void musc_1d_param(FL_OBJECT *obj,long val)
{
    float	new_val;

    /* this needs a scale value of about .30 */
  	printf("1-D Muscle Value changed: %d\n",val);
	  new_val = fl_get_slider_value(obj);
    dp.param[val] = new_val;
    printf("New parameter %d = %5.4f \n",val,new_val);
    send_data();
}

/*** lip-param() -- callback from forms ***/
void lip_param(FL_OBJECT *obj,long val)
{
    float	new_val;

    new_val = fl_get_slider_value(obj);
    dp.param[val] = new_val; 
 send_data();
 

}


/*** mouth_param -- callback from forms ***/
void mouth_param(FL_OBJECT *obj,long val)
{	
    float	new_val;
    
    printf("Callback from %d \n",val);
    new_val = fl_get_slider_value(obj);
    if (val ==0)	dp.param[MOUTH] = (new_val * 5.0) -2.5;
/*    else if (val==1)	dp.param[?????] = new_val * 2.0;
 */   else if (val==2)  	dp.param[MOUTH] = (new_val *.450) - .225;
         
 send_data();
    
}

/* haircursor for head x and y rotation values */
void rotation_cb(FL_OBJECT *obj, long val)
{
    
	dp.param[XROT] = fl_get_positioner_yvalue(obj);
	dp.param[YROT] = fl_get_positioner_xvalue(obj);
    send_data();	
}
void	lighting_param(FL_OBJECT *obj,long val)
{

#define LITE_MINX	(-15.0)
#define LITE_MINY	(-15.0)
#define LITE_MINZ	(-15.0)
#define LITE_MAXX	(15.0)
#define LITE_MAXY	(15.0)
#define LITE_MAXZ	(15.0)
   
    static	float	xpos,ypos,zpos;
    static float lite_mod[] = {
	LCOLOR,		1  , 1,	  1,
	AMBIENT,	.4 , .4,  .4,
	POSITION, 	0.0, 0.0, 100.0, 0.0,
	SPOTDIRECTION,	0.0, 0.0, -1.0,
	SPOTLIGHT,	0.0, 180.0,
	LMNULL 
      };

    if (val==10) { /* crosshair for lite position */
	xpos = fl_get_positioner_yvalue(obj);
	ypos = fl_get_positioner_xvalue(obj);
	
	lite_mod[10] = ((LITE_MAXX-LITE_MINX) * xpos ) + LITE_MINX;
	lite_mod[11] = ((LITE_MAXY-LITE_MINY) * ypos ) + LITE_MINY;
    }
    
    if (val==11) { /* z-light coordinate */
	zpos = fl_get_slider_value(obj);
	lite_mod[12] = ((LITE_MAXZ-LITE_MINZ) * zpos) + LITE_MINZ;
    }

    
    
}


void	mater_param(FL_OBJECT *obj,long val)
{
    printf("material editor not yet implemented \n");
}


void	show_form(FL_OBJECT *obj,long val)
{
    int	new_val;
    new_val = fl_get_button(obj);	/* is is on or off now ? */

    if (new_val ==1) { /* Turn on/show the form */
	switch ((int) val) {
	  case 1:
	    break;
	    
	  case 2:
	    fl_show_form(eyeball_form,FL_PLACE_SIZE,FALSE,NULL);
	    break;
	    
	  case 3:
	    fl_show_form(master_form,FL_PLACE_SIZE,FALSE,NULL);
	    break;
	    
	  case 4:
	    fl_show_form(light_control,FL_PLACE_SIZE,FALSE,NULL);
	    break;
	    
	}
    }

    if (new_val==0) { /* turn off or hide the form */
	
	switch ((int) val) {
	  case 1:
	    break;
	    
	  case 2:
	    fl_hide_form(eyeball_form);
	    break;
	    
	  case 3:
	    fl_hide_form(master_form);
	    break;
	    
	  case 4:
	    fl_hide_form(light_control); 
	    break;
	}
    }

}



/*** eye_val -- callback to change the eye parameters ***/
void eye_val(FL_OBJECT *obj, long val)
{

    float       new_val;

    printf("Eyeval callback: Object = %d  \t val = %d \n",obj,val);
    new_val = fl_get_slider_value(obj);

    switch ((int)val) {
      case 1:   /* change the pupil dilation */
        printf("Pupil change \n");
       
        if ((new_val<=0.05) || (new_val > .99)) {
            new_val = fabs((double)(new_val-.075));
        }
        dp.param[I_PUPL]  = new_val;
        break;

      case 2:   /* xrotation */
        dp.param[I_XDIR] = (new_val-0.50) ; /* -70 to + 70 */
        break;

      case 3:   /* y-rotation */
        dp.param[I_YDIR] = (new_val-0.50) ; /* -70 to + 70 */
        break;

      case 4:   /* iris size */
	if ((new_val<=0.05) || (new_val > .99)) 
           new_val = fabs((double) (new_val- 0.075));
	
	dp.param[I_ISIZ] = new_val;
	break;


      case 5:   /* distance between eyeballs */
        dp.param[I_DIST] = new_val * 5.0; /* scale factor ? */
        break;

      case 6:   /* xposition of left eyeball */
        dp.param[I_XPOS]	 = new_val * 3.0;
        break;

      case 7:   /* yposition of left eyeball */
	dp.param[I_YPOS]	 = new_val * 3.0;
	break;

      case 8:   /* zposition of left eyeball */
	dp.param[I_ZPOS]	 = new_val * 10.0;
	break;

      case 9:
	dp.param[I_RAD]	 = new_val * 2.0;
	break;
    }
 send_data();


}





void	exit_session(FL_OBJECT *a,long b)
{
    printf("Exiting Gracefully..\n");
    exit(0);
}




