/*** Function Prototypes for the Single Layer Animation System ***/


/* alone.c */

void	event_loop();
void	monitor_loop(FL_OBJECT *,long);
void	play_file(FL_OBJECT *,long);
void 	redraw_face( );
void 	refresh_face(FL_OBJECT *,long );

void	exit_session(FL_OBJECT *,long);
void	option_param(FL_OBJECT *,long);
void	show_form(FL_OBJECT *,long);



/* eyes.c */
Object	make_eye_object();
void	calc_eye_normal(float *,float *,float *,float *);
void	plot_eyelids(float);


/* face.c */
float	*load_face_coor(char *);
int	*load_face_tconn(char *);
int	*load_face_qconn(char *);
int 	*load_jaw(char *);
int 	*load_lips(char *);
float	*load_skull_coor();
int	*load_skull_conn();


/* graphics.c */
long 	init_face_win();
void 	init_gl_env();
void	plot_face(long,float *,int *,int *,int *,float *,float *);
void 	cross_product(float *,int ,int,int,float *);
int	*assign_normals(int ,int *);
long 	init_msc_chart();
void	draw_msc_chart(long,struct muscle *);
void	plot_dynamic_muscles(long ,float *,struct muscle *);
void	plot_static_muscles(long );
void	plot_eyes(eye_info,Object);
void	calc_face_normals();
void	plot_face_normals(long,float *,int *,float *);
void	load_skull();
void	display_skull(long,float *,int *);


/* muscles.c */
void 	setup_muscles(char *,struct muscle *,float *);
void	init_sphinctor();
void	init_muscles();
void	init_params();
void	print_muscle(struct muscle *);



/* pick.c */

void	select_vertex(long,float *,float *);
int 	choose_vertex(long,float *);
int	choose_skull_vertex(long,float *);

/* pull.c */
void 	pull3d(float *, struct muscle ,float );
void	pull1d(float *, struct muscle ,float);
void 	sphincter(float *,struct sphinctor *);
void 	lip_sep(float *,int *,int *,float , float );
void	rot_jaw(float *,int *,float );


/* scrn_rot.c */

void	queue_keypad();
int	keypad_event(long ,short );


/* texture.c */
void load_texture(int ,char *);
float *bind_texture_coor(float *,char *);






/* gui.c */

void	eye_val(FL_OBJECT *, long);



