// This file contains routines to save "scenes" onto a disk and
// reload them later.

// Each file contains:
//	long	NUM_SPLINES
//	N SPLINE_RECORDS
// each SPLINE_RECORD is:
//	int	ID#		- which spline window associated with 
//	int	start,end	- starting and end frame numbers
//	int	num_pnts	- number of points in the spline
//	num_pnts POINTs
//
// each POINT is:
//	long/float? xpos,ypos


#ifndef _spline_lib.h
#define _spline_lib.h


#include "spline_ed.h"
#include <stdio.h>
#include <stream.h>
#include "debug.h"

typedef	spline_editor * spl_ed_pntr;
struct scene {
    int	num_splines;
    spl_ed_pntr *spls;
};

extern	spline_editor	*sp[20];


class	spline_lib {

  private:
    char	dir[50];
    char 	file[30];
    int		start,stop;		// start&stop frame
    FILE	*fd;

  public:
    spline_lib(char *);			// specify default directory
    spline_lib(void);

    void set_file(char *);			// set a file to work with
    void set_file();

    void set_frames(int st,int stp) {		// set editing "place"
	start = st;
	stop  = stp; }; 

    scene *load_scene(); 	
  
    int save_scene(winman *);			// save all splines
    int save_scene(winman *,int,int []);		// some with
    
};

    

#endif








