// This file has the rouintes to handle the FORM2.0 callbacks.

extern "C" {
#include <forms.h>
}
#include "test_forms.h"
#include "IPC.h"
#include <stdio.h>
#include <stream.h>
#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "debug.h"
#include "actor.h"

#include "winman.h"
#include "muscles.h"
#include "library.h"

extern	Winman		mngr; 
extern	int		skt;		// from main (test.cc)
 	packet_format	data;		// from IPC.h

static	int		preview;	// just used in callbacks

extern int create_muscle_scene(char *);

/*** board_cb ***/
void board_cb(FL_OBJECT *obj,long val)
{
    status("Board Callback Value",val);
   
    long cb;

    cb = mngr.curr_num();		// get the current board number
    switch ((int)val) {
       case 0:		// Preview/Edit Mode Switch
	status("Switching to Preview Mode");
	if (preview==FALSE) {
	    fl_show_form(preview_widget,FL_PLACE_MOUSE,TRUE,"Previewer");
	    preview=TRUE;
	}
	break;

      case 1:		// Close
	mngr.hide_board(cb);
	break;


      case 2:		// Open 
	mngr.show_board(cb);
	break;

      case 3:		// Pop Board 
	mngr.pop_board(cb);
	break;
	
      case 4:		// Push Board
	mngr.push_board(cb);
	break;

      case 5:		// Create Board
	char *name;
	status("Create A New Board");
	name = fl_show_input("Board Name","");
	if (strlen(name)<1){
	    status("\07 Not Creating New Board");
	}
	else
	  create_muscle_scene(name);
	
	break;


      case 61:
	mngr.plot_cursor(cb,-1);		// clear the cursor
	fl_hide_form(preview_widget);
	preview=FALSE;
	break;
    }
}




/*** evaluate_splines_cb ***/
void evaluate_splines_cb(FL_OBJECT *,long)
{
    static	int	cnt=0;
    long	bid;
    int		i;
    float	val[20]; 
    float	inc,xpos;

    inc = 10;
    data.param[I_PUPL]	= 0.50;	// these should be changable
    data.param[I_XDIR]	= 0.50; // "  "
    data.param[I_YDIR]	= 0.50; // "  "
    data.param[I_RAD] 	= 0.50;
    data.param[I_DIST]	= 0.83;
    data.param[I_XPOS]	= 0.71;
    data.param[I_YPOS]	= 0.91;
    data.param[I_ZPOS]	= 0.63;
    data.param[I_ISIZ]	= 0.50;
    
    bid = mngr.curr_num();
    if (bid==-1) {
	status("No Current Board to Evaluate");
	return();
    }

    float e_st,e_end;		// find the begining and ending xpos of scene
    mngr.get_range(bid,&e_st,&e_end);

    if (e_st<0.0) e_st = 0.0;

    status("Evaluating Board",mngr.b[bid]->scene_title);
    status("Evaluation Range",e_st,e_end); 
    status("Increment",inc);

    mngr.precompute(-1);	// precompute the evaluation coefficients
    
    for (i=0;i<20;i++) val[i]=0.0;

    status("Precompute Complete");
    for (xpos = e_st;xpos<= e_end;xpos+=inc) {

	data.id = cnt;
		
	for (i=0;i<mngr.b[bid]->num_act; i++) {
	    val[i] = mngr.b[bid]->obj[i]->get_value(xpos);
	    
	    // maybe just keep the last value if undefined
	    if (val[i]>1)
	      val[i]= 1.0;
	    else if (val[i]<0)
	      val[i]=0.0;
	}
	
	data.param[L_ZYGO] = 	data.param[R_ZYGO] 	=val[0]; 
	data.param[L_ANGULI] = 	data.param[R_ANGULI] 	=val[1];
	data.param[IL_FRONT] = 	data.param[IR_FRONT] 	=val[2];
	data.param[OL_FRONT] = 	data.param[OR_FRONT] 	=val[3];
	data.param[L_LABI] = 	data.param[R_LABI] 	=val[4];
	data.param[L_CORR] = 	data.param[R_CORR] 	=val[5];
	data.param[NASI] 				=val[6];
	data.param[LAT_CORR]  	 			=val[7];
	data.param[ML_FRONT] = 	data.param[MR_FRONT] 	=val[8];
	data.param[JAW]					=val[9];
	data.param[LIP_Z]				=val[10]; 
	data.param[LIP_Y]				=val[11];
	data.param[MOUTH]				=val[12];
	data.param[I_XDIR]				=val[13];
	data.param[I_YDIR]				=val[14];
	data.param[YROT]				=val[15];
	data.param[XROT]				=val[16];
	
	send_data_packet(skt,&data,sizeof(packet_format));
	cnt++;
    }
}


/*** save_scene_cb ***/
void  save_scene_cb(FL_OBJECT *,long)
{
    status("saving the current scene to disk");
    long	bid;
    
    bid = mngr.curr_num();
    if (save_scene(bid)!=-1) 
      status("Scene Saved.");
    else
      status("Scene NOT saved");

}


/*** load_scene_cb ***/
void load_scene_cb(FL_OBJECT *,long)
{

    long new_bid;

    // this loads a scene and replaces existing splines with it

    new_bid = load_scene((char *)NULL,666);
    
}


/*** append_scene_cb ***/
void append_scene_cb(FL_OBJECT *,long)
{
   
    int		i,n,m;

    status("Append Scene --Appends a pre-loaded scene to current scene");

    m= mngr.pick_board();
   
    if (m==-1) {
	return;
    }

    n= (int)mngr.curr_num();

    if (n==m) {
	status("Sorry -- Cannot Append a board to itself ");
	return;
    }

    mngr.b[n]->append_scene(mngr.b[m]);
    mngr.redraw_board(-1);		// redraw current board
    
    
}
 

/*** preview_cb -- for the preview slider ***/
void preview_cb(FL_OBJECT *obj,long )
{
    float	sv,xcoor;
    float	e_st,e_end,val[20];
    long	bid;
    int		i;

    for (i=0;i<20;i++) val[i]=0.0;
   
    sv=fl_get_slider_value(obj);
    bid = mngr.curr_num();		// get the current boards ID
    mngr.precompute(bid);
    
    mngr.get_range(bid,&e_st,&e_end);
    if (e_st<0.0) e_st = 0;

    xcoor = e_st + (sv * (e_end-e_st));
   

    // Draw the cursor in the correct position
    mngr.plot_cursor(bid,xcoor);	// optional cursor position

    status("Evaluating Board",mngr.b[bid]->scene_title);
    status("Evaluation Range",e_st,e_end); 
    status("Position",xcoor);

    
    data.id ++;
    data.param[I_PUPL]	= 0.50;	// these should be changable
    data.param[I_XDIR]	= 0.50; // "  "
    data.param[I_YDIR]	= 0.50; // "  "
    data.param[I_RAD] 	= 0.50;
    data.param[I_DIST]	= 0.83;
    data.param[I_XPOS]	= 0.71;
    data.param[I_YPOS]	= 0.91;
    data.param[I_ZPOS]	= 0.63;
    data.param[I_ISIZ]	= 0.50;
		
    for (i=0;i<mngr.b[bid]->num_act; i++) {
	val[i] = mngr.b[bid]->obj[i]->get_value(xcoor);
	
	// maybe just keep the last value if undefined
	if (val[i]>1)
	  val[i]= 1.0;
	else if (val[i]<0)
	  val[i]=0.0;
	}	
    
	data.param[L_ZYGO] = 	data.param[R_ZYGO] 	=val[0]; 
	data.param[L_ANGULI] = 	data.param[R_ANGULI] 	=val[1];
	data.param[IL_FRONT] = 	data.param[IR_FRONT] 	=val[2];
	data.param[OL_FRONT] = 	data.param[OR_FRONT] 	=val[3];
	data.param[L_LABI] = 	data.param[R_LABI] 	=val[4];
	data.param[L_CORR] = 	data.param[R_CORR] 	=val[5];
	data.param[NASI] 				=val[6];
	data.param[LAT_CORR]  	 			=val[7];
	data.param[ML_FRONT] = 	data.param[MR_FRONT] 	=val[8];
	data.param[JAW]					=val[9];
	data.param[LIP_Z]				=val[10]; 
	data.param[LIP_Y]				=val[11];
	data.param[MOUTH]				=val[12];
	data.param[I_XDIR]				=val[13];
	data.param[I_YDIR]				=val[14];
	data.param[YROT]				=val[15];
	data.param[XROT]				=val[16];
		

	send_data_packet(skt,&data,sizeof(packet_format));

	
    
    
}
/*** prepend_scene_cb ***/
void prepend_scene_cb(FL_OBJECT *,long)
{
   
   
    int		i,n,m;

    status("Pre-pend Scene --Pre-pends a pre-loaded scene to current scene");

    m= mngr.pick_board();
   
    if (m==-1) {
	return;
    }

    n= mngr.curr_num();

    if (n==m) {
	status("Sorry -- Cannot prepend a board to itself");
	return;
    }

    mngr.b[n]->prepend_scene(mngr.b[m]);
    mngr.redraw_board(-1);		// redraw current board
    
}
    

      

/*** reset_script_cb ***/
void 	reset_script_cb(FL_OBJECT *,long)
{
    // Set all the actors in current board to zero

    status("reset callback");

    int a=fl_show_question("Really Reset Scene",mngr.curr_title(),"");

    if (a==FALSE)	return;
    
    mngr.reset_board(-1);		// reset the current board
 
}


/*** exit_cb ***/
void	exit_cb(FL_OBJECT *,long)
{
    status("Gracefully Exiting Muscle Control Program");
    close((int)skt);		// Close the INET socket 
    system("gclear");
    exit(0);
}


/*** disp_scroll_cb ***/
void disp_scroll_cb(FL_OBJECT *,long )
{
    static 	int	status= FALSE;

    if (status==TRUE) {
	fl_hide_form(time_widget);
	status=FALSE;
    }
    else { //status==FALSE
	fl_show_form(time_widget,FL_PLACE_SIZE,TRUE,"Scene Display Options");
	status=TRUE;
    }
}




/*** scroll_cb ***/
void scroll_cb(FL_OBJECT *dev,long val)
{
    status("Scroll Callback",val);
    /* This takes care of alot the scrolling window callbacks */
    static float s_val=0.0;
    static float z_val=1.0;

    switch ( (int) val) {
      case 2:
	
	// Window Position Slider
	s_val = fl_get_slider_value(dev);
	mngr.scroll_board(-1,s_val,z_val);
	mngr.redraw_board(-1);		// redraw tge current board
	break;

      case 3:
	// Zoom Factor Slider
	z_val =  fl_get_slider_value(dev);
	mngr.scroll_board(-1,s_val,z_val);	// 0..1
	mngr.redraw_board(-1);		// redraw the current board
	break;
	
    }

}


void bbrowser_cb(FL_OBJECT *obj, long )
{
    int line,i;
    char	*brd_title;

    line = fl_get_browser(obj);
    brd_title  = fl_get_browser_line(obj,line);
    

    // Find the internal board #
    for (i=0;i<=mngr.num_boards; i++) 
      if ( strcmp(brd_title,mngr.b[i]->scene_title)==0)
	break;

    // Update the display and internal state variables;
    
    status("bbrowser_cb:: setting curr_board to:",i);
    mngr.set_curr_board(i); 
    fl_replace_browser_line(curr_board_lbl,1,mngr.b[i]->scene_title);
    
    if (mngr.b[i]->open==FALSE) { 	// If not open then open it
	mngr.show_board(i);
    }
    else 				// else POP it to the surface
      mngr.pop_board(i);


}    
















