/*** FILE "rgb.h" ************************************************** 130693 ***/
#ifndef _rgb_h_
#define _rgb_h_

/*** RGB **********************************************************************/

#define RGB(r,g,b) r<<8,g<<8,b<<8

#define BLACK   RGB(0,0,0)
#define GRAY(i) RGB(i,i,i)
#define WHITE   RGB(255,255,255)

#define MAX_R 65535
#define MAX_G 65535
#define MAX_B 65535

/*** Intensity, BitColor ******************************************************/

inline n16 Intensity(n16 red, n16 green, n16 blue)
{ return n16(0.299*double(red)+
             0.587*double(green)+
             0.114*double(blue));

/* Note: Truncation is exactly, what I want; despites being fast, it actually
 *       guarantees, that the truncated value never becomes bigger than 65535 as
 *       a result of rounding errors; 'double' has to be VERY imprecise, if that
 *       should be possible, since the untruncated value then should be at least
 *       65535.5!
 *       Even though the NTSC formula ain't strictly correct, -it depends on a
 *       lot of stuff-, it's the generally accepted way to translate colors to
 *       shades of gray!
 */
}

inline n1 BitIntensity(n16 red, n16 green, n16 blue)
{ return (0.299*double(red)+
          0.587*double(green)+
          0.114*double(blue))>=32768;

/* Note: Once again, the NTSC formula is used. See above.
 */
}

#endif
/******** "rgb.h" *************************************************************/

