/* module: 4dd_file.c echo file commands */

static char SccsId[] = "@(#)4dd_file.c	1.1";

#include <stdio.h>
#include <fcntl.h>
#include "4dd_echo.h"
#include "4dd_cyfile.h"

extern int errno;


/* The fetch command reads an image file into the current image buffer.  */

fetch(gs, cmd)					/* fill buffer from file */

GSPEC *gs;
char *cmd;
{
	char *name;
	FILE *fp;

	if ((cmd = nextword(cmd)) == 0) {
		name = "pic";
	} else {
		name = cmd;
	}

	fp = fopen(name, "r+");
	if (fp == NULL) {
		perror("fetch: cannot open file");
		return(-1);
	}

	if ((gs = cyread(gs, fileno(fp))) == NULL) {
		return(-1);
	}
	gs->saved = 1;
	gs->valid = 1;

	/* update old files to new lt/lgmax inclusive rule, not a sure fix */
	if (gs->ltmax >= gs->nlt) gs->ltmax = gs->nlt - 1;
	if (gs->lgmax >= gs->nlg) gs->lgmax = gs->nlg - 1;

#ifdef SUN
	display_init(gs);		/* set display defaults based on gs */
#endif

	fclose(fp);
	return(0);
}



/* The save command writes an image file from the current image buffer.  */

save(gs, cmd)

GSPEC *gs;
char *cmd;
{
	char *name = NULL;
	int fd;
	int length;

	if (gs->valid == 0) {
		puts("Invalid image");
		return(-1);
	}

	gs->flags &= ~FLAG_OLDHEADER;				/* default to old header */

	while ((cmd = nextword(cmd)) != 0) {		/* digest arguments */
		if (*cmd == '-') {
			while (*++cmd != 0) {
				switch (*cmd) {
				default:
					puts("Unrecognized option");
					return(-1);
				case 'o':
					gs->flags |= FLAG_OLDHEADER;
					break;
				}
			}
		} else {
				name = cmd;
		}
	}
	if (name == NULL) {
		name = "pic";
	}

	if ((fd = creat(name, CREATE_MODE)) == -1) {
		perror("save: problem creating file");
		return(-1);
	}
	if (cywrite(gs, fd) == -1) {
		return(-1);
	}

	gs->saved = 1;
	close(fd);
	return(0);
}
